<?php
session_start();
header('Content-Type: application/json');

require_once '../inc/db_connect.php';

$response = ['success' => false];

try {
    // 관리자 권한 체크
    if ($_SESSION['grade'] !== 'admin') {
        $response['error'] = '권한이 없습니다.';
        echo json_encode($response);
        exit;
    }
    
    // 현재 requested 상태인 모든 ID 가져오기
    $query = "SELECT id FROM transfer WHERE status = 'requested' AND type = 'deposit'";
    $result = mysqli_query($con, $query);
    
    $requestedIds = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $requestedIds[] = $row['id'];
    }
    
    // 세션에 저장
    if (!isset($_SESSION['acknowledged_requested_ids'])) {
        $_SESSION['acknowledged_requested_ids'] = [];
    }
    
    $_SESSION['acknowledged_requested_ids'] = array_unique(
        array_merge($_SESSION['acknowledged_requested_ids'], $requestedIds)
    );
    
    $response['success'] = true;
    $response['acknowledgedCount'] = count($requestedIds);
    
} catch (Exception $e) {
    $response['error'] = $e->getMessage();
}

if (isset($con)) {
    mysqli_close($con);
}

echo json_encode($response);
?>