<?php
session_start();
header('Content-Type: application/json');

require_once '../inc/db_connect.php';

$response = [
    'hasPending' => false,
    'hasRequested' => false,
    'hasCompleted' => false,
    'pendingCount' => 0,
    'requestedCount' => 0,
    'completedCount' => 0,
    'newDeposits' => []
];

try {
    // 세션 확인
    if (!isset($_SESSION['id'])) {
        echo json_encode($response);
        exit;
    }
    
    // 마지막 체크 시간 가져오기
    $sessionUserId = $_SESSION['id'];
    $lastCheckKey = 'last_deposit_check_' . $sessionUserId;
    $lastCheck = $_SESSION[$lastCheckKey] ?? date('Y-m-d H:i:s', strtotime('-1 minute'));
    $currentTime = date('Y-m-d H:i:s');
    
    // ===== Pending 상태 체크 =====
    $pendingQuery = "
        SELECT 
            t.id,
            t.depositor_name as name,
            t.amount,
            t.status,
            t.created_at,
            m.user_name as store_name
        FROM transfer t
        LEFT JOIN member m ON t.user_id = m.id
        WHERE t.status = 'pending'
        AND t.type = 'deposit'
        ORDER BY t.created_at DESC
    ";
    
    $result = mysqli_query($con, $pendingQuery);
    $pendingCount = mysqli_num_rows($result);
    
    if ($pendingCount > 0) {
        $response['hasPending'] = true;
        $response['pendingCount'] = $pendingCount;
        
        while ($row = mysqli_fetch_assoc($result)) {
            $response['newDeposits'][] = [
                'id' => $row['id'],
                'name' => $row['name'] ?? '미입력',
                'amount' => number_format($row['amount']),
                'status' => 'pending',
                'store_name' => $row['store_name'] ?? '미지정',
                'created_at' => $row['created_at']
            ];
        }
    }
    
    // ===== Requested 상태 체크 =====
    $requestedQuery = "
        SELECT 
            t.id,
            t.depositor_name as name,
            t.amount,
            t.status,
            t.created_at,
            m.user_name as store_name
        FROM transfer t
        LEFT JOIN member m ON t.user_id = m.id
        WHERE t.status = 'requested'
        AND t.type = 'deposit'
        ORDER BY t.created_at DESC
    ";
    
    $result2 = mysqli_query($con, $requestedQuery);
    $requestedCount = mysqli_num_rows($result2);
    
    if ($requestedCount > 0) {
        $response['hasRequested'] = true;
        $response['requestedCount'] = $requestedCount;
        
        while ($row = mysqli_fetch_assoc($result2)) {
            $response['requestedDeposits'][] = [
                'id' => $row['id'],
                'name' => $row['name'] ?? '미입력',
                'amount' => number_format($row['amount']),
                'store_name' => $row['store_name'] ?? '미지정'
            ];
        }
    }
    
    // ===== 자동 승인 감지 (Completed로 변경된 항목) =====
    $lastCheckEscaped = mysqli_real_escape_string($con, $lastCheck);
    
    $completedQuery = "
        SELECT 
            t.id,
            t.depositor_name as name,
            t.amount,
            t.status,
            t.created_at,
            t.updated_at,
            m.user_name as store_name,
            m.user_id as store_user_id
        FROM transfer t
        LEFT JOIN member m ON t.user_id = m.id
        WHERE t.status = 'completed'
        AND t.type = 'deposit'
        AND t.updated_at IS NOT NULL
        AND t.updated_at > '$lastCheckEscaped'
        AND t.updated_at != t.created_at
        AND TIMESTAMPDIFF(SECOND, t.updated_at, NOW()) <= 30
        ORDER BY t.updated_at DESC
    ";
    
    $result3 = mysqli_query($con, $completedQuery);
    if ($result3) {
        $completedCount = mysqli_num_rows($result3);
        if ($completedCount > 0) {
            $response['hasCompleted'] = true;
            $response['completedCount'] = $completedCount;
            
            while ($row = mysqli_fetch_assoc($result3)) {
                $response['newDeposits'][] = [
                    'id' => $row['id'],
                    'name' => $row['name'] ?? '미입력',
                    'amount' => number_format($row['amount']),
                    'status' => 'completed',
                    'store_name' => $row['store_name'] ?? '미지정',
                    'store_user_id' => $row['store_user_id'] ?? '-',
                    'updated_at' => $row['updated_at'],
                    'auto_approved' => true
                ];
            }
        }
    }
    
    // 마지막 체크 시간 업데이트
    $_SESSION[$lastCheckKey] = $currentTime;
    
    $response['totalCount'] = $pendingCount + $requestedCount + ($completedCount ?? 0);
    
} catch (Exception $e) {
    $response['error'] = '오류: ' . $e->getMessage();
}

mysqli_close($con);
echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>