<?php
header('Content-Type: application/json');

$result = ['steps' => []];

try {
    $result['steps'][] = "1. PHP 시작됨";
    
    // 파일 경로 확인
    $session_file = '../inc/session.php';
    $result['session_file_path'] = $session_file;
    $result['file_exists'] = file_exists($session_file);
    $result['steps'][] = "2. 파일 존재 확인: " . ($result['file_exists'] ? 'YES' : 'NO');
    
    if (!$result['file_exists']) {
        // 다른 가능한 경로들 시도
        $possible_paths = [
            'inc/session.php',
            '../../inc/session.php',
            '../session.php',
            'session.php'
        ];
        
        foreach ($possible_paths as $path) {
            if (file_exists($path)) {
                $result['found_at'] = $path;
                $session_file = $path;
                break;
            }
        }
    }
    
    if (file_exists($session_file)) {
        $result['steps'][] = "3. session.php 파일 찾음: $session_file";
        
        // 파일 포함 전에 출력 버퍼링 시작
        ob_start();
        include $session_file;
        $include_output = ob_get_clean();
        
        $result['steps'][] = "4. session.php 포함됨";
        $result['include_output'] = $include_output;
        
        // PDO 객체 확인
        if (isset($pdo)) {
            $result['steps'][] = "5. PDO 객체 존재함";
            $result['pdo_class'] = get_class($pdo);
        } else {
            $result['steps'][] = "5. PDO 객체 없음";
            $result['available_vars'] = array_keys(get_defined_vars());
        }
    }
    
    $result['success'] = true;
    
} catch (Throwable $e) {
    $result['success'] = false;
    $result['error'] = $e->getMessage();
    $result['error_file'] = $e->getFile();
    $result['error_line'] = $e->getLine();
}

echo json_encode($result, JSON_PRETTY_PRINT);
?>