<?php
// ajax/export_transaction_history.php
session_start();

// 데이터베이스 연결
require_once '../inc/db_connect.php';

// 로그인 체크
if (!isset($_SESSION['id'])) {
    die('로그인이 필요합니다.');
}

// 파라미터 검증
if (!isset($_GET['user_id']) || empty($_GET['user_id'])) {
    die('가맹점 ID가 필요합니다.');
}

$user_id = mysqli_real_escape_string($con, $_GET['user_id']);
$type_filter = isset($_GET['type']) ? mysqli_real_escape_string($con, $_GET['type']) : '';
$date_from = isset($_GET['date_from']) && !empty($_GET['date_from']) 
    ? mysqli_real_escape_string($con, $_GET['date_from']) 
    : date('Y-m-d', strtotime('-2 days'));
$date_to = isset($_GET['date_to']) && !empty($_GET['date_to']) 
    ? mysqli_real_escape_string($con, $_GET['date_to']) 
    : date('Y-m-d');

// 1. 가맹점 정보 조회
$member_query = "
    SELECT id, user_id, user_name, amount 
    FROM member 
    WHERE user_id = '$user_id'
";

$member_result = mysqli_query($con, $member_query);

if (!$member_result || mysqli_num_rows($member_result) == 0) {
    die('존재하지 않는 가맹점입니다.');
}

$member = mysqli_fetch_assoc($member_result);
$member_id = $member['id'];
$member_name = $member['user_name'];

// 2. WHERE 조건 생성 - 테이블별로 분리
$th_where_clause = "";
$mt_where_clause = "";

// 날짜 필터
if ($date_from) {
    $th_where_clause .= " AND DATE(th.created_at) >= '$date_from'";
    $mt_where_clause .= " AND DATE(mt.created_at) >= '$date_from'";
}
if ($date_to) {
    $th_where_clause .= " AND DATE(th.created_at) <= '$date_to'";
    $mt_where_clause .= " AND DATE(mt.created_at) <= '$date_to'";
}

// 유형 필터
if ($type_filter === 'deposit') {
    $th_where_clause .= " AND th.type = 'deposit'";
    $mt_where_clause .= " AND mt.type = 'deposit'";
} elseif ($type_filter === 'withdraw') {
    $th_where_clause .= " AND th.type = 'withdraw'";
    $mt_where_clause .= " AND mt.type = 'withdraw'";
}

// 3. 통합 거래내역 조회 (전체 데이터) - transfer 테이블 조인 추가
$transactions_query = "
    (
        SELECT 
            th.created_at,
            CASE 
                WHEN th.type = 'deposit' THEN '입금'
                WHEN th.type = 'withdraw' THEN '출금'
            END as type_text,
            th.actual_amount as amount,
            th.balance_before,
            th.balance_after,
            '' as memo,
            'SYSTEM' as admin_name,
            'normal' as source,
            COALESCE(t.depositor_name, '-') as depositor_name,
            COALESCE(t.updated_at, th.created_at) as processed_at
        FROM transaction_history th
        LEFT JOIN transfer t ON th.transfer_id = t.id
        WHERE th.user_id = $member_id 
            AND th.status = 'completed'
            $th_where_clause
    )
    UNION ALL
    (
        SELECT 
            mt.created_at,
            CASE 
                WHEN mt.type = 'deposit' THEN '수동입금'
                WHEN mt.type = 'withdraw' THEN '수동출금'
            END as type_text,
            mt.amount,
            mt.balance_before,
            mt.balance_after,
            IFNULL(mt.memo, '') as memo,
            mt.admin_id as admin_name,
            'manual' as source,
            '-' as depositor_name,
            mt.created_at as processed_at
        FROM manual_transactions mt
        WHERE mt.member_user_id = '$user_id'
            AND mt.status = 'completed'
            $mt_where_clause
    )
    ORDER BY created_at DESC
";

$result = mysqli_query($con, $transactions_query);

// 엑셀 파일명 생성
$filename = "거래내역_{$member_name}_" . date('Ymd_His') . ".csv";

// CSV 헤더 설정 (UTF-8 BOM 추가로 한글 깨짐 방지)
header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Pragma: no-cache');
header('Expires: 0');

// UTF-8 BOM 출력 (엑셀에서 한글 인식)
echo "\xEF\xBB\xBF";

// 파일 출력 스트림 열기
$output = fopen('php://output', 'w');

// CSV 헤더 작성 - 입금자명, 처리일시 추가
fputcsv($output, [
    '거래일시',
    '구분',
    '금액',
    '거래전잔액',
    '거래후잔액',
    '입금자명',        // 추가
    '처리일시',        // 추가
    '메모',
    '처리자'
]);

// 데이터 작성
$total_deposit = 0;
$total_withdraw = 0;

while ($row = mysqli_fetch_assoc($result)) {
    // 통계 계산
    if (strpos($row['type_text'], '입금') !== false) {
        $total_deposit += $row['amount'];
    } else {
        $total_withdraw += $row['amount'];
    }
    
    // CSV 행 작성 - 새로운 컬럼들 추가
    fputcsv($output, [
        date('Y-m-d H:i:s', strtotime($row['created_at'])),
        $row['type_text'],
        number_format($row['amount']),
        number_format($row['balance_before']),
        number_format($row['balance_after']),
        $row['depositor_name'] ?: '-',     // 입금자명
        $row['processed_at'] ? date('Y-m-d H:i:s', strtotime($row['processed_at'])) : '-',  // 처리일시
        $row['memo'] ?: '-',
        $row['admin_name']
    ]);
}

// 빈 행 추가
fputcsv($output, []);

// 요약 정보 추가
fputcsv($output, ['=== 요약 정보 ===']);
fputcsv($output, ['가맹점명', $member_name]);
fputcsv($output, ['조회기간', $date_from . ' ~ ' . $date_to]);
fputcsv($output, ['현재잔액', number_format($member['amount']) . '원']);
fputcsv($output, ['총 입금액', number_format($total_deposit) . '원']);
fputcsv($output, ['총 출금액', number_format($total_withdraw) . '원']);

// 스트림 닫기
fclose($output);

// 데이터베이스 연결 종료
mysqli_close($con);
exit();
?>