<?php
header('Content-Type: application/json');

try {
    include '../inc/session.php';
    
    if (!isset($con)) {
        throw new Exception('DB 연결 없음');
    }

    // 파라미터 받기
    $date = $_GET['date'] ?? date('Y-m-d');
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 9; // 페이지당 9개
    $offset = ($page - 1) * $limit;
    
    // 검색 파라미터
    $search = $_GET['search'] ?? '';
    $grade = $_GET['grade'] ?? '';
    
    // 검색 조건 생성
    $searchCondition = '';
    if (!empty($search)) {
        $search_escaped = mysqli_real_escape_string($con, $search);
        $searchCondition = "AND (m.user_name LIKE '%$search_escaped%' 
                            OR m.code LIKE '%$search_escaped%'
                            OR m.account_holder LIKE '%$search_escaped%')";
    }
    
    // 등급 조건 생성
    $gradeCondition = '';
    if (!empty($grade)) {
        $grade_escaped = mysqli_real_escape_string($con, $grade);
        $gradeCondition = "AND m.grade = '$grade_escaped'";
    }
    
    // 레벨 조건 (레벨 1, 2만 조회) + grade basic만 조회
    $levelCondition = "AND m.level IN (1, 2) AND m.grade = 'basic'";
    
    // 전체 조건
    $whereCondition = "WHERE 1=1 $levelCondition $searchCondition $gradeCondition";
    
    // 전체 가맹점 수 조회
    $countSql = "SELECT COUNT(*) as total FROM member m $whereCondition";
    $countResult = mysqli_query($con, $countSql);
    if (!$countResult) {
        throw new Exception('카운트 쿼리 실패: ' . mysqli_error($con));
    }
    $totalCount = mysqli_fetch_assoc($countResult)['total'];
    $totalPages = ceil($totalCount / $limit);
    
    // 가맹점 목록 조회
    $storesSql = "SELECT 
                    m.id,
                    m.user_name as store_name,
                    m.code,
                    m.grade,
                    m.level,
                    m.rate,
                    m.amount as balance,
                    m.bank,
                    m.account_holder,
                    m.account_number,
                    m.phone_number,
                    m.created_at,
                    m.updated_at
                FROM member m
                $whereCondition
                ORDER BY m.created_at DESC
                LIMIT $limit OFFSET $offset";
    
    $storesResult = mysqli_query($con, $storesSql);
    if (!$storesResult) {
        throw new Exception('가맹점 조회 실패: ' . mysqli_error($con));
    }
    
    $stores = [];
    while ($store = mysqli_fetch_assoc($storesResult)) {
        $storeId = $store['id'];
        
        // 선택한 날짜의 입금 총액 계산 (transfer 테이블에서)
        $depositSql = "SELECT COALESCE(SUM(amount), 0) as total 
                      FROM transfer 
                      WHERE user_id = $storeId 
                      AND type = 'deposit' 
                      AND status = 'completed'
                      AND DATE(created_at) = '$date'";
        $depositResult = mysqli_query($con, $depositSql);
        $dailyDeposit = mysqli_fetch_assoc($depositResult)['total'];
        
        // 선택한 날짜의 출금 총액 계산 (transfer 테이블에서)
        $withdrawSql = "SELECT COALESCE(SUM(amount), 0) as total 
                       FROM transfer 
                       WHERE user_id = $storeId 
                       AND type = 'withdraw' 
                       AND status = 'completed'
                       AND DATE(created_at) = '$date'";
        $withdrawResult = mysqli_query($con, $withdrawSql);
        $dailyWithdraw = mysqli_fetch_assoc($withdrawResult)['total'];
        
        // QR 코드 이미지 경로 생성 (코드 기반)
        $qrImagePath = '';
        if (!empty($store['code'])) {
            // QR 코드 파일명 패턴 추측 (실제 패턴에 맞게 수정 필요)
            $qrFileName = 'qr_' . $store['code'] . '.png';
            $qrFullPath = '/qrs/' . $qrFileName;
            
            // 파일 존재 여부 확인 (선택적)
            // if (file_exists($_SERVER['DOCUMENT_ROOT'] . $qrFullPath)) {
            //     $qrImagePath = $qrFullPath;
            // }
            $qrImagePath = $qrFullPath; // 일단 경로만 생성
        }
        
        // 오늘의 거래 건수
        $transactionCountSql = "SELECT COUNT(*) as count 
                               FROM transfer 
                               WHERE user_id = $storeId 
                               AND status = 'completed'
                               AND DATE(created_at) = '$date'";
        $transactionCountResult = mysqli_query($con, $transactionCountSql);
        $transactionCount = mysqli_fetch_assoc($transactionCountResult)['count'];
        
        // 이번 달 총 입금액
        $monthlyDepositSql = "SELECT COALESCE(SUM(amount), 0) as total 
                             FROM transfer 
                             WHERE user_id = $storeId 
                             AND type = 'deposit' 
                             AND status = 'completed'
                             AND YEAR(created_at) = YEAR('$date')
                             AND MONTH(created_at) = MONTH('$date')";
        $monthlyDepositResult = mysqli_query($con, $monthlyDepositSql);
        $monthlyDeposit = mysqli_fetch_assoc($monthlyDepositResult)['total'];
        
        // 이번 달 총 출금액
        $monthlyWithdrawSql = "SELECT COALESCE(SUM(amount), 0) as total 
                              FROM transfer 
                              WHERE user_id = $storeId 
                              AND type = 'withdraw' 
                              AND status = 'completed'
                              AND YEAR(created_at) = YEAR('$date')
                              AND MONTH(created_at) = MONTH('$date')";
        $monthlyWithdrawResult = mysqli_query($con, $monthlyWithdrawSql);
        $monthlyWithdraw = mysqli_fetch_assoc($monthlyWithdrawResult)['total'];
        
        $stores[] = [
            'id' => (int)$store['id'],
            'store_name' => $store['store_name'],
            'code' => $store['code'],
            'grade' => $store['grade'],
            'level' => (int)$store['level'],
            'rate' => (float)$store['rate'],
            'balance' => (int)$store['balance'],
            'bank' => $store['bank'],
            'account_holder' => $store['account_holder'],
            'account_number' => $store['account_number'],
            'phone_number' => $store['phone_number'],
            'qr_image' => $qrImagePath,
            'daily_deposit' => (int)$dailyDeposit,
            'daily_withdraw' => (int)$dailyWithdraw,
            'daily_net' => (int)($dailyDeposit - $dailyWithdraw),
            'transaction_count' => (int)$transactionCount,
            'monthly_deposit' => (int)$monthlyDeposit,
            'monthly_withdraw' => (int)$monthlyWithdraw,
            'created_at' => $store['created_at'],
            'updated_at' => $store['updated_at']
        ];
    }
    
    // 전체 통계 계산 (선택한 날짜 기준)
    $totalStatsSql = "SELECT 
                        (SELECT COALESCE(SUM(amount), 0) 
                         FROM transfer 
                         WHERE type = 'deposit' 
                         AND status = 'completed'
                         AND DATE(created_at) = '$date') as total_deposit,
                        (SELECT COALESCE(SUM(amount), 0) 
                         FROM transfer 
                         WHERE type = 'withdraw' 
                         AND status = 'completed'
                         AND DATE(created_at) = '$date') as total_withdraw";
    
    $totalStatsResult = mysqli_query($con, $totalStatsSql);
    $totalStats = mysqli_fetch_assoc($totalStatsResult);
    
    echo json_encode([
        'success' => true,
        'data' => [
            'stores' => $stores,
            'pagination' => [
                'current_page' => $page,
                'total_pages' => $totalPages,
                'total_items' => (int)$totalCount,
                'items_per_page' => $limit
            ],
            'stats' => [
                'date' => $date,
                'total_daily_deposit' => (int)$totalStats['total_deposit'],
                'total_daily_withdraw' => (int)$totalStats['total_withdraw'],
                'total_daily_net' => (int)($totalStats['total_deposit'] - $totalStats['total_withdraw'])
            ]
        ]
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>