<?php
include '../inc/db_connect.php';
session_start();

// 관리자 권한 확인
if (!isset($_SESSION['grade']) || $_SESSION['grade'] < 9) {
    echo json_encode(['success' => false, 'message' => '권한이 없습니다.']);
    exit;
}

$search_ip = mysqli_real_escape_string($con, $_GET['search_ip'] ?? '');
$status_filter = mysqli_real_escape_string($con, $_GET['status_filter'] ?? '');
$page = max(1, (int)($_GET['page'] ?? 1));
$per_page = 20;
$offset = ($page - 1) * $per_page;

// WHERE 조건 생성
$where = [];
if ($search_ip) {
    $where[] = "b.ip_address LIKE '%$search_ip%'";
}
if ($status_filter) {
    $where[] = "b.status = '$status_filter'";
}
$where_clause = $where ? "WHERE " . implode(" AND ", $where) : "";

// 전체 개수 조회
$count_sql = "SELECT COUNT(*) as total FROM ip_blacklist b $where_clause";
$count_result = mysqli_query($con, $count_sql);
$total = mysqli_fetch_assoc($count_result)['total'];
$total_pages = ceil($total / $per_page);

// 목록 조회
$sql = "SELECT b.*, m.user_name 
        FROM ip_blacklist b 
        LEFT JOIN member m ON b.user_id = m.user_id 
        $where_clause 
        ORDER BY b.created_at DESC 
        LIMIT $offset, $per_page";

$result = mysqli_query($con, $sql);
$blacklist = [];

while ($row = mysqli_fetch_assoc($result)) {
    $blacklist[] = $row;
}

echo json_encode([
    'success' => true,
    'blacklist' => $blacklist,
    'totalPages' => $total_pages,
    'currentPage' => $page
]);

mysqli_close($con);
?>