<?php
include '../inc/db_connect.php';
session_start();

// 관리자 권한 확인
if (!isset($_SESSION['grade']) || $_SESSION['grade'] < 9) {
    echo json_encode(['success' => false, 'message' => '권한이 없습니다.']);
    exit;
}

$sql = "SELECT 
        SUM(status = 'active') as active_count,
        SUM(status = 'expired') as expired_count,
        SUM(status = 'released') as released_count,
        COUNT(*) as total_count
        FROM ip_blacklist";

$result = mysqli_query($con, $sql);
$stats = mysqli_fetch_assoc($result);

// NULL 값을 0으로 변환
foreach ($stats as &$value) {
    $value = $value ?? 0;
}

echo json_encode([
    'success' => true,
    'stats' => $stats
]);

mysqli_close($con);
?>