<?php
// fetch_stores.php
session_start();
header('Content-Type: application/json; charset=UTF-8');

require_once '../inc/db_connect.php';

// 권한 체크
if (!isset($_SESSION['id'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => '권한이 없습니다.']);
    exit;
}

try {
    // 활성화된 가맹점 목록 조회
    $sql = "SELECT id, user_name as name, code 
            FROM member
            WHERE grade = 'basic' 
            ORDER BY user_name ASC";
    
    $result = mysqli_query($con, $sql);
    
    if (!$result) {
        throw new Exception('쿼리 실행 실패');
    }
    
    $stores = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $stores[] = [
            'id' => $row['id'],
            'name' => $row['name'],
            'code' => $row['code']
        ];
    }
    
    echo json_encode([
        'success' => true,
        'stores' => $stores
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    error_log('Fetch Stores Error: ' . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => '가맹점 목록 조회 실패'
    ], JSON_UNESCAPED_UNICODE);
    
} finally {
    if (isset($con) && $con) {
        mysqli_close($con);
    }
}
?>