<?php
header('Content-Type: application/json; charset=utf-8');
session_start();

// 로그인 확인
if (!isset($_SESSION['id'])) {
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

// 데이터베이스 연결
require_once '../inc/db_connect.php';

try {
    // settings 테이블에서 현재 자동 승인 설정 조회
    $query = "SELECT 
                auto_approval_wait_time
              FROM settings 
              ORDER BY id DESC 
              LIMIT 1";
    
    $result = mysqli_query($con, $query);
    
    if ($result && mysqli_num_rows($result) > 0) {
        $settings = mysqli_fetch_assoc($result);
        
        echo json_encode([
            'success' => true,
            'settings' => $settings
        ]);
    } else {
        // 설정이 없으면 기본값으로 초기화 (기본값: 60초 = 1분)
        $insertQuery = "INSERT INTO settings (
                          auto_approval_wait_time,
                          created_at,
                          updated_at
                        ) VALUES (60, NOW(), NOW())";
        
        if (mysqli_query($con, $insertQuery)) {
            echo json_encode([
                'success' => true,
                'settings' => [
                    'auto_approval_wait_time' => 60
                ]
            ]);
        } else {
            throw new Exception('기본 설정 생성 실패: ' . mysqli_error($con));
        }
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => '설정 조회 중 오류가 발생했습니다: ' . $e->getMessage()
    ]);
}

mysqli_close($con);
?>