<?php
// ajax/get_member_balance.php
header('Content-Type: application/json; charset=UTF-8');

// 세션 시작
session_start();

// 데이터베이스 연결
require_once '../inc/db_connect.php';

// 응답 데이터 초기화
$response = [
    'success' => false,
    'message' => '',
    'balance' => 0
];

try {
    // 로그인 체크
    if (!isset($_SESSION['id'])) {
        throw new Exception('로그인이 필요합니다.');
    }

    // 요청 파라미터 검증
    if (!isset($_GET['user_id']) || empty($_GET['user_id'])) {
        throw new Exception('가맹점 ID가 필요합니다.');
    }

    $user_id = mysqli_real_escape_string($con, $_GET['user_id']);

    // 가맹점 잔액 조회
    $query = "SELECT amount FROM member WHERE user_id = '$user_id' LIMIT 1";
    $result = mysqli_query($con, $query);

    if (!$result) {
        throw new Exception('데이터베이스 조회 중 오류가 발생했습니다.');
    }

    if (mysqli_num_rows($result) == 0) {
        throw new Exception('존재하지 않는 가맹점입니다.');
    }

    $member = mysqli_fetch_assoc($result);
    
    // 응답 데이터 설정
    $response['success'] = true;
    $response['balance'] = $member['amount'] ?: 0;

} catch (Exception $e) {
    $response['success'] = false;
    $response['message'] = $e->getMessage();
}

// JSON 응답 출력
echo json_encode($response, JSON_UNESCAPED_UNICODE);

// 데이터베이스 연결 종료
if (isset($con)) {
    mysqli_close($con);
}
?>