<?php
header('Content-Type: application/json; charset=utf-8');
session_start();

if (!isset($_SESSION["id"]) || empty($_SESSION["id"])) {
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

require_once '../inc/db_connect.php';

$user_id = $_GET['user_id'] ?? '';

if (empty($user_id)) {
    echo json_encode(['success' => false, 'message' => '잘못된 요청입니다.']);
    exit;
}

$user_id_escaped = mysqli_real_escape_string($con, $user_id);
$query = "SELECT * FROM member WHERE user_id = '$user_id_escaped'";
$result = mysqli_query($con, $query);

if ($result && $member = mysqli_fetch_assoc($result)) {
    // parents 컬럼 파싱
    $parents = json_decode($member['parents'] ?? '[]', true);
    
    // parent가 있으면 parent의 user_id 가져오기
    if (!empty($parents) && is_array($parents)) {
        $parent_id = $parents[0];
        $parent_query = "SELECT user_id, rate FROM member WHERE id = " . intval($parent_id);
        $parent_result = mysqli_query($con, $parent_query);
        
        if ($parent_result && $parent_row = mysqli_fetch_assoc($parent_result)) {
            $member['parent_user_id'] = $parent_row['user_id'];
            $member['parent_rate'] = $parent_row['rate'];
        }
    }
    
    // kakao_link_type이 null인 경우 빈 문자열로 처리 (선택사항)
    if (is_null($member['kakao_link_type'])) {
        $member['kakao_link_type'] = '';
    }
    
    echo json_encode(['success' => true, 'member' => $member]);
} else {
    echo json_encode(['success' => false, 'message' => '가맹점을 찾을 수 없습니다.']);
}
?>