<?php
header('Content-Type: application/json');

// 데이터베이스 연결
include '../inc/session.php';

// 로그인 체크
if (!isset($_SESSION['id'])) {
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

// GET 파라미터 받기
$user_id = $_GET['user_id'] ?? '';

if (empty($user_id)) {
    echo json_encode(['success' => false, 'message' => '가맹점 정보가 없습니다.']);
    exit;
}

try {
    // 가맹점의 수수료율 조회
    $query = "SELECT rate FROM member WHERE user_id = ?";
    $stmt = mysqli_prepare($con, $query);
    
    if (!$stmt) {
        throw new Exception("쿼리 준비 실패: " . mysqli_error($con));
    }
    
    mysqli_stmt_bind_param($stmt, "s", $user_id);
    
    if (!mysqli_stmt_execute($stmt)) {
        throw new Exception("쿼리 실행 실패: " . mysqli_stmt_error($stmt));
    }
    
    $result = mysqli_stmt_get_result($stmt);
    
    if ($row = mysqli_fetch_assoc($result)) {
        echo json_encode([
            'success' => true,
            'rate' => $row['rate'] ?? 0,
            'user_id' => $user_id
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => '가맹점을 찾을 수 없습니다.'
        ]);
    }
    
    mysqli_stmt_close($stmt);
    
} catch (Exception $e) {
    error_log("가맹점 수수료율 조회 오류: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => '조회 중 오류가 발생했습니다.'
    ]);
} finally {
    if (isset($con)) {
        mysqli_close($con);
    }
}
?>