<?php
header('Content-Type: application/json; charset=utf-8');
session_start();

// 로그인 확인
if (!isset($_SESSION['id'])) {
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

// 관리자 권한 확인
// if ($_SESSION['login_grade'] !== 'admin') {
//     echo json_encode(['success' => false, 'message' => '권한이 없습니다.']);
//     exit;
// }

// 데이터베이스 연결
require_once '../inc/db_connect.php';

try {
    // settings 테이블에서 사운드 설정 조회
    $query = "SELECT 
                sound_enabled,
                master_volume,
                withdrawal_sound_enabled,
                withdrawal_volume,
                withdrawal_sound_file,
                deposit_pending_sound_enabled,
                deposit_pending_volume,
                deposit_pending_sound_file,
                deposit_requested_sound_enabled,
                deposit_requested_volume,
                deposit_requested_sound_file,
                deposit_requested_repeat
              FROM settings 
              ORDER BY id DESC 
              LIMIT 1";
    
    $result = mysqli_query($con, $query);
    
    if ($result && mysqli_num_rows($result) > 0) {
        $settings = mysqli_fetch_assoc($result);
        
        echo json_encode([
            'success' => true,
            'settings' => $settings
        ]);
    } else {
        // 설정이 없으면 기본값으로 응답
        echo json_encode([
            'success' => true,
            'settings' => [
                'sound_enabled' => 1,
                'master_volume' => 70,
                'withdrawal_sound_enabled' => 1,
                'withdrawal_volume' => 70,
                'withdrawal_sound_file' => 'exchange.mp3',
                'deposit_pending_sound_enabled' => 1,
                'deposit_pending_volume' => 50,
                'deposit_pending_sound_file' => 'charge.mp3',
                'deposit_requested_sound_enabled' => 1,
                'deposit_requested_volume' => 60,
                'deposit_requested_sound_file' => 'request.mp3',
                'deposit_requested_repeat' => 1
            ]
        ]);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => '설정 조회 중 오류가 발생했습니다: ' . $e->getMessage()
    ]);
}

mysqli_close($con);
?>