<?php
header('Content-Type: application/json; charset=UTF-8');
session_start();

if (!isset($_SESSION['id'])) {
    echo json_encode(['success' => false, 'message' => '권한이 없습니다.']);
    exit;
}

require_once '../inc/db_connect.php';

try {
    // 사용자 등급 확인
    $user_id = $_SESSION['id'];
    $userQuery = "SELECT grade FROM member WHERE user_id = ?";
    $stmt = mysqli_prepare($con, $userQuery);
    mysqli_stmt_bind_param($stmt, "s", $user_id);
    mysqli_stmt_execute($stmt);
    $userResult = mysqli_stmt_get_result($stmt);
    $user = mysqli_fetch_assoc($userResult);
    
    if (!$user) {
        throw new Exception('사용자 정보를 찾을 수 없습니다.');
    }
    
    // 출금 설정 조회
    $settingsQuery = "SELECT * FROM settings LIMIT 1";
    $settingsResult = mysqli_query($con, $settingsQuery);
    $settings = mysqli_fetch_assoc($settingsResult);
    
    if (!$settings) {
        // 설정이 없으면 기본값
        $response = [
            'success' => true,
            'user_grade' => $user['grade'],
            'is_blocked' => false,
            'block_info' => null
        ];
    } else {
        $current_time = date('H:i');
        $current_minute = (int)date('i');
        $is_blocked = false;
        $block_info = null;
        
        // 1. 매시간 차단 확인 (모든 등급에 적용, 최우선)
        if ($settings['hourly_withdraw_block_enabled'] && $current_minute >= 50) {
            $is_blocked = true;
            $block_info = [
                'type' => 'hourly',
                'start_time' => sprintf('%02d:50', (int)date('H')),
                'end_time' => sprintf('%02d:00', ((int)date('H') + 1) % 24),
                'grade_name' => '매시간 자동 차단 (50분~정각)'
            ];
        }
        
        // 2. 등급별 차단 시간 확인 (매시간 차단이 없을 때만)
        if (!$is_blocked) {
            if ($user['grade'] === 'partner' && $settings['partner_withdraw_block_enabled']) {
                $start = $settings['partner_withdraw_block_start'];
                $end = $settings['partner_withdraw_block_end'];
                
                if ($start && $end) {
                    $is_blocked = isTimeInRange($current_time, $start, $end);
                    if ($is_blocked) {
                        $block_info = [
                            'type' => 'grade',
                            'start_time' => $start,
                            'end_time' => $end,
                            'grade_name' => '총판'
                        ];
                    }
                }
            } elseif ($user['grade'] === 'basic' && $settings['basic_withdraw_block_enabled']) {
                $start = $settings['basic_withdraw_block_start'];
                $end = $settings['basic_withdraw_block_end'];
                
                if ($start && $end) {
                    $is_blocked = isTimeInRange($current_time, $start, $end);
                    if ($is_blocked) {
                        $block_info = [
                            'type' => 'grade',
                            'start_time' => $start,
                            'end_time' => $end,
                            'grade_name' => '가맹점'
                        ];
                    }
                }
            }
        }
        
        $response = [
            'success' => true,
            'user_grade' => $user['grade'],
            'is_blocked' => $is_blocked,
            'block_info' => $block_info,
            'current_time' => $current_time,
            'current_minute' => $current_minute,
            'settings' => [
                'hourly_enabled' => (bool)$settings['hourly_withdraw_block_enabled'],
                'partner_enabled' => (bool)$settings['partner_withdraw_block_enabled'],
                'basic_enabled' => (bool)$settings['basic_withdraw_block_enabled']
            ]
        ];
    }
    
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}

// 시간 범위 체크 함수 (자정 넘나드는 시간 포함)
function isTimeInRange($current, $start, $end) {
    $current = strtotime($current);
    $start = strtotime($start);
    $end = strtotime($end);
    
    if ($start <= $end) {
        // 같은 날 시간 (예: 12:00 ~ 13:00)
        return ($current >= $start && $current <= $end);
    } else {
        // 자정 넘나드는 시간 (예: 23:00 ~ 06:00)
        return ($current >= $start || $current <= $end);
    }
}

mysqli_close($con);
?>