<?php
include '../inc/db_connect.php';
session_start();

// 관리자 권한 확인
if (!isset($_SESSION['grade']) || $_SESSION['grade'] < 9) {
    echo json_encode(['success' => false, 'message' => '권한이 없습니다.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$ip_address = mysqli_real_escape_string($con, $data['ip_address'] ?? '');

if (!$ip_address) {
    echo json_encode(['success' => false, 'message' => 'IP 주소가 필요합니다.']);
    exit;
}

// 트랜잭션 시작
mysqli_begin_transaction($con);

try {
    // 1. IP 블랙리스트 테이블 업데이트
    $sql1 = "UPDATE ip_blacklist 
            SET status = 'released', 
                blocked_until = NULL,
                updated_at = NOW() 
            WHERE ip_address = '$ip_address'";
    
    if (!mysqli_query($con, $sql1)) {
        throw new Exception('IP 블랙리스트 업데이트 실패');
    }
    
    // 2. 해당 IP와 연관된 사용자 찾기 (ip_blacklist 테이블에서)
    $sql_find_user = "SELECT user_id FROM ip_blacklist WHERE ip_address = '$ip_address' AND user_id IS NOT NULL";
    $result = mysqli_query($con, $sql_find_user);
    
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $user_id = mysqli_real_escape_string($con, $row['user_id']);
            
            // 3. member 테이블의 계정 잠금 해제
            $sql2 = "UPDATE member 
                    SET account_locked = 0,
                        locked_until = NULL,
                        failed_login_attempts = 0,
                        last_failed_login = NULL
                    WHERE user_id = '$user_id'";
            
            if (!mysqli_query($con, $sql2)) {
                throw new Exception('회원 계정 잠금 해제 실패');
            }
        }
    }
    
    // 4. 최근 로그인 시도 기록에서도 해당 IP의 차단 기록 업데이트 (선택사항)
    // $sql3 = "UPDATE login_attempts 
    //         SET attempt_type = 'released' 
    //         WHERE ip_address = '$ip_address' 
    //         AND attempt_type = 'blocked' 
    //         AND attempted_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR)";
    
    // mysqli_query($con, $sql3); // 실패해도 무시
    
    // 트랜잭션 커밋
    mysqli_commit($con);
    
    // 영향받은 회원 수 확인
    $affected_users = mysqli_affected_rows($con);
    
    echo json_encode([
        'success' => true, 
        'message' => "IP 차단이 해제되었습니다. (영향받은 사용자: {$affected_users}명)",
        'affected_users' => $affected_users
    ]);
    
} catch (Exception $e) {
    // 트랜잭션 롤백
    mysqli_rollback($con);
    echo json_encode([
        'success' => false, 
        'message' => 'DB 오류: ' . $e->getMessage()
    ]);
}

mysqli_close($con);
?>