<?php
header('Content-Type: application/json; charset=utf-8');
session_start();

// 로그인 확인
if (!isset($_SESSION['id'])) {
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

// 데이터베이스 연결
require_once '../inc/db_connect.php';

try {
    // POST 데이터 받기
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['auto_approval_wait_time'])) {
        throw new Exception('필수 데이터가 누락되었습니다.');
    }
    
    $waitTime = intval($input['auto_approval_wait_time']);
    
    // 유효성 검증 (60초 ~ 300초)
    if ($waitTime < 60 || $waitTime > 300) {
        throw new Exception('설정 가능한 시간은 60초(1분)부터 300초(5분)까지입니다.');
    }
    
    // 기존 설정이 있는지 확인
    $checkQuery = "SELECT id FROM settings ORDER BY id DESC LIMIT 1";
    $checkResult = mysqli_query($con, $checkQuery);
    
    if ($checkResult && mysqli_num_rows($checkResult) > 0) {
        // 기존 설정 업데이트
        $row = mysqli_fetch_assoc($checkResult);
        $settingId = $row['id'];
        
        $updateQuery = "UPDATE settings 
                       SET auto_approval_wait_time = ?,
                           updated_at = NOW()
                       WHERE id = ?";
        
        $stmt = mysqli_prepare($con, $updateQuery);
        mysqli_stmt_bind_param($stmt, "ii", $waitTime, $settingId);
        
        if (mysqli_stmt_execute($stmt)) {
            echo json_encode([
                'success' => true,
                'message' => '자동 승인 설정이 저장되었습니다.',
                'settings' => [
                    'auto_approval_wait_time' => $waitTime
                ]
            ]);
        } else {
            throw new Exception('설정 업데이트 실패: ' . mysqli_error($con));
        }
        
        mysqli_stmt_close($stmt);
        
    } else {
        // 새로운 설정 생성
        $insertQuery = "INSERT INTO settings (
                          auto_approval_wait_time,
                          created_at,
                          updated_at
                        ) VALUES (?, NOW(), NOW())";
        
        $stmt = mysqli_prepare($con, $insertQuery);
        mysqli_stmt_bind_param($stmt, "i", $waitTime);
        
        if (mysqli_stmt_execute($stmt)) {
            echo json_encode([
                'success' => true,
                'message' => '자동 승인 설정이 생성되었습니다.',
                'settings' => [
                    'auto_approval_wait_time' => $waitTime
                ]
            ]);
        } else {
            throw new Exception('설정 생성 실패: ' . mysqli_error($con));
        }
        
        mysqli_stmt_close($stmt);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

mysqli_close($con);
?>