<?php
include '../inc/session.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

try {
    $partner_maintenance = intval($data['partner_maintenance_enabled']);
    $user_maintenance = intval($data['user_maintenance_enabled']);
    
    $sql = "UPDATE settings SET 
            partner_maintenance_enabled = ?,
            user_maintenance_enabled = ?,
            updated_at = CURRENT_TIMESTAMP
            WHERE id = 1";
    
    $stmt = mysqli_prepare($con, $sql);
    mysqli_stmt_bind_param($stmt, "ii", $partner_maintenance, $user_maintenance);
    
    if (mysqli_stmt_execute($stmt)) {
        echo json_encode(['success' => true]);
    } else {
        throw new Exception('설정 저장 실패');
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>