<?php
header('Content-Type: application/json; charset=utf-8');
session_start();

// 로그인 확인
if (!isset($_SESSION['id'])) {
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

// 관리자 권한 확인
// if ($_SESSION['login_grade'] !== 'admin') {
//     echo json_encode(['success' => false, 'message' => '권한이 없습니다.']);
//     exit;
// }

// 데이터베이스 연결
require_once '../inc/db_connect.php';

// JSON 데이터 받기
$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    echo json_encode(['success' => false, 'message' => '잘못된 요청입니다.']);
    exit;
}

try {
    // 먼저 settings 테이블에 레코드가 있는지 확인
    $checkQuery = "SELECT id FROM settings LIMIT 1";
    $checkResult = mysqli_query($con, $checkQuery);
    
    if (mysqli_num_rows($checkResult) > 0) {
        // 기존 레코드 업데이트
        $updateQuery = "UPDATE settings SET 
                        sound_enabled = ?,
                        master_volume = ?,
                        withdrawal_sound_enabled = ?,
                        withdrawal_volume = ?,
                        deposit_pending_sound_enabled = ?,
                        deposit_pending_volume = ?,
                        deposit_requested_sound_enabled = ?,
                        deposit_requested_volume = ?,
                        deposit_requested_repeat = ?,
                        updated_at = NOW()";
        
        $stmt = mysqli_prepare($con, $updateQuery);
        
        mysqli_stmt_bind_param($stmt, "iiiiiiiii",
            $input['sound_enabled'],
            $input['master_volume'],
            $input['withdrawal_sound_enabled'],
            $input['withdrawal_volume'],
            $input['deposit_pending_sound_enabled'],
            $input['deposit_pending_volume'],
            $input['deposit_requested_sound_enabled'],
            $input['deposit_requested_volume'],
            $input['deposit_requested_repeat']
        );
        
    } else {
        // 새 레코드 삽입
        $insertQuery = "INSERT INTO settings (
                        sound_enabled,
                        master_volume,
                        withdrawal_sound_enabled,
                        withdrawal_volume,
                        withdrawal_sound_file,
                        deposit_pending_sound_enabled,
                        deposit_pending_volume,
                        deposit_pending_sound_file,
                        deposit_requested_sound_enabled,
                        deposit_requested_volume,
                        deposit_requested_sound_file,
                        deposit_requested_repeat,
                        created_at,
                        updated_at
                      ) VALUES (?, ?, ?, ?, 'exchange.mp3', ?, ?, 'charge.mp3', ?, ?, 'request.mp3', ?, NOW(), NOW())";
        
        $stmt = mysqli_prepare($con, $insertQuery);
        
        mysqli_stmt_bind_param($stmt, "iiiiiiiii",
            $input['sound_enabled'],
            $input['master_volume'],
            $input['withdrawal_sound_enabled'],
            $input['withdrawal_volume'],
            $input['deposit_pending_sound_enabled'],
            $input['deposit_pending_volume'],
            $input['deposit_requested_sound_enabled'],
            $input['deposit_requested_volume'],
            $input['deposit_requested_repeat']
        );
    }
    
    if (mysqli_stmt_execute($stmt)) {
        echo json_encode([
            'success' => true,
            'message' => '사운드 설정이 저장되었습니다.'
        ]);
    } else {
        throw new Exception('설정 저장 실패: ' . mysqli_error($con));
    }
    
    mysqli_stmt_close($stmt);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => '설정 저장 중 오류가 발생했습니다: ' . $e->getMessage()
    ]);
}

mysqli_close($con);
?>