<?php
header('Content-Type: application/json; charset=utf-8');
session_start();

// 로그인 및 관리자 확인
if (!isset($_SESSION['id'])) {
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

require_once '../inc/db_connect.php';

// 파일 업로드 처리
if (!isset($_FILES['sound_file']) || !isset($_POST['type'])) {
    echo json_encode(['success' => false, 'message' => '파일 또는 타입이 누락되었습니다.']);
    exit;
}

$file = $_FILES['sound_file'];
$type = $_POST['type'];

// 허용된 타입 체크
$allowedTypes = ['withdrawal', 'deposit-pending', 'deposit-requested'];
if (!in_array($type, $allowedTypes)) {
    echo json_encode(['success' => false, 'message' => '잘못된 타입입니다.']);
    exit;
}

// 파일 유효성 검사
$allowedExtensions = ['mp3', 'wav', 'ogg', 'm4a'];
$fileExtension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

if (!in_array($fileExtension, $allowedExtensions)) {
    echo json_encode(['success' => false, 'message' => '허용되지 않은 파일 형식입니다.']);
    exit;
}

// 파일 크기 체크 (5MB)
if ($file['size'] > 5 * 1024 * 1024) {
    echo json_encode(['success' => false, 'message' => '파일 크기는 5MB 이하여야 합니다.']);
    exit;
}

// 업로드 디렉토리 설정
$uploadDir = '../assets/sound/custom/';
if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// 파일명 생성 (중복 방지)
$newFileName = $type . '_' . time() . '_' . uniqid() . '.' . $fileExtension;
$uploadPath = $uploadDir . $newFileName;

// 파일 업로드
if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
    // 데이터베이스 업데이트
    $dbField = '';
    switch($type) {
        case 'withdrawal':
            $dbField = 'withdrawal_sound_file';
            break;
        case 'deposit-pending':
            $dbField = 'deposit_pending_sound_file';
            break;
        case 'deposit-requested':
            $dbField = 'deposit_requested_sound_file';
            break;
    }
    
    // 이전 파일 정보 가져오기 (삭제용)
    $getOldFileQuery = "SELECT $dbField FROM settings LIMIT 1";
    $oldFileResult = mysqli_query($con, $getOldFileQuery);
    $oldFile = null;
    
    if ($oldFileResult && mysqli_num_rows($oldFileResult) > 0) {
        $row = mysqli_fetch_assoc($oldFileResult);
        $oldFile = $row[$dbField];
    }
    
    // 데이터베이스 업데이트
    $updateQuery = "UPDATE settings SET $dbField = ?, updated_at = NOW()";
    $stmt = mysqli_prepare($con, $updateQuery);
    
    // 웹 경로로 저장 (assets 폴더부터)
    $webPath = '/assets/sound/custom/' . $newFileName;
    mysqli_stmt_bind_param($stmt, "s", $webPath);
    
    if (mysqli_stmt_execute($stmt)) {
        // 이전 커스텀 파일 삭제 (기본 파일이 아닌 경우만)
        if ($oldFile && strpos($oldFile, '/custom/') !== false) {
            $oldFilePath = '../' . ltrim($oldFile, '/');
            if (file_exists($oldFilePath)) {
                unlink($oldFilePath);
            }
        }
        
        echo json_encode([
            'success' => true,
            'message' => '사운드 파일이 성공적으로 업로드되었습니다.',
            'filename' => $newFileName,
            'filepath' => $webPath
        ]);
    } else {
        // DB 업데이트 실패 시 업로드된 파일 삭제
        unlink($uploadPath);
        echo json_encode([
            'success' => false,
            'message' => '데이터베이스 업데이트 실패: ' . mysqli_error($con)
        ]);
    }
    
    mysqli_stmt_close($stmt);
    
} else {
    echo json_encode([
        'success' => false,
        'message' => '파일 업로드 실패'
    ]);
}

mysqli_close($con);
?>