<?php
include 'layout/header.php';
?>

<main class="flex-1 p-6 space-y-6">
  <!-- API 소개 -->
  <div class="bg-gradient-to-r from-primary/20 to-secondary/20 border border-primary/20 rounded-xl p-6">
    <div class="flex items-center gap-3 mb-4">
      <div class="w-10 h-10 bg-gradient-to-br from-primary to-secondary rounded-xl flex items-center justify-center">
        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4"></path>
        </svg>
      </div>
      <div>
        <h1 class="text-2xl font-bold text-white">올인원 페이 API 문서</h1>
        <p class="text-gray-400">개발자를 위한 결제 시스템 API 가이드 v1.0</p>
      </div>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-4">
      <div class="bg-white/5 rounded-lg p-3 border border-white/10">
        <div class="text-sm text-gray-400">Base URL</div>
        <div class="text-white font-mono text-sm">https://mb-1010.com</div>
      </div>
      <div class="bg-white/5 rounded-lg p-3 border border-white/10">
        <div class="text-sm text-gray-400">Content-Type</div>
        <div class="text-white font-mono text-sm">application/json</div>
      </div>
      <div class="bg-white/5 rounded-lg p-3 border border-white/10">
        <div class="text-sm text-gray-400">API Version</div>
        <div class="text-white font-mono text-sm">v1.0</div>
      </div>
    </div>
  </div>

  <!-- 빠른 네비게이션 -->
  <div class="bg-white/5 rounded-xl p-4 border border-white/10">
    <h3 class="text-lg font-semibold text-white mb-4">빠른 이동</h3>
    <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
      <a href="#payment-create" class="flex items-center gap-2 p-3 bg-green-500/10 border border-green-500/20 rounded-lg hover:bg-green-500/20 transition-colors">
        <span class="w-2 h-2 bg-green-400 rounded-full"></span>
        <span class="text-green-400 text-sm">결제 생성</span>
      </a>
      <a href="#payment-status" class="flex items-center gap-2 p-3 bg-blue-500/10 border border-blue-500/20 rounded-lg hover:bg-blue-500/20 transition-colors">
        <span class="w-2 h-2 bg-blue-400 rounded-full"></span>
        <span class="text-blue-400 text-sm">상태 조회</span>
      </a>
      <a href="#callback" class="flex items-center gap-2 p-3 bg-purple-500/10 border border-purple-500/20 rounded-lg hover:bg-purple-500/20 transition-colors">
        <span class="w-2 h-2 bg-purple-400 rounded-full"></span>
        <span class="text-purple-400 text-sm">콜백 시스템</span>
      </a>
      <a href="#error-codes" class="flex items-center gap-2 p-3 bg-red-500/10 border border-red-500/20 rounded-lg hover:bg-red-500/20 transition-colors">
        <span class="w-2 h-2 bg-red-400 rounded-full"></span>
        <span class="text-red-400 text-sm">에러 코드</span>
      </a>
    </div>
  </div>

  <!-- 1. 결제 생성 API -->
  <div id="payment-create" class="bg-white/5 rounded-xl p-6 border border-white/10">
    <div class="flex items-center gap-3 mb-4">
      <span class="px-3 py-1 bg-green-500 text-white text-xs font-medium rounded-full">POST</span>
      <h2 class="text-xl font-semibold text-white">결제 요청 생성</h2>
    </div>

    <div class="mb-4">
      <div class="bg-gray-800 rounded-lg p-3 border border-gray-700">
        <code class="text-green-400 font-mono">POST /api/payment/create</code>
      </div>
    </div>

    <div class="space-y-4">
      <div>
        <h3 class="text-lg font-medium text-white mb-2">요청 파라미터</h3>
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm">
            <thead class="bg-gray-800 text-gray-300">
              <tr>
                <th class="px-4 py-2 text-left">파라미터</th>
                <th class="px-4 py-2 text-left">타입</th>
                <th class="px-4 py-2 text-left">필수</th>
                <th class="px-4 py-2 text-left">설명</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-white/10">
              <tr>
                <td class="px-4 py-2 font-mono text-primary">store_id</td>()
                <td class="px-4 py-2 text-gray-400">string</td>
                <td class="px-4 py-2"><span class="text-red-400">필수</span></td>
                <td class="px-4 py-2 text-gray-300">가맹점 코드</td>
              </tr>
              <tr>
                <td class="px-4 py-2 font-mono text-primary">amount</td>
                <td class="px-4 py-2 text-gray-400">number</td>
                <td class="px-4 py-2"><span class="text-red-400">필수</span></td>
                <td class="px-4 py-2 text-gray-300">결제 금액</td>
              </tr>
              <tr>
                <td class="px-4 py-2 font-mono text-primary">depositor_name</td>
                <td class="px-4 py-2 text-gray-400">string</td>
                <td class="px-4 py-2"><span class="text-red-400">필수</span></td>
                <td class="px-4 py-2 text-gray-300">입금자명 (2글자 이상)</td>
              </tr>
              <tr>
                <td class="px-4 py-2 font-mono text-primary">session_id</td>
                <td class="px-4 py-2 text-gray-400">string</td>
                <td class="px-4 py-2"><span class="text-red-400">필수</span></td>
                <td class="px-4 py-2 text-gray-300">고유 세션 ID (중복 거래 방지)</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>

      <div>
        <h3 class="text-lg font-medium text-white mb-2">요청 예제</h3>
        <div class="bg-gray-900 rounded-lg p-4 border border-gray-700 relative">
          <button onclick="copyCode('request-example')" class="absolute top-2 right-2 px-2 py-1 bg-gray-700 text-white text-xs rounded hover:bg-gray-600 transition-colors">
            복사
          </button>
          <pre id="request-example" class="text-gray-300 text-sm overflow-x-auto"><code>{
  "store_id": "STORE001", (가맹점 코드)
  "amount": 50000,
  "depositor_name": "홍길동",
  "session_id": "unique-session-12345"
}</code></pre>
        </div>
      </div>

      <div>
        <h3 class="text-lg font-medium text-white mb-2">응답 예제 (성공)</h3>
        <div class="bg-gray-900 rounded-lg p-4 border border-gray-700 relative">
          <button onclick="copyCode('response-success')" class="absolute top-2 right-2 px-2 py-1 bg-gray-700 text-white text-xs rounded hover:bg-gray-600 transition-colors">
            복사
          </button>
          <pre id="response-success" class="text-gray-300 text-sm overflow-x-auto"><code>{
  "success": true,
  "message": "송금 요청이 생성되었습니다.",
  "data": {
    "transaction_id": "STORE001_unique-s_1640995200_1234",
    "transfer_id": 12345,
    "amount": 50000,
    "store_name": "테스트 가맹점",
    "kakao_account_name": "카카오계정",
    "depositor_name": "홍길동"
  },
  "kakao_pay_link": "https://qr.kakaopay.com/...",
  "qr_link": "https://qr.kakaopay.com/..."
}</code></pre>
        </div>
      </div>

      <div>
        <h3 class="text-lg font-medium text-white mb-2">응답 예제 (중복 거래)</h3>
        <div class="bg-gray-900 rounded-lg p-4 border border-gray-700 relative">
          <button onclick="copyCode('response-duplicate')" class="absolute top-2 right-2 px-2 py-1 bg-gray-700 text-white text-xs rounded hover:bg-gray-600 transition-colors">
            복사
          </button>
          <pre id="response-duplicate" class="text-gray-300 text-sm overflow-x-auto"><code>{
  "success": true,
  "message": "이미 진행 중인 거래가 있습니다.",
  "existing_transaction": true,
  "data": {
    "transaction_id": "STORE001_unique-s_1640995200_1234",
    "transfer_id": 12345,
    "amount": 50000,
    "store_name": "테스트 가맹점",
    "kakao_account_name": "카카오계정",
    "depositor_name": "홍길동",
    "remaining_seconds": 580
  },
  "kakao_pay_link": "https://qr.kakaopay.com/...",
  "qr_link": "https://qr.kakaopay.com/..."
}</code></pre>
        </div>
      </div>
    </div>
  </div>

  <!-- 2. 결제 상태 조회 API -->
  <div id="payment-status" class="bg-white/5 rounded-xl p-6 border border-white/10">
    <div class="flex items-center gap-3 mb-4">
      <span class="px-3 py-1 bg-blue-500 text-white text-xs font-medium rounded-full">GET</span>
      <h2 class="text-xl font-semibold text-white">결제 상태 조회</h2>
    </div>

    <div class="mb-4">
      <div class="bg-gray-800 rounded-lg p-3 border border-gray-700">
        <code class="text-blue-400 font-mono">GET /api/payment/status/{transaction_id}</code>
      </div>
    </div>

    <div class="space-y-4">
      <div>
        <h3 class="text-lg font-medium text-white mb-2">응답 예제</h3>
        <div class="bg-gray-900 rounded-lg p-4 border border-gray-700 relative">
          <button onclick="copyCode('status-response')" class="absolute top-2 right-2 px-2 py-1 bg-gray-700 text-white text-xs rounded hover:bg-gray-600 transition-colors">
            복사
          </button>
          <pre id="status-response" class="text-gray-300 text-sm overflow-x-auto"><code>{
  "success": true,
  "data": {
    "transaction_id": "STORE001_unique-s_1640995200_1234",
    "transfer_id": 12345,
    "amount": 50000,
    "status": "completed",
    "payment_status": "completed",
    "store_name": "테스트 가맹점",
    "kakao_account_name": "카카오계정",
    "depositor_name": "홍길동",
    "created_at": "2024-01-01 12:00:00",
    "updated_at": "2024-01-01 12:05:30"
  }
}</code></pre>
        </div>
      </div>

      <div>
        <h3 class="text-lg font-medium text-white mb-2">상태 코드 설명</h3>
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm">
            <thead class="bg-gray-800 text-gray-300">
              <tr>
                <th class="px-4 py-2 text-left">상태</th>
                <th class="px-4 py-2 text-left">설명</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-white/10">
              <tr>
                <td class="px-4 py-2"><span class="px-2 py-1 bg-yellow-500/20 text-yellow-400 rounded text-xs">requested</span></td>
                <td class="px-4 py-2 text-gray-300">결제 요청이 생성됨</td>
              </tr>
              <tr>
                <td class="px-4 py-2"><span class="px-2 py-1 bg-blue-500/20 text-blue-400 rounded text-xs">pending</span></td>
                <td class="px-4 py-2 text-gray-300">결제 대기 중</td>
              </tr>
              <tr>
                <td class="px-4 py-2"><span class="px-2 py-1 bg-green-500/20 text-green-400 rounded text-xs">completed</span></td>
                <td class="px-4 py-2 text-gray-300">결제 완료 및 승인됨</td>
              </tr>
              <tr>
                <td class="px-4 py-2"><span class="px-2 py-1 bg-red-500/20 text-red-400 rounded text-xs">cancelled</span></td>
                <td class="px-4 py-2 text-gray-300">결제 취소됨</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

  <!-- 3. 콜백 시스템 -->
  <div id="callback" class="bg-white/5 rounded-xl p-6 border border-white/10">
    <div class="flex items-center gap-3 mb-4">
      <span class="px-3 py-1 bg-purple-500 text-white text-xs font-medium rounded-full">CALLBACK</span>
      <h2 class="text-xl font-semibold text-white">콜백 시스템</h2>
    </div>

    <div class="space-y-4">
      <div class="bg-yellow-500/10 border border-yellow-500/20 rounded-lg p-4">
        <div class="flex items-start gap-3">
          <svg class="w-5 h-5 text-yellow-400 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16c-.77.833.192 2.5 1.732 2.5z"></path>
          </svg>
          <div>
            <h4 class="text-yellow-400 font-medium mb-1">콜백 설정 방법</h4>
            <p class="text-gray-300 text-sm">가맹점의 <code class="bg-gray-800 px-1 py-0.5 rounded">callback_url</code> 필드에 콜백을 받을 URL을 설정해주세요.</p>
          </div>
        </div>
      </div>

      <div>
        <h3 class="text-lg font-medium text-white mb-2">콜백 발생 시점</h3>
        <div class="bg-gray-900 rounded-lg p-4 border border-gray-700">
          <ul class="space-y-2 text-gray-300 text-sm">
            <li class="flex items-center gap-2">
              <span class="w-2 h-2 bg-green-400 rounded-full"></span>
              결제 승인이 완료된 후 (status: 'completed')
            </li>
            <li class="flex items-center gap-2">
              <span class="w-2 h-2 bg-blue-400 rounded-full"></span>
              수수료 및 롤링 계산 완료 후
            </li>
            <li class="flex items-center gap-2">
              <span class="w-2 h-2 bg-purple-400 rounded-full"></span>
              잔액 업데이트 완료 후
            </li>
          </ul>
        </div>
      </div>

      <div>
        <h3 class="text-lg font-medium text-white mb-2">콜백 데이터 (POST)</h3>
        <div class="bg-gray-900 rounded-lg p-4 border border-gray-700 relative">
          <button onclick="copyCode('callback-data')" class="absolute top-2 right-2 px-2 py-1 bg-gray-700 text-white text-xs rounded hover:bg-gray-600 transition-colors">
            복사
          </button>
          <pre id="callback-data" class="text-gray-300 text-sm overflow-x-auto"><code>{
  "code": 0,
  "trans_id": "TXN20240101120530123456",
  "transfer_id": 12345,
  "user_id": "STORE001",
  "amount": 50000,
  "actual_amount": 48500,
  "fee_amount": 1500,
  "status": "completed"
}</code></pre>
        </div>
      </div>

      <div>
        <h3 class="text-lg font-medium text-white mb-2">콜백 파라미터 설명</h3>
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm">
            <thead class="bg-gray-800 text-gray-300">
              <tr>
                <th class="px-4 py-2 text-left">파라미터</th>
                <th class="px-4 py-2 text-left">타입</th>
                <th class="px-4 py-2 text-left">설명</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-white/10">
              <tr>
                <td class="px-4 py-2 font-mono text-primary">code</td>
                <td class="px-4 py-2 text-gray-400">number</td>
                <td class="px-4 py-2 text-gray-300">결과 코드 (0: 성공)</td>
              </tr>
              <tr>
                <td class="px-4 py-2 font-mono text-primary">trans_id</td>
                <td class="px-4 py-2 text-gray-400">string</td>
                <td class="px-4 py-2 text-gray-300">고유 트랜잭션 ID</td>
              </tr>
              <tr>
                <td class="px-4 py-2 font-mono text-primary">transfer_id</td>
                <td class="px-4 py-2 text-gray-400">number</td>
                <td class="px-4 py-2 text-gray-300">내부 거래 ID</td>
              </tr>
              <tr>
                <td class="px-4 py-2 font-mono text-primary">user_id</td>
                <td class="px-4 py-2 text-gray-400">string</td>
                <td class="px-4 py-2 text-gray-300">가맹점 사용자 ID</td>
              </tr>
              <tr>
                <td class="px-4 py-2 font-mono text-primary">amount</td>
                <td class="px-4 py-2 text-gray-400">number</td>
                <td class="px-4 py-2 text-gray-300">원래 요청 금액</td>
              </tr>
              <tr>
                <td class="px-4 py-2 font-mono text-primary">actual_amount</td>
                <td class="px-4 py-2 text-gray-400">number</td>
                <td class="px-4 py-2 text-gray-300">수수료 차감 후 실제 지급액</td>
              </tr>
              <tr>
                <td class="px-4 py-2 font-mono text-primary">fee_amount</td>
                <td class="px-4 py-2 text-gray-400">number</td>
                <td class="px-4 py-2 text-gray-300">총 수수료</td>
              </tr>
              <tr>
                <td class="px-4 py-2 font-mono text-primary">status</td>
                <td class="px-4 py-2 text-gray-400">string</td>
                <td class="px-4 py-2 text-gray-300">최종 상태</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>

      <div>
        <h3 class="text-lg font-medium text-white mb-2">콜백 응답 처리</h3>
        <div class="bg-gray-900 rounded-lg p-4 border border-gray-700">
          <div class="space-y-3">
            <p class="text-gray-300 text-sm">콜백을 받은 후 다음과 같이 응답해주세요:</p>
            <div class="bg-gray-800 rounded p-3">
              <pre class="text-green-400 text-sm"><code>HTTP/1.1 200 OK
Content-Type: application/json

{
  "code": 0,
  "message": "success"
}</code></pre>
            </div>
            <div class="bg-blue-500/10 border border-blue-500/20 rounded p-3">
              <p class="text-blue-400 text-xs">
                <strong>참고:</strong> 30초 이내에 응답하지 않거나 HTTP 4xx/5xx 응답을 반환하면 콜백이 실패한 것으로 처리됩니다.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- 4. 에러 코드 -->
  <div id="error-codes" class="bg-white/5 rounded-xl p-6 border border-white/10">
    <div class="flex items-center gap-3 mb-4">
      <span class="px-3 py-1 bg-red-500 text-white text-xs font-medium rounded-full">ERROR</span>
      <h2 class="text-xl font-semibold text-white">에러 코드</h2>
    </div>

    <div class="space-y-4">
      <div>
        <h3 class="text-lg font-medium text-white mb-2">HTTP 상태 코드</h3>
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm">
            <thead class="bg-gray-800 text-gray-300">
              <tr>
                <th class="px-4 py-2 text-left">코드</th>
                <th class="px-4 py-2 text-left">설명</th>
                <th class="px-4 py-2 text-left">예시 상황</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-white/10">
              <tr>
                <td class="px-4 py-2"><span class="px-2 py-1 bg-green-500/20 text-green-400 rounded text-xs">200</span></td>
                <td class="px-4 py-2 text-gray-300">성공</td>
                <td class="px-4 py-2 text-gray-400">정상 처리됨</td>
              </tr>
              <tr>
                <td class="px-4 py-2"><span class="px-2 py-1 bg-red-500/20 text-red-400 rounded text-xs">400</span></td>
                <td class="px-4 py-2 text-gray-300">잘못된 요청</td>
                <td class="px-4 py-2 text-gray-400">필수 파라미터 누락, 잘못된 데이터</td>
              </tr>
              <tr>
                <td class="px-4 py-2"><span class="px-2 py-1 bg-red-500/20 text-red-400 rounded text-xs">401</span></td>
                <td class="px-4 py-2 text-gray-300">인증 실패</td>
                <td class="px-4 py-2 text-gray-400">API 키가 유효하지 않음</td>
              </tr>
              <tr>
                <td class="px-4 py-2"><span class="px-2 py-1 bg-red-500/20 text-red-400 rounded text-xs">404</span></td>
                <td class="px-4 py-2 text-gray-300">리소스 없음</td>
                <td class="px-4 py-2 text-gray-400">거래 ID를 찾을 수 없음</td>
              </tr>
              <tr>
                <td class="px-4 py-2"><span class="px-2 py-1 bg-red-500/20 text-red-400 rounded text-xs">500</span></td>
                <td class="px-4 py-2 text-gray-300">서버 오류</td>
                <td class="px-4 py-2 text-gray-400">내부 서버 오류</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>

      <div>
        <h3 class="text-lg font-medium text-white mb-2">에러 응답 예제</h3>
        <div class="bg-gray-900 rounded-lg p-4 border border-gray-700 relative">
          <button onclick="copyCode('error-response')" class="absolute top-2 right-2 px-2 py-1 bg-gray-700 text-white text-xs rounded hover:bg-gray-600 transition-colors">
            복사
          </button>
          <pre id="error-response" class="text-gray-300 text-sm overflow-x-auto"><code>{
  "success": false,
  "message": "필수 정보가 누락되었습니다. (가맹점, 금액, 입금자명, 세션ID)"
}</code></pre>
        </div>
      </div>

      <div>
        <h3 class="text-lg font-medium text-white mb-2">일반적인 에러 메시지</h3>
        <div class="space-y-2">
          <div class="bg-red-500/10 border border-red-500/20 rounded p-3">
            <code class="text-red-400 text-sm">가맹점을 찾을 수 없습니다.</code>
          </div>
          <div class="bg-red-500/10 border border-red-500/20 rounded p-3">
            <code class="text-red-400 text-sm">입금자명은 2글자 이상 입력해주세요.</code>
          </div>
          <div class="bg-red-500/10 border border-red-500/20 rounded p-3">
            <code class="text-red-400 text-sm">해당 가맹점의 카카오페이 링크가 설정되지 않았습니다.</code>
          </div>
          <div class="bg-red-500/10 border border-red-500/20 rounded p-3">
            <code class="text-red-400 text-sm">이미 진행 중인 거래가 있습니다.</code>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- 테스트 도구 -->
  <div class="bg-white/5 rounded-xl p-6 border border-white/10">
    <div class="flex items-center gap-3 mb-4">
      <span class="px-3 py-1 bg-orange-500 text-white text-xs font-medium rounded-full">TEST</span>
      <h2 class="text-xl font-semibold text-white">API 테스트 도구</h2>
    </div>

    <div class="bg-orange-500/10 border border-orange-500/20 rounded-lg p-4">
      <div class="flex items-start gap-3">
        <svg class="w-5 h-5 text-orange-400 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
        </svg>
        <div>
          <h4 class="text-orange-400 font-medium mb-1">개발 환경에서 테스트</h4>
          <p class="text-gray-300 text-sm mb-3">아래 도구들을 사용하여 API를 테스트할 수 있습니다:</p>
          <div class="space-y-2">
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-orange-400 rounded-full"></span>
              <span class="text-gray-300 text-sm">Postman, Insomnia 등의 API 테스트 도구</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-orange-400 rounded-full"></span>
              <span class="text-gray-300 text-sm">cURL 명령어</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-orange-400 rounded-full"></span>
              <span class="text-gray-300 text-sm">브라우저 개발자 도구</span>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="mt-4">
      <h3 class="text-lg font-medium text-white mb-2">cURL 테스트 예제</h3>
      <div class="bg-gray-900 rounded-lg p-4 border border-gray-700 relative">
        <button onclick="copyCode('curl-example')" class="absolute top-2 right-2 px-2 py-1 bg-gray-700 text-white text-xs rounded hover:bg-gray-600 transition-colors">
          복사
        </button>
        <pre id="curl-example" class="text-gray-300 text-sm overflow-x-auto"><code>curl -X POST https://your-domain.com/api/payment/create \
  -H "Content-Type: application/json" \
  -d '{
    "store_id": "STORE001",
    "amount": 50000,
    "depositor_name": "홍길동",
    "session_id": "unique-session-12345"
  }'</code></pre>
      </div>
    </div>
  </div>
</main>

<script>
// 코드 복사 기능
function copyCode(elementId) {
  const element = document.getElementById(elementId);
  const text = element.textContent;
  
  navigator.clipboard.writeText(text).then(function() {
    // 성공 피드백
    const button = element.nextElementSibling || element.parentElement.querySelector('button');
    if (button) {
      const originalText = button.textContent;
      button.textContent = '복사됨!';
      button.classList.add('bg-green-600');
      setTimeout(() => {
        button.textContent = originalText;
        button.classList.remove('bg-green-600');
      }, 2000);
    }
  }).catch(function(err) {
    console.error('복사 실패:', err);
  });
}

// 부드러운 스크롤
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
  anchor.addEventListener('click', function (e) {
    e.preventDefault();
    const target = document.querySelector(this.getAttribute('href'));
    if (target) {
      target.scrollIntoView({
        behavior: 'smooth',
        block: 'start'
      });
    }
  });
});

// 스크롤 시 네비게이션 하이라이트
window.addEventListener('scroll', function() {
  const sections = ['payment-create', 'payment-status', 'callback', 'error-codes'];
  const navLinks = document.querySelectorAll('a[href^="#"]');
  
  let current = '';
  sections.forEach(section => {
    const element = document.getElementById(section);
    if (element) {
      const rect = element.getBoundingClientRect();
      if (rect.top <= 100 && rect.bottom >= 100) {
        current = section;
      }
    }
  });
  
  navLinks.forEach(link => {
    link.classList.remove('bg-primary/30', 'border-primary/50');
    if (link.getAttribute('href') === '#' + current) {
      link.classList.add('bg-primary/30', 'border-primary/50');
    }
  });
});

// CSS 변수 설정
document.documentElement.style.setProperty('--primary', '#10b981');
document.documentElement.style.setProperty('--secondary', '#06d6a0');
</script>

<style>
.bg-primary {
  background-color: #10b981;
}

.text-primary {
  color: #10b981;
}

.border-primary {
  border-color: #10b981;
}

/* 코드 하이라이팅 */
code {
  font-family: 'Monaco', 'Menlo', 'Ubuntu Mono', monospace;
}

/* 테이블 스타일 개선 */
table {
  border-collapse: separate;
  border-spacing: 0;
}

table th:first-child,
table td:first-child {
  border-left: none;
}

table th:last-child,
table td:last-child {
  border-right: none;
}

/* 스크롤바 스타일 */
::-webkit-scrollbar {
  width: 6px;
  height: 6px;
}

::-webkit-scrollbar-track {
  background: rgba(255, 255, 255, 0.1);
  border-radius: 3px;
}

::-webkit-scrollbar-thumb {
  background: rgba(16, 185, 129, 0.5);
  border-radius: 3px;
}

::-webkit-scrollbar-thumb:hover {
  background: rgba(16, 185, 129, 0.7);
}
</style>

<?php include 'layout/footer.php'; ?>