<?php
include 'layout/header.php';

// 경고 메시지를 출력하지 않도록 설정
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', 0);
?>

<!-- 모바일 메뉴 열기 버튼 (상단에 배치 필요) -->
<button class="md:hidden fixed top-4 left-4 z-40 bg-primary text-white p-2 rounded-full shadow-lg"
    onclick="toggleSidebar()">
    ☰
</button>

<main class="flex-1 p-8 space-y-8">
    <h2 class="text-3xl font-bold text-primary mb-6">은행 계좌 리스트</h2>

    <!-- 은행 계좌 추가 폼 (인라인) -->
    <div class="bg-white/5 border border-white/10 rounded-xl overflow-hidden shadow mb-6">
        <div class="p-4">
            <h3 class="text-lg font-semibold text-white mb-4">은행 계좌 추가</h3>
            <form id="addBankForm" class="flex flex-wrap gap-4 items-end">
                <div class="flex-1 min-w-[150px]">
                    <label class="block text-sm text-gray-400 mb-1">은행</label>
                    <select name="bank" required
                        class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
                        <option value="">은행 선택</option>
                        <option value="KB국민은행">KB국민은행</option>
                        <option value="신한은행">신한은행</option>
                        <option value="하나은행">하나은행</option>
                        <option value="우리은행">우리은행</option>
                        <option value="NH농협은행">NH농협은행</option>
                        <option value="대구은행">대구은행</option>
                        <option value="전북은행">전북은행</option>
                        <option value="광주은행">광주은행</option>
                        <option value="IBK기업은행">IBK기업은행</option>
                        <option value="카카오뱅크">카카오뱅크</option>
                        <option value="토스뱅크">토스뱅크</option>
                        <option value="케이뱅크">케이뱅크</option>
                        <option value="SC제일은행">SC제일은행</option>
                        <option value="씨티은행">씨티은행</option>
                        <option value="새마을금고">새마을금고</option>
                        <option value="신협">신협</option>
                        <option value="우체국">우체국</option>
                    </select>
                </div>
                <div class="flex-1 min-w-[200px]">
                    <label class="block text-sm text-gray-400 mb-1">계좌번호</label>
                    <input type="text" name="account_number" required
                        class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary"
                        placeholder="계좌번호 (숫자만)">
                </div>
                <div class="flex-1 min-w-[150px]">
                    <label class="block text-sm text-gray-400 mb-1">예금주</label>
                    <input type="text" name="account_holder" required
                        class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary"
                        placeholder="예금주명">
                </div>
                <div class="flex-1 min-w-[150px]">
                <button type="submit" class="px-6 py-2 bg-primary text-white rounded hover:bg-teal-600 transition">
                    추가
                </button>
            </form>
        </div>
    </div>

    <!-- 검색 필터 -->
    <form method="GET" class="mb-6 flex gap-4 flex-wrap">
        <input type="text" name="search" placeholder="은행명, 계좌번호, 예금주, 별칭 검색"
            value="<?php echo $_GET['search'] ?? ''; ?>"
            class="px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 w-64 focus:outline-none focus:ring-2 focus:ring-primary ml-4">
        
        <select name="bank_filter"
            class="px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
            <option value="">전체 은행</option>
            <option value="KB국민은행" <?php echo ($_GET['bank_filter'] ?? '') === 'KB국민은행' ? 'selected' : ''; ?>>KB국민은행</option>
            <option value="신한은행" <?php echo ($_GET['bank_filter'] ?? '') === '신한은행' ? 'selected' : ''; ?>>신한은행</option>
            <option value="하나은행" <?php echo ($_GET['bank_filter'] ?? '') === '하나은행' ? 'selected' : ''; ?>>하나은행</option>
            <option value="우리은행" <?php echo ($_GET['bank_filter'] ?? '') === '우리은행' ? 'selected' : ''; ?>>우리은행</option>
            <option value="NH농협은행" <?php echo ($_GET['bank_filter'] ?? '') === 'NH농협은행' ? 'selected' : ''; ?>>NH농협은행</option>
            <option value="대구은행" <?php echo ($_GET['bank_filter'] ?? '') === '대구은행' ? 'selected' : ''; ?>>대구은행</option>
            <option value="전북은행" <?php echo ($_GET['bank_filter'] ?? '') === '전북은행' ? 'selected' : ''; ?>>전북은행</option>
            <option value="광주은행" <?php echo ($_GET['bank_filter'] ?? '') === '대구은행' ? 'selected' : ''; ?>>광주은행</option>
            <option value="IBK기업은행" <?php echo ($_GET['bank_filter'] ?? '') === 'IBK기업은행' ? 'selected' : ''; ?>>IBK기업은행</option>
            <option value="카카오뱅크" <?php echo ($_GET['bank_filter'] ?? '') === '카카오뱅크' ? 'selected' : ''; ?>>카카오뱅크</option>
            <option value="토스뱅크" <?php echo ($_GET['bank_filter'] ?? '') === '토스뱅크' ? 'selected' : ''; ?>>토스뱅크</option>
            <option value="케이뱅크" <?php echo ($_GET['bank_filter'] ?? '') === '케이뱅크' ? 'selected' : ''; ?>>케이뱅크</option>
            <option value="새마을금고" <?php echo ($_GET['bank_filter'] ?? '') === '새마을금고' ? 'selected' : ''; ?>>새마을금고</option>
            <option value="우체국" <?php echo ($_GET['bank_filter'] ?? '') === '우체국' ? 'selected' : ''; ?>>우체국</option>
        </select>

        <!-- <select name="status_filter"
            class="px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
            <option value="">전체 상태</option>
            <option value="1" <?php echo ($_GET['status_filter'] ?? '') === '1' ? 'selected' : ''; ?>>사용</option>
            <option value="0" <?php echo ($_GET['status_filter'] ?? '') === '0' ? 'selected' : ''; ?>>미사용</option>
        </select> -->

        <button type="submit" class="px-4 py-2 bg-primary text-white rounded hover:bg-teal-600">
            검색
        </button>
    </form>

    <!-- 은행 계좌 리스트 테이블 -->
    <div class="bg-white/5 border border-white/10 rounded-xl overflow-hidden shadow">
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm text-left">
                <thead class="bg-gray-800 text-gray-300">
                    <tr>
                        <th class="px-4 py-3 border-b border-white/10">ID</th>
                        <th class="px-4 py-3 border-b border-white/10">은행</th>
                        <th class="px-4 py-3 border-b border-white/10">계좌번호</th>
                        <th class="px-4 py-3 border-b border-white/10">예금주</th>
                        <th class="px-4 py-3 border-b border-white/10">연결된 가맹점</th>
                        <th class="px-4 py-3 border-b border-white/10">등록일</th>
                        <th class="px-4 py-3 border-b border-white/10">관리</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/10" id="bankTableBody">
                    <!-- 동적으로 데이터가 로드됩니다 -->
                </tbody>
            </table>
        </div>
    </div>

    <!-- 페이지네이션 -->
    <div class="flex justify-center space-x-2 text-sm mt-4" id="pagination">
        <!-- 동적으로 생성됩니다 -->
    </div>
</main>

<script>
    // 페이지 로드 시 은행 계좌 목록 가져오기
    document.addEventListener('DOMContentLoaded', function () {
        fetchBankaccount();
    });

    // 은행 계좌 추가 폼 제출
    document.getElementById('addBankForm').addEventListener('submit', function (e) {
        e.preventDefault();

        const formData = new FormData(this);

        // 계좌번호 숫자만 입력 검증
        const accountNumber = formData.get('account_number');
        if (!/^\d+$/.test(accountNumber)) {
            alert('계좌번호는 숫자만 입력 가능합니다.');
            return;
        }

        fetch('/ajax/add_bank_account.php', {
            method: 'POST',
            body: formData
        })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    alert('은행 계좌가 추가되었습니다.');
                    this.reset();
                    fetchBankaccount();
                } else {
                    alert(data.message || '추가 중 오류가 발생했습니다.');
                }
            })
            .catch(err => {
                console.error(err);
                alert('오류가 발생했습니다.');
            });
    });

    // 은행 계좌 목록 가져오기
    function fetchBankaccount() {
        const urlParams = new URLSearchParams(window.location.search);
        const search = urlParams.get('search') || '';
        const bankFilter = urlParams.get('bank_filter') || '';
        const statusFilter = urlParams.get('status_filter') || '';
        const page = urlParams.get('page') || 1;

        fetch(`/ajax/fetch_bank_account.php?search=${encodeURIComponent(search)}&bank_filter=${encodeURIComponent(bankFilter)}&status_filter=${statusFilter}&page=${page}`)
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    displayBankaccount(data.account);
                    updatePagination(data.totalPages, data.currentPage);
                }
            })
            .catch(console.error);
    }

    // 은행 계좌 목록 표시
    function displayBankaccount(account) {
        const tbody = document.getElementById('bankTableBody');
        tbody.innerHTML = '';

        if (account.length === 0) {
            tbody.innerHTML = '<tr><td colspan="9" class="px-4 py-8 text-center text-gray-400">등록된 은행 계좌가 없습니다.</td></tr>';
            return;
        }

        account.forEach(account => {
            const row = document.createElement('tr');
            row.className = 'hover:bg-white/5 transition';
            row.id = `row-${account.id}`;

            // 계좌번호 마스킹 표시 (앞 4자리와 뒤 3자리만 표시)
            const maskedAccountNumber = maskAccountNumber(account.account_number);

            // 읽기 모드 표시
            row.innerHTML = `
                <td class="px-4 py-2">${account.id}</td>
                <td class="px-4 py-2">
                    <span class="view-mode">${escapeHtml(account.bank_name)}</span>
                    <select class="edit-mode hidden w-full px-2 py-1 rounded bg-gray-800 text-white border border-gray-600" 
                           data-field="bank_name">
                        <option value="KB국민은행" ${account.bank_name === 'KB국민은행' ? 'selected' : ''}>KB국민은행</option>
                        <option value="신한은행" ${account.bank_name === '신한은행' ? 'selected' : ''}>신한은행</option>
                        <option value="하나은행" ${account.bank_name === '하나은행' ? 'selected' : ''}>하나은행</option>
                        <option value="우리은행" ${account.bank_name === '우리은행' ? 'selected' : ''}>우리은행</option>
                        <option value="NH농협은행" ${account.bank_name === 'NH농협은행' ? 'selected' : ''}>NH농협은행</option>
                        <option value="IBK기업은행" ${account.bank_name === 'IBK기업은행' ? 'selected' : ''}>IBK기업은행</option>
                        <option value="카카오뱅크" ${account.bank_name === '카카오뱅크' ? 'selected' : ''}>카카오뱅크</option>
                        <option value="토스뱅크" ${account.bank_name === '토스뱅크' ? 'selected' : ''}>토스뱅크</option>
                        <option value="케이뱅크" ${account.bank_name === '케이뱅크' ? 'selected' : ''}>케이뱅크</option>
                        <option value="SC제일은행" ${account.bank_name === 'SC제일은행' ? 'selected' : ''}>SC제일은행</option>
                        <option value="씨티은행" ${account.bank_name === '씨티은행' ? 'selected' : ''}>씨티은행</option>
                        <option value="새마을금고" ${account.bank_name === '새마을금고' ? 'selected' : ''}>새마을금고</option>
                        <option value="신협" ${account.bank_name === '신협' ? 'selected' : ''}>신협</option>
                        <option value="우체국" ${account.bank_name === '우체국' ? 'selected' : ''}>우체국</option>
                    </select>
                </td>
                <td class="px-4 py-2">
                    <span class="view-mode">${maskedAccountNumber}</span>
                    <input type="text" class="edit-mode hidden w-full px-2 py-1 rounded bg-gray-800 text-white border border-gray-600" 
                           value="${escapeHtml(account.account_number)}" data-field="account_number">
                </td>
                <td class="px-4 py-2">
                    <span class="view-mode">${escapeHtml(account.account_holder)}</span>
                    <input type="text" class="edit-mode hidden w-full px-2 py-1 rounded bg-gray-800 text-white border border-gray-600" 
                           value="${escapeHtml(account.account_holder)}" data-field="account_holder">
                </td>
                <td class="px-4 py-2 text-xs">
                    ${account.member_count > 0 ?
                        `<span class="text-primary">${account.member_count}개</span>` :
                        '<span class="text-gray-500">-</span>'
                    }
                </td>
                <td class="px-4 py-2 text-gray-400">${account.created_at || '-'}</td>
                <td class="px-4 py-2">
                    <div class="view-mode">
                        <button onclick="enterEditMode(${account.id})" class="px-2 py-1 text-xs bg-blue-600 hover:bg-blue-700 text-white rounded mr-1">수정</button>
                        <button onclick="deleteBankAccount(${account.id})" class="px-2 py-1 text-xs bg-red-600 hover:bg-red-700 text-white rounded">삭제</button>
                    </div>
                    <div class="edit-mode hidden">
                        <button onclick="saveEdit(${account.id})" class="px-2 py-1 text-xs bg-green-600 hover:bg-green-700 text-white rounded mr-1">저장</button>
                        <button onclick="cancelEdit(${account.id})" class="px-2 py-1 text-xs bg-gray-600 hover:bg-gray-700 text-white rounded">취소</button>
                    </div>
                </td>
            `;
            tbody.appendChild(row);
        });
    }

    // 편집 모드 진입
    function enterEditMode(id) {
        const row = document.getElementById(`row-${id}`);
        row.querySelectorAll('.view-mode').forEach(el => el.classList.add('hidden'));
        row.querySelectorAll('.edit-mode').forEach(el => el.classList.remove('hidden'));
    }

    // 편집 취소
    function cancelEdit(id) {
        const row = document.getElementById(`row-${id}`);
        row.querySelectorAll('.view-mode').forEach(el => el.classList.remove('hidden'));
        row.querySelectorAll('.edit-mode').forEach(el => el.classList.add('hidden'));
    }

    // 편집 저장
    function saveEdit(id) {
        const row = document.getElementById(`row-${id}`);
        const data = { id: id };

        // 모든 편집 가능한 필드 수집
        row.querySelectorAll('.edit-mode[data-field]:not(.hidden)').forEach(element => {
            const field = element.dataset.field;
            if (element.tagName === 'SELECT') {
                data[field] = element.value;
            } else if (element.tagName === 'INPUT') {
                data[field] = element.value;
            }
        });

        // 계좌번호 유효성 검사
        if (data.account_number && !/^\d+$/.test(data.account_number)) {
            alert('계좌번호는 숫자만 입력 가능합니다.');
            return;
        }

        fetch('/ajax/update_bank_account.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(data)
        })
            .then(res => res.json())
            .then(responseData => {
                if (responseData.success) {
                    alert('수정되었습니다.');
                    fetchBankaccount();
                } else {
                    alert(responseData.message || '수정 중 오류가 발생했습니다.');
                }
            })
            .catch(err => {
                console.error('Fetch 에러:', err);
                alert('네트워크 오류가 발생했습니다.');
            });
    }

    // 은행 계좌 삭제
    function deleteBankAccount(id) {
        if (!confirm('정말로 이 은행 계좌를 삭제하시겠습니까?\n연결된 가맹점이 있을 경우 연결이 해제됩니다.')) return;

        fetch('/ajax/delete_bank_account.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ id: id })
        })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    alert('은행 계좌가 삭제되었습니다.');
                    fetchBankaccount();
                } else {
                    alert(data.message || '삭제 중 오류가 발생했습니다.');
                }
            })
            .catch(err => {
                console.error(err);
                alert('오류가 발생했습니다.');
            });
    }

    // 페이지네이션 업데이트
    function updatePagination(totalPages, currentPage) {
        const pagination = document.getElementById('pagination');
        pagination.innerHTML = '';

        const urlParams = new URLSearchParams(window.location.search);
        const search = urlParams.get('search') || '';
        const bankFilter = urlParams.get('bank_filter') || '';
        const statusFilter = urlParams.get('status_filter') || '';

        // 이전 버튼
        if (currentPage > 1) {
            const prevLink = createPageLink(currentPage - 1, '이전', search, bankFilter, statusFilter);
            prevLink.classList.add('px-3', 'py-1', 'bg-gray-800', 'hover:bg-gray-700', 'rounded');
            pagination.appendChild(prevLink);
        }

        // 페이지 번호
        for (let i = 1; i <= totalPages; i++) {
            if (i <= 3 || i > totalPages - 3 || (i >= currentPage - 1 && i <= currentPage + 1)) {
                const pageLink = createPageLink(i, i, search, bankFilter, statusFilter);
                if (i == currentPage) {
                    pageLink.classList.add('px-3', 'py-1', 'rounded', 'bg-primary', 'text-white');
                } else {
                    pageLink.classList.add('px-3', 'py-1', 'rounded', 'bg-gray-800', 'hover:bg-gray-700');
                }
                pagination.appendChild(pageLink);
            } else if (i === 4 || i === totalPages - 3) {
                const dots = document.createElement('span');
                dots.textContent = '...';
                dots.classList.add('px-2', 'py-1', 'text-gray-500');
                pagination.appendChild(dots);
            }
        }

        // 다음 버튼
        if (currentPage < totalPages) {
            const nextLink = createPageLink(currentPage + 1, '다음', search, bankFilter, statusFilter);
            nextLink.classList.add('px-3', 'py-1', 'bg-gray-800', 'hover:bg-gray-700', 'rounded');
            pagination.appendChild(nextLink);
        }
    }

    // 페이지 링크 생성
    function createPageLink(page, text, search, bankFilter, statusFilter) {
        const link = document.createElement('a');
        let href = `?page=${page}`;
        if (search) href += `&search=${search}`;
        if (bankFilter) href += `&bank_filter=${bankFilter}`;
        if (statusFilter) href += `&status_filter=${statusFilter}`;
        link.href = href;
        link.textContent = text;
        return link;
    }

    // HTML 이스케이프
    function escapeHtml(text) {
        if (!text) return '';
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return text.toString().replace(/[&<>"']/g, m => map[m]);
    }

    // 계좌번호 마스킹 (보안)
    function maskAccountNumber(accountNumber) {
        if (!accountNumber) return '';
        const str = accountNumber.toString();
        if (str.length <= 7) return str; // 짧은 계좌번호는 그대로 표시
        
        // 앞 4자리와 뒤 3자리만 표시
        return str.substring(0, 4) + '*'.repeat(str.length - 7) + str.substring(str.length - 3);
    }

    // 계좌번호 입력 시 숫자만 허용
    document.addEventListener('input', function(e) {
        if (e.target.name === 'account_number' || e.target.dataset.field === 'account_number') {
            e.target.value = e.target.value.replace(/[^0-9]/g, '');
        }
    });
</script>

</body>
</html>