<?php
include 'layout/header.php';

// 세션에서 로그인한 사용자 정보 가져오기
$user_id = $_SESSION['id'] ?? null;

if (!$user_id) {
    echo "<script>alert('로그인이 필요합니다.'); location.href='login.php';</script>";
    exit;
}

// 내 가맹점 정보 가져오기
$my_store = null;
$daily_stats = [];
$monthly_stats = [];
$recent_transactions = [];

if (isset($con)) {
    // 가맹점 기본 정보 조회
    $store_query = "SELECT 
                        m.*,
                        ka.name as kakao_account_name,
                        ka.kakao_tid,
                        ba.bank as bank_account_bank,
                        ba.account_holder as bank_account_holder,
                        ba.account_number as bank_account_number
                    FROM member m
                    LEFT JOIN kakao_account ka ON m.kakao_account_id = ka.id
                    LEFT JOIN bank_account ba ON m.bank_account_id = ba.id
                    WHERE m.user_id = ?";
    
    $stmt = mysqli_prepare($con, $store_query);
    mysqli_stmt_bind_param($stmt, "s", $user_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $my_store = mysqli_fetch_assoc($result);
    
    if ($my_store) {
        // member 테이블의 id (PK)를 가져옴
        $member_id = $my_store['id'];
        
        // 오늘 통계 - member.id를 사용
        $today = date('Y-m-d');
        $daily_query = "SELECT 
                            COALESCE(SUM(CASE WHEN type = 'deposit' AND status = 'completed' THEN amount ELSE 0 END), 0) as daily_deposit,
                            COALESCE(SUM(CASE WHEN type = 'withdraw' AND status = 'completed' THEN amount ELSE 0 END), 0) as daily_withdraw,
                            COUNT(CASE WHEN status = 'completed' THEN 1 END) as transaction_count
                        FROM transfer 
                        WHERE user_id = ? AND DATE(created_at) = ?";
        
        $stmt = mysqli_prepare($con, $daily_query);
        mysqli_stmt_bind_param($stmt, "is", $member_id, $today);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        $daily_stats = mysqli_fetch_assoc($result);
        
        // NULL 값 처리
        if (!$daily_stats) {
            $daily_stats = [
                'daily_deposit' => 0,
                'daily_withdraw' => 0,
                'transaction_count' => 0
            ];
        }
        
        // 이번달 통계 - member.id를 사용
        $monthly_query = "SELECT 
                            COALESCE(SUM(CASE WHEN type = 'deposit' AND status = 'completed' THEN amount ELSE 0 END), 0) as monthly_deposit,
                            COALESCE(SUM(CASE WHEN type = 'withdraw' AND status = 'completed' THEN amount ELSE 0 END), 0) as monthly_withdraw
                          FROM transfer 
                          WHERE user_id = ? 
                          AND YEAR(created_at) = YEAR(CURRENT_DATE()) 
                          AND MONTH(created_at) = MONTH(CURRENT_DATE())";
        
        $stmt = mysqli_prepare($con, $monthly_query);
        mysqli_stmt_bind_param($stmt, "i", $member_id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        $monthly_stats = mysqli_fetch_assoc($result);
        
        // NULL 값 처리
        if (!$monthly_stats) {
            $monthly_stats = [
                'monthly_deposit' => 0,
                'monthly_withdraw' => 0
            ];
        }
        
        // 디버깅용 - 나중에 제거
        error_log("Member ID: " . $member_id);
        error_log("Monthly Stats: " . print_r($monthly_stats, true));
        
        // 최근 거래 내역 (10건) - member.id를 사용
        $transactions_query = "SELECT * FROM transfer 
                              WHERE user_id = ? 
                              ORDER BY created_at DESC 
                              LIMIT 10";
        
        $stmt = mysqli_prepare($con, $transactions_query);
        mysqli_stmt_bind_param($stmt, "i", $member_id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        
        while ($row = mysqli_fetch_assoc($result)) {
            $recent_transactions[] = $row;
        }
    }
}
?>

<style>
    .glass-card {
        background: rgba(255, 255, 255, 0.05);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .stat-card {
        transition: all 0.3s ease;
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
    }
    
    .gradient-text {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .pulse-dot {
        animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.5; }
    }
</style>

<!-- 모바일 메뉴 열기 버튼 -->
<button class="md:hidden fixed top-4 left-4 z-40 bg-primary text-white p-2 rounded-full shadow-lg" onclick="toggleSidebar()">
  ☰
</button>

<main class="flex-1 p-8 space-y-8">
    <?php if ($my_store): ?>
    
    <!-- 헤더 섹션 -->
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-3xl font-bold gradient-text mb-2">내 가맹점 정보</h1>
            <p class="text-gray-400">가맹점명: <?= htmlspecialchars($my_store['user_name']) ?></p>
        </div>
        <div class="text-right">
            <p class="text-sm text-gray-400">가맹점 코드</p>
            <p class="text-2xl font-bold text-primary"><?= htmlspecialchars($my_store['code']) ?></p>
        </div>
    </div>
    
    <!-- 통계 카드 -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="stat-card glass-card p-6 rounded-xl">
            <div class="flex items-center justify-between mb-2">
                <span class="text-gray-400 text-sm">보유 잔액</span>
                <svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <div class="text-2xl font-bold"><?= number_format($my_store['amount'] ?? 0) ?>원</div>
            <div class="text-xs text-gray-400 mt-1">현재 잔액</div>
        </div>
        
        <div class="stat-card glass-card p-6 rounded-xl">
            <div class="flex items-center justify-between mb-2">
                <span class="text-gray-400 text-sm">금일 입금</span>
                <svg class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 11l5-5m0 0l5 5m-5-5v12"></path>
                </svg>
            </div>
            <div class="text-2xl font-bold text-green-400"><?= number_format($daily_stats['daily_deposit'] ?? 0) ?>원</div>
            <div class="text-xs text-gray-400 mt-1">오늘 총 입금액</div>
        </div>
        
        <div class="stat-card glass-card p-6 rounded-xl">
            <div class="flex items-center justify-between mb-2">
                <span class="text-gray-400 text-sm">금일 출금</span>
                <svg class="w-5 h-5 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 13l-5 5m0 0l-5-5m5 5V6"></path>
                </svg>
            </div>
            <div class="text-2xl font-bold text-red-400"><?= number_format($daily_stats['daily_withdraw'] ?? 0) ?>원</div>
            <div class="text-xs text-gray-400 mt-1">오늘 총 출금액</div>
        </div>
        
        <div class="stat-card glass-card p-6 rounded-xl">
            <div class="flex items-center justify-between mb-2">
                <span class="text-gray-400 text-sm">금일 거래</span>
                <svg class="w-5 h-5 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                </svg>
            </div>
            <div class="text-2xl font-bold text-purple-400"><?= $daily_stats['transaction_count'] ?? 0 ?>건</div>
            <div class="text-xs text-gray-400 mt-1">오늘 거래 건수</div>
        </div>
    </div>
    
    <!-- 기본 정보 섹션 -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
        <!-- 가맹점 정보 -->
        <div class="glass-card p-6 rounded-xl">
            <h2 class="text-xl font-semibold mb-4 text-blue-400">가맹점 정보</h2>
            <div class="space-y-3">
                <div class="flex justify-between py-2 border-b border-gray-700">
                    <span class="text-gray-400">가맹점 ID</span>
                    <span class="font-medium"><?= htmlspecialchars($my_store['user_id']) ?></span>
                </div>
                <div class="flex justify-between py-2 border-b border-gray-700">
                    <span class="text-gray-400">가맹점명</span>
                    <span class="font-medium"><?= htmlspecialchars($my_store['user_name']) ?></span>
                </div>
                <div class="flex justify-between py-2 border-b border-gray-700">
                    <span class="text-gray-400">가맹점 코드</span>
                    <span class="font-medium text-primary"><?= htmlspecialchars($my_store['code']) ?></span>
                </div>
                <div class="flex justify-between py-2 border-b border-gray-700">
                    <span class="text-gray-400">수수료율</span>
                    <span class="font-medium text-amber-400"><?= $my_store['rate'] ?>%</span>
                </div>
                <div class="flex justify-between py-2 border-b border-gray-700">
                    <span class="text-gray-400">등급</span>
                    <span class="font-medium">
                        <span class="px-2 py-1 bg-purple-500/20 text-purple-400 rounded text-sm">
                            <?= ucfirst($my_store['grade'] ?? 'basic') ?>
                        </span>
                    </span>
                </div>
                <div class="flex justify-between py-2">
                    <span class="text-gray-400">가입일</span>
                    <span class="font-medium"><?= date('Y-m-d', strtotime($my_store['created_at'])) ?></span>
                </div>
            </div>
        </div>
        
        <!-- 계좌 정보 -->
        <div class="glass-card p-6 rounded-xl">
            <h2 class="text-xl font-semibold mb-4 text-green-400">계좌 정보</h2>
            <div class="space-y-3">
                <!-- 카카오 계정 대신 링크 표시 -->
                <div class="flex justify-between py-2 border-b border-gray-700">
                    <span class="text-gray-400">입금 링크</span>
                    <a href="https://tinyurl.com/28noa8ka" target="_blank" class="text-blue-400 hover:text-blue-300 underline">
                        입금 정보 확인 →
                    </a>
                </div>
                
                <!-- 출금 계좌 정보 -->
                <div class="py-2 border-b border-gray-700">
                    <p class="text-gray-400 mb-2">출금 계좌</p>
                    <div class="bg-gray-800/50 p-3 rounded">
                        <p class="text-sm"><?= htmlspecialchars($my_store['bank'] ?? '-') ?></p>
                        <p class="font-medium"><?= htmlspecialchars($my_store['account_number'] ?? '-') ?></p>
                        <p class="text-sm text-gray-400"><?= htmlspecialchars($my_store['account_holder'] ?? '-') ?></p>
                    </div>
                </div>
                
                <!-- QR 코드 (있는 경우) -->
                <?php if ($my_store['code']): ?>
               <div class="py-2">
                <p class="text-gray-400 mb-2">QR 코드</p>
                <div class="flex justify-center">
                    <div class="bg-white p-2 rounded">
                        <?php 
                        // QR 코드로 변환할 URL
                        $qr_url = 'https://tinyurl.com/28noa8ka';
                        
                        // QR Server API 사용 (가장 간단!)
                        $qr_api = 'https://api.qrserver.com/v1/create-qr-code/?size=128x128&data=' . urlencode($qr_url);
                        ?>
                        <img src="<?= $qr_api ?>" 
                            alt="QR Code" 
                            class="w-32 h-32" 
                            onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                        <div style="display:none;" class="w-32 h-32 flex items-center justify-center text-gray-400 bg-gray-800">
                            QR 생성 실패
                        </div>
                    </div>
                </div>
            </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- 이번달 통계 -->
    <div class="glass-card p-6 rounded-xl mb-8">
        <h2 class="text-xl font-semibold mb-4 text-purple-400">이번달 거래 현황</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center">
                <p class="text-gray-400 mb-2">총 입금액</p>
                <p class="text-2xl font-bold text-green-400">
                    <?php 
                    $deposit = isset($monthly_stats['monthly_deposit']) ? $monthly_stats['monthly_deposit'] : 0;
                    echo number_format($deposit);
                    ?>원
                </p>
            </div>
            <div class="text-center">
                <p class="text-gray-400 mb-2">총 출금액</p>
                <p class="text-2xl font-bold text-red-400">
                    <?php 
                    $withdraw = isset($monthly_stats['monthly_withdraw']) ? $monthly_stats['monthly_withdraw'] : 0;
                    echo number_format($withdraw);
                    ?>원
                </p>
            </div>
            <div class="text-center">
                <p class="text-gray-400 mb-2">순수익</p>
                <?php 
                $deposit = isset($monthly_stats['monthly_deposit']) ? $monthly_stats['monthly_deposit'] : 0;
                $withdraw = isset($monthly_stats['monthly_withdraw']) ? $monthly_stats['monthly_withdraw'] : 0;
                $net_profit = $deposit - $withdraw;
                ?>
                <p class="text-2xl font-bold <?= $net_profit >= 0 ? 'text-blue-400' : 'text-orange-400' ?>">
                    <?= $net_profit >= 0 ? '+' : '' ?><?= number_format($net_profit) ?>원
                </p>
            </div>
        </div>
        
        <!-- 디버깅용 (나중에 제거) -->
        <?php if (isset($_GET['debug'])): ?>
        <div class="mt-4 p-4 bg-gray-800 rounded text-xs">
            <p>Member ID: <?= $member_id ?></p>
            <p>Monthly Deposit: <?= $monthly_stats['monthly_deposit'] ?? 'null' ?></p>
            <p>Monthly Withdraw: <?= $monthly_stats['monthly_withdraw'] ?? 'null' ?></p>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- 최근 거래 내역 -->
    <div class="glass-card p-6 rounded-xl">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-xl font-semibold">최근 거래 내역</h2>
            <a href="deposit_manage.php" class="text-blue-400 hover:text-blue-300 text-sm">
                전체보기 →
            </a>
        </div>
        
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead>
                    <tr class="border-b border-gray-700 text-gray-400">
                        <th class="text-left py-2">일시</th>
                        <th class="text-left py-2">구분</th>
                        <th class="text-right py-2">금액</th>
                        <th class="text-center py-2">상태</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($recent_transactions)): ?>
                    <tr>
                        <td colspan="4" class="text-center py-8 text-gray-400">
                            거래 내역이 없습니다.
                        </td>
                    </tr>
                    <?php else: ?>
                        <?php foreach ($recent_transactions as $tx): ?>
                        <tr class="border-b border-gray-800 hover:bg-white/5">
                            <td class="py-3"><?= date('m/d H:i', strtotime($tx['created_at'])) ?></td>
                            <td class="py-3">
                                <?php if ($tx['type'] == 'deposit'): ?>
                                    <span class="text-green-400">입금</span>
                                <?php else: ?>
                                    <span class="text-red-400">출금</span>
                                <?php endif; ?>
                            </td>
                            <td class="py-3 text-right font-medium">
                                <?= number_format($tx['amount']) ?>원
                            </td>
                            <td class="py-3 text-center">
                                <?php 
                                $status_class = '';
                                $status_text = '';
                                switch($tx['status']) {
                                    case 'completed':
                                        $status_class = 'bg-green-500/20 text-green-400';
                                        $status_text = '완료';
                                        break;
                                    case 'pending':
                                        $status_class = 'bg-yellow-500/20 text-yellow-400';
                                        $status_text = '대기중';
                                        break;
                                    case 'cancelled':
                                        $status_class = 'bg-red-500/20 text-red-400';
                                        $status_text = '취소';
                                        break;
                                    default:
                                        $status_class = 'bg-gray-500/20 text-gray-400';
                                        $status_text = $tx['status'];
                                }
                                ?>
                                <span class="px-2 py-1 rounded text-xs <?= $status_class ?>">
                                    <?= $status_text ?>
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <?php else: ?>
    
    <!-- 정보가 없는 경우 -->
    <div class="flex items-center justify-center min-h-[60vh]">
        <div class="text-center">
            <svg class="w-24 h-24 mx-auto text-gray-600 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            <h2 class="text-2xl font-semibold mb-2">가맹점 정보를 찾을 수 없습니다</h2>
            <p class="text-gray-400">관리자에게 문의해주세요.</p>
        </div>
    </div>
    
    <?php endif; ?>
</main>

<script>
// 자동 새로고침 (30초마다)
setInterval(function() {
    location.reload();
}, 30000);

// 숫자 애니메이션
document.addEventListener('DOMContentLoaded', function() {
    const animateValue = (element, start, end, duration) => {
        const range = end - start;
        const increment = range / (duration / 16);
        let current = start;
        
        const timer = setInterval(() => {
            current += increment;
            if ((increment > 0 && current >= end) || (increment < 0 && current <= end)) {
                element.textContent = new Intl.NumberFormat('ko-KR').format(end) + '원';
                clearInterval(timer);
            } else {
                element.textContent = new Intl.NumberFormat('ko-KR').format(Math.floor(current)) + '원';
            }
        }, 16);
    };
    
    // 통계 카드 애니메이션
    document.querySelectorAll('.stat-card').forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px) scale(1.02)';
        });
        
        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0) scale(1)';
        });
    });
});
</script>

</body>
</html>