<?php
header('Content-Type: application/json; charset=utf-8');

// POST 요청만 허용
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => '잘못된 요청 방법입니다.']);
    exit;
}

// 세션 시작 및 로그인 확인
session_start();
if (!isset($_SESSION["id"]) || empty($_SESSION["id"])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

// 데이터베이스 연결
include "inc/db_connect.php";

// MySQLi 연결 확인
if (!isset($con) || !$con) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => '데이터베이스 연결 오류가 발생했습니다.']);
    exit;
}

try {
    // JSON 데이터 받기
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('잘못된 요청 데이터입니다.');
    }
    
    $user_id = trim($input['user_id'] ?? '');

    // 필수 필드 검증
    if (empty($user_id)) {
        throw new Exception('삭제할 가맹점 아이디가 필요합니다.');
    }

    // 해당 가맹점이 존재하는지 확인
    $user_id_escaped = mysqli_real_escape_string($con, $user_id);
    $checkSql = "SELECT id, user_name, amount FROM member WHERE user_id = '$user_id_escaped'";
    $checkResult = mysqli_query($con, $checkSql);
    
    if (!$checkResult) {
        throw new Exception('가맹점 조회 중 오류가 발생했습니다: ' . mysqli_error($con));
    }
    
    if (mysqli_num_rows($checkResult) === 0) {
        throw new Exception('존재하지 않는 가맹점입니다.');
    }
    
    $memberInfo = mysqli_fetch_assoc($checkResult);
    
    // 잔액이 있는 경우 삭제 방지 (선택사항)
    if ($memberInfo['amount'] > 0) {
        throw new Exception('잔액이 남아있는 가맹점은 삭제할 수 없습니다. 먼저 잔액을 정리해주세요.');
    }

    // 트랜잭션 시작 (안전한 삭제를 위해)
    mysqli_autocommit($con, false);
    
    try {
        // 관련 데이터가 있다면 먼저 삭제 (예: 거래 내역 등)
        // 예시: DELETE FROM transactions WHERE member_id = ...
        
        // 가맹점 삭제
        $deleteSql = "DELETE FROM member WHERE user_id = '$user_id_escaped'";
        $deleteResult = mysqli_query($con, $deleteSql);
        
        if (!$deleteResult) {
            throw new Exception('가맹점 삭제 중 오류가 발생했습니다: ' . mysqli_error($con));
        }
        
        $affected_rows = mysqli_affected_rows($con);
        
        if ($affected_rows === 0) {
            throw new Exception('삭제할 가맹점을 찾을 수 없습니다.');
        }
        
        // 커밋
        mysqli_commit($con);
        
        echo json_encode([
            'success' => true,
            'message' => '가맹점이 성공적으로 삭제되었습니다.',
            'data' => [
                'user_id' => $user_id,
                'user_name' => $memberInfo['user_name']
            ]
        ]);
        
    } catch (Exception $e) {
        // 롤백
        mysqli_rollback($con);
        throw $e;
    }
    
    // 자동 커밋 복원
    mysqli_autocommit($con, true);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>