<?php
include 'layout/header.php';
?>

<!-- 모바일 메뉴 열기 버튼 (상단에 배치 필요) -->
<button class="md:hidden fixed top-4 left-4 z-40 bg-primary text-white p-2 rounded-full shadow-lg" onclick="toggleSidebar()">
  ☰
</button>

<main class="flex-1 p-8 space-y-8">
  <h2 class="text-3xl font-bold text-primary mb-6">가맹점 수정</h2>

  <!-- 가맹점 수정 폼 -->
  <div class="bg-white/5 border border-white/10 rounded-xl overflow-hidden shadow">
    <div class="p-6">
      <form id="editStoreForm" class="space-y-4">
        <input type="hidden" id="original_user_id" name="user_id">
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="block text-sm text-gray-400 mb-1">가맹점 아이디</label>
            <input type="text" id="user_id" name="user_id" readonly
                   class="w-full px-4 py-2 rounded bg-gray-700 text-gray-400 border border-gray-600 cursor-not-allowed">
          </div>
          
          <div>
            <label class="block text-sm text-gray-400 mb-1">가맹점명 <span class="text-red-500">*</span></label>
            <input type="text" id="user_name" name="user_name" required
                   class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
          </div>
          
          <div>
            <label class="block text-sm text-gray-400 mb-1">가맹점 코드 <span class="text-red-500">*</span></label>
            <input type="text" id="code" name="code" required
                   class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
          </div>
          
          <div>
            <label class="block text-sm text-gray-400 mb-1">새 비밀번호 (변경시에만 입력)</label>
            <input type="password" id="password" name="password"
                   class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
          </div>
          
          <div>
            <label class="block text-sm text-gray-400 mb-1">출금 은행</label>
            <select id="bank" name="bank" class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
              <option value="">선택하세요</option>
              <option value="KB국민은행">KB국민은행</option>
              <option value="신한은행">신한은행</option>
              <option value="우리은행">우리은행</option>
              <option value="하나은행">하나은행</option>
              <option value="NH농협은행">NH농협은행</option>
              <option value="IBK기업은행">IBK기업은행</option>
              <option value="카카오뱅크">카카오뱅크</option>
              <option value="토스뱅크">토스뱅크</option>
              <option value="SC제일은행">SC제일은행</option>
              <option value="새마을금고">새마을금고</option>
            </select>
          </div>
          
          <div>
            <label class="block text-sm text-gray-400 mb-1">출금 계좌번호</label>
            <input type="text" id="account_number" name="account_number"
                   class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
          </div>
          
          <div>
            <label class="block text-sm text-gray-400 mb-1">예금주</label>
            <input type="text" id="account_holder" name="account_holder"
                   class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
          </div>
          
          <div>
            <label class="block text-sm text-gray-400 mb-1">수수료율 (%)</label>
            <input type="number" id="rate" name="rate" step="0.01" min="0" max="100"
                   class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
          </div>
        </div>
        
        <div class="flex gap-4 mt-6">
          <button type="submit" class="px-6 py-2 bg-primary text-white rounded hover:bg-teal-600 transition">
            수정
          </button>
          <button type="button" onclick="window.location.href='/admin/store_list.php'" 
                  class="px-6 py-2 bg-gray-700 text-white rounded hover:bg-gray-600 transition">
            취소
          </button>
        </div>
      </form>
    </div>
  </div>
</main>

<script>
// 페이지 로드 시 가맹점 정보 가져오기
document.addEventListener('DOMContentLoaded', function() {
  const urlParams = new URLSearchParams(window.location.search);
  const userId = urlParams.get('user_id');
  
  if (!userId) {
    alert('가맹점 아이디가 필요합니다.');
    window.location.href = '/admin/store_list.php';
    return;
  }
  
  // 가맹점 정보 조회
  fetch(`/admin/get_member.php?user_id=${encodeURIComponent(userId)}`)
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        const member = data.member;
        document.getElementById('original_user_id').value = member.user_id;
        document.getElementById('user_id').value = member.user_id;
        document.getElementById('user_name').value = member.user_name;
        document.getElementById('code').value = member.code;
        document.getElementById('bank').value = member.bank || '';
        document.getElementById('account_number').value = member.account_number || '';
        document.getElementById('account_holder').value = member.account_holder || '';
        document.getElementById('rate').value = member.rate || 0;
      } else {
        alert(data.message || '가맹점 정보를 불러올 수 없습니다.');
        window.location.href = '/admin/store_list.php';
      }
    })
    .catch(err => {
      console.error(err);
      alert('오류가 발생했습니다.');
      window.location.href = '/admin/store_list.php';
    });
});

// 가맹점 수정 폼 제출
document.getElementById('editStoreForm').addEventListener('submit', function(e) {
  e.preventDefault();
  
  const formData = new FormData(this);
  
  fetch('/admin/edit_member.php', {
    method: 'POST',
    body: formData
  })
  .then(res => res.json())
  .then(data => {
    if (data.success) {
      alert('가맹점 정보가 수정되었습니다.');
      window.location.href = '/admin/store_list.php';
    } else {
      alert(data.message || '수정 중 오류가 발생했습니다.');
    }
  })
  .catch(err => {
    console.error(err);
    alert('오류가 발생했습니다.');
  });
});
</script>

</body>
</html>