<?php
define('ADMIN_DOMAIN', 'https://allin1-pay.com');
define('USER_DOMAIN', 'https://pay-u-123.com');

$user_domain = USER_DOMAIN;
$test_url = $user_domain . '/payment_select.php';

$api_url = 'https://tinyurl.com/api-create.php?url=' . urlencode($test_url);
$short_url = @file_get_contents($api_url);
echo "TinyURL 응답: " . $short_url . "<br>";

if ($short_url && strpos($short_url, 'tinyurl.com') !== false) {
    echo "<br>===== cURL로 단축 URL 확인 =====<br>";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $short_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false); // 리다이렉트 따라가지 않기
    curl_setopt($ch, CURLOPT_NOBODY, true); // HEAD 요청
    curl_setopt($ch, CURLOPT_HEADER, true);
    
    $headers = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "HTTP Code: " . $http_code . "<br>";
    echo "Headers:<br>";
    echo "<pre>" . htmlspecialchars($headers) . "</pre>";
    
    // Location 헤더 찾기
    if (preg_match('/Location:\s*(.+)/i', $headers, $matches)) {
        $location = trim($matches[1]);
        echo "<br>리다이렉트 목적지: " . $location . "<br>";
        
        if (strpos($location, 'allin1-pay.com') !== false) {
            echo "<span style='color: red;'>문제 발견: allin1-pay.com으로 리다이렉트됨!</span><br>";
        } elseif (strpos($location, 'pay-u-123.com') !== false) {
            echo "<span style='color: green;'>정상: pay-u-123.com으로 올바르게 연결됨</span><br>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>결제 링크 생성기</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen py-8">
    <div class="container mx-auto px-4 max-w-md">
        <div class="bg-white rounded-lg shadow-lg p-6">
            <h1 class="text-2xl font-bold text-gray-800 mb-6 text-center">결제 링크 생성기</h1>
            
            <form method="POST" class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">메모 (선택사항)</label>
                    <input type="text" name="memo" placeholder="예: 홍길동님 전용" 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                
                <button type="submit" name="generate" 
                        class="w-full bg-blue-500 text-white py-2 px-4 rounded-md hover:bg-blue-600 transition">
                    링크 생성하기
                </button>
            </form>
            
            <?php
            if (isset($_POST['generate'])) {
                $memo = $_POST['memo'] ?? '';
                
                // 사용자 도메인 설정
                $user_domain = USER_DOMAIN;
                $real_url = $user_domain . '/payment_select.php';
                
                // 디버깅 정보
                echo "<div class='mt-4 p-3 bg-yellow-50 border rounded'>";
                echo "<h4>디버깅 정보:</h4>";
                echo "<p><strong>원본 URL:</strong> " . htmlspecialchars($real_url) . "</p>";
                
                // 여러 URL 단축 서비스 시도
                $short_url = false;
                $service_used = '';
                
                // 1. TinyURL 시도
                $api_url = 'https://tinyurl.com/api-create.php?url=' . urlencode($real_url);
                $context = stream_context_create([
                    'http' => [
                        'timeout' => 10,
                        'user_agent' => 'Mozilla/5.0 (compatible; LinkGenerator/1.0)'
                    ]
                ]);
                $short_url = @file_get_contents($api_url, false, $context);
                
                if ($short_url && strpos($short_url, 'tinyurl.com') !== false && strlen($short_url) < 100) {
                    $service_used = 'TinyURL';
                    echo "<p><strong>TinyURL 응답:</strong> " . htmlspecialchars($short_url) . "</p>";
                } else {
                    echo "<p><strong>TinyURL 실패:</strong> " . htmlspecialchars($short_url ?: 'No response') . "</p>";
                    
                    // 2. is.gd 시도
                    $api_url = 'https://is.gd/create.php?format=simple&url=' . urlencode($real_url);
                    $short_url = @file_get_contents($api_url, false, $context);
                    
                    if ($short_url && strpos($short_url, 'is.gd') !== false && strlen($short_url) < 100) {
                        $service_used = 'is.gd';
                        echo "<p><strong>is.gd 응답:</strong> " . htmlspecialchars($short_url) . "</p>";
                    } else {
                        echo "<p><strong>is.gd 실패:</strong> " . htmlspecialchars($short_url ?: 'No response') . "</p>";
                        $short_url = false;
                    }
                }
                
                echo "</div>";
                
                if ($short_url) {
                    ?>
                    <div class="mt-6 p-4 bg-green-50 border border-green-200 rounded-md">
                        <h3 class="text-lg font-semibold text-green-800 mb-3">✅ 링크 생성 완료! (<?php echo $service_used; ?>)</h3>
                        
                        <div class="space-y-3">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">생성된 단축 링크:</label>
                                <div class="mt-1 p-2 bg-gray-50 rounded border">
                                    <code class="text-blue-600 break-all" id="shortUrl"><?php echo htmlspecialchars($short_url); ?></code>
                                </div>
                                <div class="mt-2 space-x-2">
                                    <button onclick="copyToClipboard()" 
                                            class="text-sm bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600">📋 복사</button>
                                    <a href="<?php echo htmlspecialchars($short_url); ?>" target="_blank" 
                                       class="text-sm bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600 inline-block">🔗 테스트</a>
                                </div>
                            </div>
                            
                            <?php if ($memo): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">메모:</label>
                                <p class="text-gray-600"><?php echo htmlspecialchars($memo); ?></p>
                            </div>
                            <?php endif; ?>
                            
                            <div class="text-xs text-gray-500">
                                <p>• 생성 시간: <?php echo date('Y-m-d H:i:s'); ?></p>
                                <p>• 실제 URL: <?php echo htmlspecialchars($real_url); ?></p>
                                <p>• 서비스: <?php echo $service_used; ?></p>
                            </div>
                        </div>
                    </div>
                    <?php
                } else {
                    ?>
                    <div class="mt-6 p-4 bg-red-50 border border-red-200 rounded-md">
                        <h3 class="text-lg font-semibold text-red-800">❌ 단축 링크 생성 실패</h3>
                        <p class="text-red-600">모든 URL 단축 서비스에 접근할 수 없습니다.</p>
                        <div class="mt-3 p-3 bg-gray-50 rounded">
                            <p class="text-sm font-medium">원본 링크를 사용하세요:</p>
                            <div class="mt-1 p-2 bg-white rounded border">
                                <code class="text-blue-600 break-all" id="originalUrl"><?php echo htmlspecialchars($real_url); ?></code>
                            </div>
                            <button onclick="copyOriginal()" 
                                    class="mt-2 text-sm bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600">📋 원본 링크 복사</button>
                        </div>
                    </div>
                    <?php
                }
            }
            ?>
        </div>
        
        <!-- 사용 안내 -->
        <div class="mt-6 bg-white rounded-lg shadow p-4">
            <h3 class="font-semibold text-gray-800 mb-2">📋 사용 방법</h3>
            <ol class="text-sm text-gray-600 space-y-1">
                <li>1. 필요시 메모를 입력합니다</li>
                <li>2. 링크 생성 버튼을 클릭합니다</li>
                <li>3. 생성된 단축 링크를 사용자에게 전송합니다</li>
                <li>4. 사용자는 해당 링크로 바로 결제 페이지에 접근합니다</li>
            </ol>
            
            <div class="mt-3 p-3 bg-green-50 border border-green-200 rounded">
                <p class="text-sm text-green-800">
                    <strong>✅ 보안:</strong> 사용자는 관리자 도메인을 전혀 볼 수 없으며, 
                    바로 안전한 결제 페이지로 연결됩니다.
                </p>
            </div>
        </div>
    </div>
    
    <script>
        function copyToClipboard() {
            const urlElement = document.getElementById('shortUrl');
            const url = urlElement.textContent;
            
            if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(url).then(function() {
                    alert('링크가 클립보드에 복사되었습니다!');
                }).catch(function() {
                    fallbackCopy(url);
                });
            } else {
                fallbackCopy(url);
            }
        }
        
        function copyOriginal() {
            const urlElement = document.getElementById('originalUrl');
            const url = urlElement.textContent;
            
            if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(url).then(function() {
                    alert('원본 링크가 클립보드에 복사되었습니다!');
                }).catch(function() {
                    fallbackCopy(url);
                });
            } else {
                fallbackCopy(url);
            }
        }
        
        function fallbackCopy(text) {
            const textArea = document.createElement('textarea');
            textArea.value = text;
            textArea.style.position = 'fixed';
            textArea.style.left = '-999999px';
            textArea.style.top = '-999999px';
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();
            
            try {
                document.execCommand('copy');
                alert('링크가 클립보드에 복사되었습니다!');
            } catch (err) {
                prompt('다음 링크를 복사하세요:', text);
            }
            
            document.body.removeChild(textArea);
        }
    </script>
</body>
</html>