<?php
include 'layout/header.php';
?>

<!-- 정렬 아이콘 스타일 추가 -->
<style>
  .sortable {
    cursor: pointer;
    user-select: none;
    position: relative;
    padding-right: 20px !important;
  }
  .sortable:hover {
    background-color: rgba(255, 255, 255, 0.05);
  }
  .sort-icon {
    position: absolute;
    right: 4px;
    top: 50%;
    transform: translateY(-50%);
    display: inline-block;
    width: 0;
    height: 0;
    margin-left: 5px;
    vertical-align: middle;
    opacity: 0.3;
  }
  .sort-icon.asc {
    border-left: 4px solid transparent;
    border-right: 4px solid transparent;
    border-bottom: 6px solid currentColor;
    opacity: 1;
  }
  .sort-icon.desc {
    border-left: 4px solid transparent;
    border-right: 4px solid transparent;
    border-top: 6px solid currentColor;
    opacity: 1;
  }
  .sort-icon.both::before {
    content: "";
    position: absolute;
    top: -8px;
    left: -4px;
    border-left: 4px solid transparent;
    border-right: 4px solid transparent;
    border-bottom: 5px solid currentColor;
  }
  .sort-icon.both::after {
    content: "";
    position: absolute;
    bottom: -8px;
    left: -4px;
    border-left: 4px solid transparent;
    border-right: 4px solid transparent;
    border-top: 5px solid currentColor;
  }
</style>

<!-- 모바일 메뉴 열기 버튼 (상단에 배치 필요) -->
<button class="md:hidden fixed top-4 left-4 z-40 bg-primary text-white p-2 rounded-full shadow-lg" onclick="toggleSidebar()">
  ☰
</button>

<main class="flex-1 p-8 space-y-8">
  <h2 class="text-3xl font-bold text-primary mb-6">가맹점 통계</h2>

  <!-- 통계 카드 섹션 - 6개 카드로 확장 -->
  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
    <!-- 전체 가맹점 수 -->
    <div class="bg-white/5 border border-white/10 rounded-xl p-6 shadow">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-gray-400 text-sm">전체 가맹점</p>
          <p class="text-3xl font-bold text-white" id="totalStores">-</p>
        </div>
        <div class="bg-blue-500/20 p-3 rounded-lg">
          <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
          </svg>
        </div>
      </div>
    </div>

    <!-- 총 잔액 -->
    <div class="bg-white/5 border border-white/10 rounded-xl p-6 shadow">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-gray-400 text-sm">총 잔액</p>
          <p class="text-3xl font-bold text-yellow-400" id="totalBalance">-</p>
        </div>
        <div class="bg-yellow-500/20 p-3 rounded-lg">
          <svg class="w-6 h-6 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
          </svg>
        </div>
      </div>
    </div>

    <!-- 총 입금 -->
    <div class="bg-white/5 border border-white/10 rounded-xl p-6 shadow">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-gray-400 text-sm">총 입금</p>
          <p class="text-3xl font-bold text-green-400" id="totalDeposit">-</p>
        </div>
        <div class="bg-green-500/20 p-3 rounded-lg">
          <svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 11l5-5m0 0l5 5m-5-5v12"></path>
          </svg>
        </div>
      </div>
    </div>

    <!-- 총 출금 -->
    <div class="bg-white/5 border border-white/10 rounded-xl p-6 shadow">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-gray-400 text-sm">총 출금</p>
          <p class="text-3xl font-bold text-red-400" id="totalWithdraw">-</p>
        </div>
        <div class="bg-red-500/20 p-3 rounded-lg">
          <svg class="w-6 h-6 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 13l-5 5m0 0l-5-5m5 5V6"></path>
          </svg>
        </div>
      </div>
    </div>

    <!-- 총 입금 수수료 -->
    <div class="bg-white/5 border border-white/10 rounded-xl p-6 shadow">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-gray-400 text-sm">총 입금 수수료(회사 커미션)</p>
          <p class="text-2xl font-bold text-cyan-400" id="totalDepositFee">-</p>
        </div>
        <div class="bg-cyan-500/20 p-3 rounded-lg">
          <svg class="w-6 h-6 text-cyan-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
          </svg>
        </div>
      </div>
    </div>

    <!-- 총 출금 수수료 -->
    <div class="bg-white/5 border border-white/10 rounded-xl p-6 shadow">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-gray-400 text-sm">총 출금 수수료(회사 커미션)</p>
          <p class="text-2xl font-bold text-purple-400" id="totalWithdrawFee">-</p>
        </div>
        <div class="bg-purple-500/20 p-3 rounded-lg">
          <svg class="w-6 h-6 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 9a2 2 0 10-4 0v5a2 2 0 01-2 2h6m-6-4h4m8 0a9 9 0 11-18 0 9 9 0 0118 0z"></path>
          </svg>
        </div>
      </div>
    </div>
  </div>

  <!-- 검색 필터 섹션 -->
  <form method="GET" class="mb-6 flex gap-4 flex-wrap items-end">
    <!-- 날짜 범위 선택 -->
    <div class="flex gap-2 items-center">
      <div>
        <label for="start_date" class="block text-sm text-gray-400 mb-1">시작일</label>
        <input type="date" id="start_date" name="start_date" 
              value="<?php echo $_GET['start_date'] ?? date('Y-m-d'); ?>" 
              class="px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
      </div>
      <div>
        <label for="end_date" class="block text-sm text-gray-400 mb-1">종료일</label>
        <input type="date" id="end_date" name="end_date" 
              value="<?php echo $_GET['end_date'] ?? date('Y-m-d'); ?>" 
              class="px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
      </div>
    </div>

    <!-- 빠른 선택 버튼들 -->
    <div class="flex gap-2">
      <button type="button" onclick="setDateRange('today')" 
              class="px-3 py-2 rounded bg-gray-700 text-white hover:bg-gray-600 text-sm">
        오늘
      </button>
      <button type="button" onclick="setDateRange('yesterday')" 
              class="px-3 py-2 rounded bg-gray-700 text-white hover:bg-gray-600 text-sm">
        어제
      </button>
      <button type="button" onclick="setDateRange('week')" 
              class="px-3 py-2 rounded bg-gray-700 text-white hover:bg-gray-600 text-sm">
        이번주
      </button>
      <button type="button" onclick="setDateRange('month')" 
              class="px-3 py-2 rounded bg-gray-700 text-white hover:bg-gray-600 text-sm">
        이번달
      </button>
      <button type="button" onclick="setDateRange('lastMonth')" 
              class="px-3 py-2 rounded bg-gray-700 text-white hover:bg-gray-600 text-sm">
        지난달
      </button>
    </div>

    <select name="grade" class="px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
      <option value="">모든 등급</option>
      <option value="basic" <?php echo ($_GET['grade'] ?? '') === 'basic' ? 'selected' : ''; ?>>Basic</option>
      <option value="premium" <?php echo ($_GET['grade'] ?? '') === 'premium' ? 'selected' : ''; ?>>Premium</option>
      <option value="vip" <?php echo ($_GET['grade'] ?? '') === 'vip' ? 'selected' : ''; ?>>VIP</option>
    </select>

    <input type="text" name="search" placeholder="가맹점명 또는 아이디 검색" 
          value="<?php echo $_GET['search'] ?? ''; ?>" 
          class="px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 w-64 focus:outline-none focus:ring-2 focus:ring-primary">

    <button type="submit" class="px-4 py-2 bg-primary text-white rounded hover:bg-teal-600">
      조회
    </button>
  </form>

  <!-- 가맹점 통계 테이블 -->
  <div class="bg-white/5 border border-white/10 rounded-xl overflow-hidden shadow">
    <div class="p-4 border-b border-white/10">
      <h3 class="text-lg font-semibold text-white">가맹점별 상세 통계</h3>
    </div>
    <div class="overflow-x-auto">
      <table class="min-w-full text-sm text-left">
        <thead class="bg-gray-800 text-gray-300">
          <tr>
            <th class="px-4 py-3 border-b border-white/10">순번</th>
            <th class="px-4 py-3 border-b border-white/10">가맹점</th>
            <th class="px-4 py-3 border-b border-white/10">아이디</th>
            <th class="px-4 py-3 border-b border-white/10">등급</th>
            <th class="px-4 py-3 border-b border-white/10 sortable" onclick="sortTable('rate')">
              수수료율
              <span class="sort-icon both" data-sort="rate"></span>
            </th>
            <th class="px-4 py-3 border-b border-white/10 sortable" onclick="sortTable('total_deposit')">
              총입금
              <span class="sort-icon both" data-sort="total_deposit"></span>
            </th>
            <th class="px-4 py-3 border-b border-white/10 sortable" onclick="sortTable('total_deposit_fee')">
              회사커미션
              <span class="sort-icon both" data-sort="total_deposit_fee"></span>
            </th>
            <th class="px-4 py-3 border-b border-white/10 sortable" onclick="sortTable('total_withdraw')">
              총출금
              <span class="sort-icon both" data-sort="total_withdraw"></span>
            </th>
            <th class="px-4 py-3 border-b border-white/10 sortable" onclick="sortTable('total_withdraw_fee')">
              출금수수료
              <span class="sort-icon both" data-sort="total_withdraw_fee"></span>
            </th>
            <th class="px-4 py-3 border-b border-white/10 sortable" onclick="sortTable('total_actual_fee')">
              실제수수료
              <span class="sort-icon both" data-sort="total_actual_fee"></span>
            </th>
            <th class="px-4 py-3 border-b border-white/10 sortable" onclick="sortTable('total_rolling_paid')">
              상위/지급롤링
              <span class="sort-icon both" data-sort="total_rolling_paid"></span>
            </th>
            <th class="px-4 py-3 border-b border-white/10 sortable" onclick="sortTable('total_rolling_received')">
              하부/수령롤링
              <span class="sort-icon both" data-sort="total_rolling_received"></span>
            </th>
            <th class="px-4 py-3 border-b border-white/10 sortable" onclick="sortTable('last_balance')">
              종료일 잔액
              <span class="sort-icon both" data-sort="last_balance"></span>
            </th>
            <th class="px-4 py-3 border-b border-white/10 sortable" onclick="sortTable('amount')">
              현재 잔액
              <span class="sort-icon both" data-sort="amount"></span>
            </th>
          </tr>
        </thead>
        <tbody class="divide-y divide-white/10" id="statisticsTableBody">
          <!-- 동적으로 데이터가 로드됩니다 -->
        </tbody>
      </table>
    </div>
  </div>

  <!-- 페이지네이션 -->
  <div class="flex justify-center space-x-2 text-sm mt-4" id="pagination">
    <!-- 동적으로 생성됩니다 -->
  </div>
</main>

<script>
// 정렬 상태 저장
let currentSort = {
  field: null,
  direction: null
};

// 날짜 범위 설정 함수
function setDateRange(range) {
  const today = new Date();
  let startDate, endDate;
  
  switch(range) {
    case 'today':
      startDate = endDate = today;
      break;
    case 'yesterday':
      const yesterday = new Date(today);
      yesterday.setDate(yesterday.getDate() - 1);
      startDate = endDate = yesterday;
      break;
    case 'week':
      const monday = new Date(today);
      const dayOfWeek = monday.getDay();
      const diff = monday.getDate() - dayOfWeek + (dayOfWeek === 0 ? -6 : 1);
      monday.setDate(diff);
      startDate = monday;
      endDate = today;
      break;
    case 'month':
      startDate = new Date(today.getFullYear(), today.getMonth(), 1);
      endDate = today;
      break;
    case 'lastMonth':
      startDate = new Date(today.getFullYear(), today.getMonth() - 1, 1);
      endDate = new Date(today.getFullYear(), today.getMonth(), 0);
      break;
  }
  
  document.getElementById('start_date').value = formatDate(startDate);
  document.getElementById('end_date').value = formatDate(endDate);
}

// 날짜 포맷 함수
function formatDate(date) {
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, '0');
  const day = String(date.getDate()).padStart(2, '0');
  return `${year}-${month}-${day}`;
}

// 오늘 날짜 가져오기 (기본값용)
function getTodayDate() {
  return formatDate(new Date());
}

// 정렬 함수
function sortTable(field) {
  // 현재 정렬 방향 결정
  if (currentSort.field === field) {
    currentSort.direction = currentSort.direction === 'asc' ? 'desc' : 'asc';
  } else {
    currentSort.field = field;
    currentSort.direction = 'desc'; // 처음 클릭시 내림차순
  }
  
  // 데이터 다시 가져오기
  fetchAllStatistics();
  
  // 정렬 아이콘 업데이트
  updateSortIcons(field, currentSort.direction);
}

// 정렬 아이콘 업데이트
function updateSortIcons(field, direction) {
  // 모든 정렬 아이콘 초기화
  document.querySelectorAll('.sort-icon').forEach(icon => {
    icon.className = 'sort-icon both';
  });
  
  // 현재 정렬 필드의 아이콘 업데이트
  const currentIcon = document.querySelector(`[data-sort="${field}"]`);
  if (currentIcon) {
    currentIcon.className = `sort-icon ${direction}`;
  }
}

// 페이지 로드 시 통계 데이터 가져오기
document.addEventListener('DOMContentLoaded', function() {
  // URL에서 정렬 파라미터 복원
  const urlParams = new URLSearchParams(window.location.search);
  if (urlParams.has('sort_by')) {
    currentSort.field = urlParams.get('sort_by');
    currentSort.direction = urlParams.get('sort_order') || 'desc';
    updateSortIcons(currentSort.field, currentSort.direction);
  }
  
  fetchAllStatistics();
});

// 모든 통계 데이터를 한 번에 가져오기
function fetchAllStatistics() {
  const urlParams = new URLSearchParams(window.location.search);
  const search = urlParams.get('search') || '';
  const startDate = urlParams.get('start_date') || getTodayDate();
  const endDate = urlParams.get('end_date') || getTodayDate();
  const grade = urlParams.get('grade') || '';
  const page = urlParams.get('page') || 1;
  
  // 정렬 파라미터 추가
  const sortBy = currentSort.field || 'id';
  const sortOrder = currentSort.direction || 'desc';
  
  fetch(`ajax/fetch_stores_stats.php?search=${encodeURIComponent(search)}&start_date=${startDate}&end_date=${endDate}&grade=${grade}&page=${page}&sort_by=${sortBy}&sort_order=${sortOrder}`)
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        // 상단 카드 업데이트
        updateSummaryCards(data.summary);
        
        // 테이블 업데이트
        displayStatistics(data.members);
        
        // 페이지네이션 업데이트
        updatePagination(data.totalPages, data.currentPage);
      } else {
        console.error('통계 조회 실패:', data.message);
        const tbody = document.getElementById('statisticsTableBody');
        tbody.innerHTML = '<tr><td colspan="14" class="px-4 py-8 text-center text-red-400">오류: ' + (data.message || '알 수 없는 오류') + '</td></tr>';
      }
    })
    .catch(err => {
      console.error('fetch 오류:', err);
      const tbody = document.getElementById('statisticsTableBody');
      tbody.innerHTML = '<tr><td colspan="14" class="px-4 py-8 text-center text-red-400">데이터를 불러오는 중 오류가 발생했습니다.</td></tr>';
    });
}

// 상단 카드 업데이트
function updateSummaryCards(summary) {
  document.getElementById('totalStores').textContent = summary.total_stores.toLocaleString();
  document.getElementById('totalBalance').textContent = summary.total_balance.toLocaleString() + '원';
  document.getElementById('totalDeposit').textContent = '+' + summary.total_deposit.toLocaleString() + '원';
  document.getElementById('totalWithdraw').textContent = '-' + summary.total_withdraw.toLocaleString() + '원';
  document.getElementById('totalDepositFee').textContent = summary.total_deposit_fee.toLocaleString() + '원';
  document.getElementById('totalWithdrawFee').textContent = summary.total_withdraw_fee.toLocaleString() + '원';
}

// 통계 목록 표시
function displayStatistics(members) {
  const tbody = document.getElementById('statisticsTableBody');
  tbody.innerHTML = '';
  
  if (members.length === 0) {
    tbody.innerHTML = '<tr><td colspan="14" class="px-4 py-8 text-center text-gray-400">조회된 가맹점이 없습니다.</td></tr>';
    return;
  }
  
  members.forEach(member => {
    const row = document.createElement('tr');
    row.className = 'hover:bg-white/5 transition';
    row.innerHTML = `
      <td class="px-4 py-2">${member.display_id}</td>
      <td class="px-4 py-2 font-medium text-white">${escapeHtml(member.user_name)}</td>
      <td class="px-4 py-2">${escapeHtml(member.user_id)}</td>
      <td class="px-4 py-2">
        <span class="px-2 py-1 text-xs rounded-full bg-blue-500/20 text-blue-400 border border-blue-500/30">
          ${escapeHtml(member.grade)}
        </span>
      </td>
      <td class="px-4 py-2 text-center">${member.rate}%</td>
      <td class="px-4 py-2 text-right font-mono text-green-400">
        ${Number(member.total_deposit || 0) > 0 ? '+' : ''}${Number(member.total_deposit || 0).toLocaleString()}원
      </td>
      <td class="px-4 py-2 text-right font-mono text-cyan-400">
        ${Number(member.total_deposit_fee || 0).toLocaleString()}원
      </td>
      <td class="px-4 py-2 text-right font-mono text-red-400">
        ${Number(member.total_withdraw || 0) > 0 ? '-' : ''}${Number(member.total_withdraw || 0).toLocaleString()}원
      </td>
      <td class="px-4 py-2 text-right font-mono text-purple-400">
        ${Number(member.total_withdraw_fee || 0).toLocaleString()}원
      </td>
      <td class="px-4 py-2 text-right font-mono text-orange-400">
        ${Number(member.total_actual_fee || 0).toLocaleString()}원
      </td>
      <td class="px-4 py-2 text-right font-mono text-pink-400">
        ${Number(member.total_rolling_paid || 0).toLocaleString()}원
      </td>
      <td class="px-4 py-2 text-right font-mono text-indigo-400">
        ${Number(member.total_rolling_received || 0).toLocaleString()}원
      </td>
      <td class="px-4 py-2 text-right font-mono font-bold text-blue-400">
        ${Number(member.last_balance || 0).toLocaleString()}원
      </td>
      <td class="px-4 py-2 text-right font-mono font-bold text-yellow-400">
        ${Number(member.amount || 0).toLocaleString()}원
      </td>
    `;
    tbody.appendChild(row);
  });
}

// 페이지네이션 업데이트
function updatePagination(totalPages, currentPage) {
  const pagination = document.getElementById('pagination');
  pagination.innerHTML = '';
  
  const urlParams = new URLSearchParams(window.location.search);
  const search = urlParams.get('search') || '';
  const startDate = urlParams.get('start_date') || getTodayDate();
  const endDate = urlParams.get('end_date') || getTodayDate();
  const grade = urlParams.get('grade') || '';
  const sortBy = currentSort.field || 'id';
  const sortOrder = currentSort.direction || 'desc';
  
  // 이전 버튼
  if (currentPage > 1) {
    const prevLink = createPageLink(currentPage - 1, '이전', search, startDate, endDate, grade, sortBy, sortOrder);
    prevLink.classList.add('px-3', 'py-1', 'bg-gray-800', 'hover:bg-gray-700', 'rounded', 'text-white');
    pagination.appendChild(prevLink);
  }
  
  // 페이지 번호
  for (let i = 1; i <= totalPages; i++) {
    if (i <= 3 || i > totalPages - 3 || (i >= currentPage - 1 && i <= currentPage + 1)) {
      const pageLink = createPageLink(i, i, search, startDate, endDate, grade, sortBy, sortOrder);
      if (i == currentPage) {
        pageLink.classList.add('px-3', 'py-1', 'rounded', 'bg-primary', 'text-white');
      } else {
        pageLink.classList.add('px-3', 'py-1', 'rounded', 'bg-gray-800', 'hover:bg-gray-700', 'text-white');
      }
      pagination.appendChild(pageLink);
    } else if (i === 4 || i === totalPages - 3) {
      const dots = document.createElement('span');
      dots.textContent = '...';
      dots.classList.add('px-2', 'py-1', 'text-gray-500');
      pagination.appendChild(dots);
    }
  }
  
  // 다음 버튼
  if (currentPage < totalPages) {
    const nextLink = createPageLink(currentPage + 1, '다음', search, startDate, endDate, grade, sortBy, sortOrder);
    nextLink.classList.add('px-3', 'py-1', 'bg-gray-800', 'hover:bg-gray-700', 'rounded', 'text-white');
    pagination.appendChild(nextLink);
  }
}

// 페이지 링크 생성 (정렬 파라미터 포함)
function createPageLink(page, text, search, startDate, endDate, grade, sortBy, sortOrder) {
  const link = document.createElement('a');
  link.href = `?page=${page}&search=${search}&start_date=${startDate}&end_date=${endDate}&grade=${grade}&sort_by=${sortBy}&sort_order=${sortOrder}`;
  link.textContent = text;
  return link;
}

// HTML 이스케이프
function escapeHtml(text) {
  if (!text) return '';
  const map = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#039;'
  };
  return text.toString().replace(/[&<>"']/g, m => map[m]);
}

// 10초마다 자동 새로고침
setInterval(() => {
  fetchAllStatistics();
}, 10000);
</script>

</body>
</html>