<?php
include 'layout/header.php';
?>
    <main class="flex-1 p-6 space-y-6">
      <!-- 사용자 정보 표시 -->
      <div id="userInfo" class="bg-blue-500/10 border border-blue-500/20 rounded-lg p-3 mb-4 hidden">
        <span class="text-sm text-blue-400"></span>
      </div>

      <!-- 상단 통계 카드 -->
      <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <div class="bg-white/5 rounded-xl p-4 shadow border border-white/10">
          <p class="text-sm text-gray-400">오늘 입금 신청</p>
          <p class="text-2xl font-bold text-green-400" id="todayDeposits">0건</p>
        </div>
        <div class="bg-white/5 rounded-xl p-4 shadow border border-white/10">
          <p class="text-sm text-gray-400">오늘 입금 총액</p>
          <p class="text-2xl font-bold text-green-400" id="todayDepositAmount">0원</p>
        </div>
        <div class="bg-white/5 rounded-xl p-4 shadow border border-white/10">
          <p class="text-sm text-gray-400">오늘 출금 신청</p>
          <p class="text-2xl font-bold text-red-400" id="todayWithdrawals">0건</p>
        </div>
        <div class="bg-white/5 rounded-xl p-4 shadow border border-white/10">
          <p class="text-sm text-gray-400">오늘 출금 총액</p>
          <p class="text-2xl font-bold text-red-400" id="todayWithdrawalAmount">0원</p>
        </div>
      </div>

      <!-- 입금 신청 내역 -->
      <div class="mt-8 bg-white/5 p-4 rounded-xl border border-white/10 shadow">
        <div class="flex justify-between items-center mb-4">
          <h3 class="text-lg font-semibold text-white">
            <span id="depositTitle">오늘 입금 신청 내역</span>
            <span class="text-sm text-gray-400">(최근 7건)</span>
          </h3>
          <a href="deposit_manage.php" class="inline-flex items-center px-3 py-1.5 text-xs font-medium text-white bg-primary hover:bg-teal-600 rounded-lg transition-colors duration-200">
            더보기
            <svg class="ml-1.5 w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
            </svg>
          </a>
        </div>
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm text-left">
            <thead class="bg-gray-800 text-gray-300">
              <tr>
                <th class="px-4 py-2">ID</th>
                <th class="px-4 py-2">입금자명</th>
                <th class="px-4 py-2">가맹점명</th>
                <th class="px-4 py-2">코드</th>
                <th class="px-4 py-2 text-right">금액</th>
                <th class="px-4 py-2">카카오ID</th>
                <th class="px-4 py-2">상태</th>
                <!-- <th class="px-4 py-2">결제상태</th> -->
                <th class="px-4 py-2">신청일시</th>
              </tr>
            </thead>
            <tbody id="recent-deposits-body" class="divide-y divide-white/10">
              <!-- 데이터가 여기에 동적으로 삽입됩니다 -->
            </tbody>
          </table>
        </div>
        <!-- 테이블 하단 더보기 옵션 (선택사항) -->
        <div class="mt-3 text-center border-t border-white/10 pt-3">
          <a href="deposit_manage.php" class="text-sm text-gray-400 hover:text-primary transition-colors duration-200">
            전체 입금 내역 보기 →
          </a>
        </div>
      </div>

      <!-- 출금 신청 내역 -->
      <div class="mt-8 bg-white/5 p-4 rounded-xl border border-white/10 shadow">
        <div class="flex justify-between items-center mb-4">
          <h3 class="text-lg font-semibold text-white">
            <span id="withdrawTitle">오늘 출금 신청 내역</span>
            <span class="text-sm text-gray-400">(최근 7건)</span>
          </h3>
          <?php if ($row['grade'] == 'admin') { ?>
          <a href="withdraw_manage.php" class="inline-flex items-center px-3 py-1.5 text-xs font-medium text-white bg-primary hover:bg-teal-600 rounded-lg transition-colors duration-200">
          <?php
          } else {
          ?>
          <a href="withdraw.php" class="inline-flex items-center px-3 py-1.5 text-xs font-medium text-white bg-primary hover:bg-teal-600 rounded-lg transition-colors duration-200">
          <?php
          }
          ?>
  
            더보기
            <svg class="ml-1.5 w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
            </svg>
          </a>
        </div>
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm text-left">
            <thead class="bg-gray-800 text-gray-300">
              <tr>
                <th class="px-4 py-2">ID</th>
                <th class="px-4 py-2">출금자명</th>
                <th class="px-4 py-2">가맹점명</th>
                <th class="px-4 py-2">코드</th>
                <th class="px-4 py-2 text-right">금액</th>
                <th class="px-4 py-2">카카오ID</th>
                <th class="px-4 py-2">상태</th>
                <!-- <th class="px-4 py-2">결제상태</th> -->
                <th class="px-4 py-2">신청일시</th>
              </tr>
            </thead>
            <tbody id="recent-withdrawals-body" class="divide-y divide-white/10">
              <!-- 데이터가 여기에 동적으로 삽입됩니다 -->
            </tbody>
          </table>
        </div>
        <!-- 테이블 하단 더보기 옵션 (선택사항) -->
        <div class="mt-3 text-center border-t border-white/10 pt-3">
          <?php if ($row['grade'] == 'admin') { ?>
          <a href="withdraw_manage.php" class="text-sm text-gray-400 hover:text-primary transition-colors duration-200">
          <?php
          } else {
          ?>
          <a href="withdraw.php" class="text-sm text-gray-400 hover:text-primary transition-colors duration-200">
          <?php
          }
          ?>
            전체 출금 내역 보기 →
          </a>
        </div>
      </div>

      <style>
        /* 더보기 버튼 호버 효과 */
        .bg-primary {
          background-color: #14b8a6; /* Tailwind teal-500 */
        }
        
        /* 더보기 버튼 애니메이션 (선택사항) */
        @keyframes slideRight {
          0%, 100% { transform: translateX(0); }
          50% { transform: translateX(3px); }
        }
        
        a:hover svg {
          animation: slideRight 0.5s ease-in-out;
        }
      </style>
    </main>
  </div>

  <script>
    // 상태에 따른 배지 스타일 반환
    function getStatusBadge(status) {
      const statusStyles = {
        'requested': '<span class="px-2 py-1 text-xs rounded-full bg-yellow-500/20 text-yellow-400">요청됨</span>',
        'pending': '<span class="px-2 py-1 text-xs rounded-full bg-blue-500/20 text-blue-400">대기중</span>',
        'completed': '<span class="px-2 py-1 text-xs rounded-full bg-green-500/20 text-green-400">완료</span>',
        'cancelled': '<span class="px-2 py-1 text-xs rounded-full bg-red-500/20 text-red-400">취소됨</span>'
      };
      return statusStyles[status] || `<span class="px-2 py-1 text-xs rounded-full bg-gray-500/20 text-gray-400">${status}</span>`;
    }

    // 결제 상태에 따른 배지 스타일 반환
    function getPaymentStatusBadge(status) {
      if (!status || status === 'NULL') return '<span class="text-gray-500">-</span>';
      
      const statusStyles = {
        'pending': '<span class="px-2 py-1 text-xs rounded-full bg-yellow-500/20 text-yellow-400">대기</span>',
        'cancelled': '<span class="px-2 py-1 text-xs rounded-full bg-red-500/20 text-red-400">취소</span>',
        'completed': '<span class="px-2 py-1 text-xs rounded-full bg-green-500/20 text-green-400">완료</span>'
      };
      return statusStyles[status] || `<span class="px-2 py-1 text-xs rounded-full bg-gray-500/20 text-gray-400">${status}</span>`;
    }

    // 대시보드 통계 및 최근 거래 가져오기
    async function fetchDashboardStats() {
      try {
        const res = await fetch('/ajax/transfer_stats.php', {
          credentials: 'same-origin',
          headers: {
            'Accept': 'application/json'
          }
        });
        
        if (!res.ok) throw new Error('데이터를 불러오지 못했습니다');
        const data = await res.json();

        if (!data.success) {
          throw new Error(data.message || '데이터 로드 실패');
        }

        // 사용자 정보 표시
        if (data.isAdmin) {
          const userInfoDiv = document.getElementById('userInfo');
          userInfoDiv.classList.remove('hidden');
          userInfoDiv.querySelector('span').innerHTML = 
            `👑 - 전체 거래 내역 (${data.currentUser})`;
          
          // 제목 변경
          document.getElementById('depositTitle').textContent = '전체 입금 신청 내역';
          document.getElementById('withdrawTitle').textContent = '전체 출금 신청 내역';
        } else {
          const userInfoDiv = document.getElementById('userInfo');
          userInfoDiv.classList.remove('hidden');
          userInfoDiv.querySelector('span').innerHTML = 
            `👤 <strong>${data.currentUser}</strong>님의 거래 내역`;
          
          // 제목 변경
          document.getElementById('depositTitle').textContent = '내 입금 신청 내역';
          document.getElementById('withdrawTitle').textContent = '내 출금 신청 내역';
        }

        // 금액 포맷팅 함수
        const formatAmount = n => Number(n).toLocaleString() + '원';
        
        // 안전하게 텍스트 설정
        const safeText = (id, val, suffix = '') => {
          const el = document.getElementById(id);
          if (el) el.textContent = `${val}${suffix}`;
        };

        // 통계 업데이트
        safeText('todayDeposits', data.todayDeposits || 0, '건');
        safeText('todayDepositAmount', formatAmount(data.todayDepositAmount || 0));
        safeText('todayWithdrawals', data.todayWithdrawals || 0, '건');
        safeText('todayWithdrawalAmount', formatAmount(data.todayWithdrawalAmount || 0));

        // 입금 내역 테이블 업데이트
        const depositsBody = document.getElementById('recent-deposits-body');
        depositsBody.innerHTML = '';

        if (data.recentDeposits && data.recentDeposits.length > 0) {
          data.recentDeposits.forEach(d => {
            const row = document.createElement('tr');
            row.className = 'hover:bg-white/5 transition';
            row.innerHTML = `
              <td class="px-4 py-2">${d.id}</td>
              <td class="px-4 py-2 font-medium text-blue-400">${d.depositor_name || '-'}</td>
              <td class="px-4 py-2">
                ${d.user_name || '-'} 
                <span class="text-gray-500 text-xs">(${d.user_id || '-'})</span>
              </td>
              <td class="px-4 py-2 text-primary">${d.store_code || '-'}</td>
              <td class="px-4 py-2 text-right font-medium text-green-400">${Number(d.amount).toLocaleString()}원</td>
              <td class="px-4 py-2">${d.kakao_tid || '-'}</td>
              <td class="px-4 py-2">${getStatusBadge(d.status)}</td>

              <td class="px-4 py-2 text-gray-400">${d.created_at}</td>
            `;
            depositsBody.appendChild(row);
          });
        } else {
          depositsBody.innerHTML = `
            <tr>
              <td colspan="9" class="px-4 py-8 text-center text-gray-500">
                ${data.isAdmin ? '오늘 입금 신청 내역이 없습니다.' : '오늘 입금 신청 내역이 없습니다.'}
              </td>
            </tr>`;
        }

        // 출금 내역 테이블 업데이트
        const withdrawalsBody = document.getElementById('recent-withdrawals-body');
        withdrawalsBody.innerHTML = '';

        if (data.recentWithdrawals && data.recentWithdrawals.length > 0) {
          data.recentWithdrawals.forEach(w => {
            const row = document.createElement('tr');
            row.className = 'hover:bg-white/5 transition';
            row.innerHTML = `
              <td class="px-4 py-2">${w.id}</td>
              <td class="px-4 py-2 font-medium text-orange-400">${w.depositor_name || '-'}</td>
              <td class="px-4 py-2">
                ${w.user_name || '-'} 
                <span class="text-gray-500 text-xs">(${w.user_id || '-'})</span>
              </td>
              <td class="px-4 py-2 text-primary">${w.store_code || '-'}</td>
              <td class="px-4 py-2 text-right font-medium text-red-400">${Number(w.amount).toLocaleString()}원</td>
              <td class="px-4 py-2">${w.kakao_tid || '-'}</td>
              <td class="px-4 py-2">${getStatusBadge(w.status)}</td>

              <td class="px-4 py-2 text-gray-400">${w.created_at}</td>
            `;
            withdrawalsBody.appendChild(row);
          });
        } else {
          withdrawalsBody.innerHTML = `
            <tr>
              <td colspan="9" class="px-4 py-8 text-center text-gray-500">
                ${data.isAdmin ? '오늘 출금 신청 내역이 없습니다.' : '오늘 출금 신청 내역이 없습니다.'}
              </td>
            </tr>`;
        }

      } catch (e) {
        console.error('Error:', e);
        // 에러 시 기본 메시지 표시
        document.getElementById('recent-deposits-body').innerHTML = 
          '<tr><td colspan="9" class="px-4 py-8 text-center text-red-500">데이터를 불러오는 중 오류가 발생했습니다.</td></tr>';
        document.getElementById('recent-withdrawals-body').innerHTML = 
          '<tr><td colspan="9" class="px-4 py-8 text-center text-red-500">데이터를 불러오는 중 오류가 발생했습니다.</td></tr>';
      }
    }

    // 초기 로드
    fetchDashboardStats();
    
    // 5초마다 자동 새로고침
    setInterval(fetchDashboardStats, 5000);
  </script>
</body>
</html>