<?php
include 'inc/session.php';
if (!$userid)
    header('Location: login.php');
?>
<html lang="ko" class="dark">

<head>
    <meta charset="UTF-8">
    <title> 페이</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="./assets/css/main.css?dummy_date=<?= time() ?>" rel="stylesheet" type="text/css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: { primary: '#00C896' }
                }
            }
        };
    </script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary: #8b5cf6;
            --secondary: #4facfe;
            --accent: #f5576c;
            --dark-bg: #0a0e27;
            --card-bg: rgba(255, 255, 255, 0.03);
            --text-primary: #e0e7ff;
            --text-secondary: #a5b4fc;
            --border-color: rgba(139, 92, 246, 0.2);
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: var(--dark-bg);
            background-image: 
                radial-gradient(circle at 20% 50%, rgba(139, 92, 246, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(79, 172, 254, 0.1) 0%, transparent 50%);
            color: var(--text-primary);
            min-height: 100vh;
        }

        /* 헤더 스타일 */
        header {
            background: linear-gradient(135deg, rgba(139, 92, 246, 0.05) 0%, rgba(79, 172, 254, 0.05) 100%);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border-bottom: 1px solid var(--border-color);
            position: sticky;
            top: 0;
            z-index: 1000;
            transition: all 0.3s ease;
        }

        .header-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 1rem 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 2rem;
        }

        /* 왼쪽 섹션 */
        .header-left {
            display: flex;
            align-items: center;
            gap: 2rem;
        }

        .logo-wrapper {
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.6rem 1.2rem;
            background: linear-gradient(135deg, rgba(139, 92, 246, 0.1) 0%, rgba(79, 172, 254, 0.1) 100%);
            border-radius: 16px;
            border: 1px solid rgba(139, 92, 246, 0.2);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .logo-wrapper::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(139, 92, 246, 0.2), transparent);
            transition: left 0.5s ease;
        }

        .logo-wrapper:hover::before {
            left: 100%;
        }

        .logo-wrapper:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(139, 92, 246, 0.15);
            border-color: rgba(139, 92, 246, 0.4);
        }

        .logo-img {
            width: 42px;
            height: 42px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(139, 92, 246, 0.2);
            object-fit: contain;
        }

        .logo-text {
            font-size: 1.3rem;
            font-weight: 700;
            background: linear-gradient(135deg, #8b5cf6 0%, #4facfe 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            letter-spacing: -0.5px;
        }

        /* 오른쪽 섹션 */
        .header-right {
            display: flex;
            align-items: center;
            gap: 1.25rem;
        }

        /* 사용자 정보 */
        .user-info {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.5rem 1rem;
            background: rgba(255, 255, 255, 0.03);
            border-radius: 50px;
            border: 1px solid rgba(139, 92, 246, 0.15);
            backdrop-filter: blur(10px);
        }

        .user-badge {
            padding: 0.4rem 1rem;
            background: linear-gradient(135deg, #8b5cf6 0%, #764ba2 100%);
            border-radius: 25px;
            color: white;
            font-size: 0.875rem;
            font-weight: 600;
            box-shadow: 0 4px 12px rgba(139, 92, 246, 0.25);
            white-space: nowrap;
        }

        .balance-badge {
            padding: 0.4rem 1rem;
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            border-radius: 25px;
            color: white;
            font-size: 0.9rem;
            font-weight: 700;
            box-shadow: 0 4px 12px rgba(79, 172, 254, 0.25);
            animation: glow 3s ease-in-out infinite;
            white-space: nowrap;
        }

        @keyframes glow {
            0%, 100% {
                box-shadow: 0 4px 12px rgba(79, 172, 254, 0.25);
            }
            50% {
                box-shadow: 0 4px 20px rgba(79, 172, 254, 0.4);
            }
        }

        /* URL 복사 섹션 */
        .url-copy-wrapper {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.6rem 0.8rem;
            background: rgba(255, 255, 255, 0.02);
            border: 1px solid rgba(139, 92, 246, 0.15);
            border-radius: 14px;
            transition: all 0.3s ease;
        }

        .url-copy-wrapper:hover {
            background: rgba(139, 92, 246, 0.05);
            border-color: rgba(139, 92, 246, 0.3);
            transform: translateY(-1px);
        }

        .url-text {
            color: var(--text-secondary);
            font-size: 0.875rem;
            font-family: 'Monaco', 'Courier New', monospace;
            max-width: 180px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            opacity: 0.9;
        }

        .copy-btn {
            padding: 0.5rem 1rem;
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            border: none;
            border-radius: 10px;
            color: white;
            font-size: 0.875rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            box-shadow: 0 4px 12px rgba(79, 172, 254, 0.25);
            white-space: nowrap;
        }

        .copy-btn:hover {
            transform: translateY(-2px) scale(1.05);
            box-shadow: 0 6px 20px rgba(79, 172, 254, 0.35);
        }

        .copy-btn.copied {
            background: linear-gradient(135deg, #10b981 0%, #34d399 100%);
            animation: success 0.5s ease;
        }

        @keyframes success {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }

        /* 로그아웃 버튼 */
        .logout-btn {
            padding: 0.6rem 1.5rem;
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            border: none;
            border-radius: 12px;
            color: white;
            font-size: 0.9rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(245, 87, 108, 0.25);
            position: relative;
            overflow: hidden;
        }

        .logout-btn::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }

        .logout-btn:hover::before {
            width: 300px;
            height: 300px;
        }

        .logout-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(245, 87, 108, 0.35);
        }

        /* 반응형 디자인 */
        @media (max-width: 768px) {
            .header-container {
                flex-direction: column;
                gap: 1rem;
                padding: 1rem;
            }

            .header-left, .header-right {
                width: 100%;
            }

            .header-right {
                flex-wrap: wrap;
                justify-content: center;
            }

            .url-text {
                max-width: 120px;
            }
        }
    </style>
</head>

<body class="bg-gray-900 text-white font-sans min-h-screen">
    <header class="relative bg-gradient-to-r from-slate-900/95 via-gray-900/95 to-slate-900/95 backdrop-blur-xl shadow-2xl border-b border-gradient-to-r from-primary/20 via-secondary/20 to-primary/20">
        <!-- 배경 효과 -->
        <div class="absolute inset-0 bg-gradient-to-r from-primary/5 via-transparent to-secondary/5"></div>
        <div class="absolute inset-0 bg-[radial-gradient(ellipse_at_top,rgba(139,92,246,0.1),transparent_50%)]"></div>
        
        <!-- 메인 헤더 컨테이너 -->
        <div class="relative z-10 max-w-7xl mx-auto px-6 py-4">
            <div class="flex items-center justify-between">
                <!-- 로고 섹션 -->
                <div class="flex items-center gap-6">
                    <a href="index.php" class="group flex items-center gap-3 hover:scale-105 transition-all duration-300">
                        <!-- 로고 컨테이너 -->
                        <div class="relative">
                            <div class="absolute inset-0 bg-gradient-to-br from-primary via-secondary to-accent rounded-2xl blur-md opacity-70 group-hover:opacity-100 transition-opacity"></div>
                            <div class="relative bg-gradient-to-br from-primary to-secondary p-3 rounded-2xl shadow-lg group-hover:shadow-2xl transition-all duration-300">
                                <img src="./assets/images/logo.png" alt=" 페이" class="h-10 w-10 object-contain">
                            </div>
                            <!-- 펄스 효과 -->
                            <div class="absolute inset-0 rounded-2xl bg-gradient-to-br from-primary to-secondary opacity-0 group-hover:opacity-20 animate-ping"></div>
                        </div>
                        
                        <!-- 타이틀 -->
                        <div class="flex flex-col">
                            <h1 class="text-2xl font-black bg-gradient-to-r from-white via-gray-100 to-white bg-clip-text text-transparent tracking-tight">
                                 페이
                            </h1>
                            <div class="text-xs text-gray-400 font-medium tracking-widest uppercase">
                                Payment System
                            </div>
                        </div>
                    </a>

                    <!-- 네비게이션 인디케이터 -->
                    <!-- <div class="hidden lg:flex items-center gap-2 ml-8">
                        <div class="w-2 h-2 bg-green-400 rounded-full animate-pulse"></div>
                        <span class="text-sm text-gray-400">시스템 정상 운영중</span>
                    </div> -->
                </div>

                <!-- 우측 컨트롤 -->
                <div class="flex items-center gap-4">
                    <!-- 사용자 정보 카드 -->
                    <div class="flex items-center gap-4">
                        <?php if ($row['grade'] == 'admin') { ?>
                        <!-- 관리자 배지 -->
                        <div class="group relative">
                            <div class="absolute inset-0 bg-gradient-to-r from-purple-600 to-pink-600 rounded-2xl blur-sm opacity-70 group-hover:opacity-100 transition-opacity"></div>
                            <div class="relative flex items-center gap-3 bg-gradient-to-r from-purple-600/90 to-pink-600/90 px-4 py-2 rounded-2xl backdrop-blur-sm border border-purple-400/30">
                                <div class="w-8 h-8 bg-gradient-to-br from-purple-400 to-pink-400 rounded-full flex items-center justify-center shadow-lg">
                                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                    </svg>
                                </div>
                                <div class="text-white">
                                    <div class="text-sm font-bold">관리자</div>
                                    <div class="text-xs text-purple-100 opacity-90">Administrator</div>
                                </div>
                            </div>
                        </div>
                        <?php } else { ?>
                        <!-- 일반 사용자 -->
                        <div class="group relative">
                            <div class="absolute inset-0 bg-gradient-to-r from-blue-600 to-cyan-600 rounded-2xl blur-sm opacity-70 group-hover:opacity-100 transition-opacity"></div>
                            <div class="relative flex items-center gap-3 bg-gradient-to-r from-blue-600/90 to-cyan-600/90 px-4 py-2 rounded-2xl backdrop-blur-sm border border-blue-400/30">
                                <div class="w-8 h-8 bg-gradient-to-br from-blue-400 to-cyan-400 rounded-full flex items-center justify-center shadow-lg">
                                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                    </svg>
                                </div>
                                <div class="text-white">
                                    <div class="text-sm font-bold"><?= $row['user_id'] ?></div>
                                    <div class="text-xs text-blue-100 opacity-90">Member</div>
                                </div>
                            </div>
                        </div>

                        <!-- 잔액 표시 -->
                        <div class="group relative">
                            <div class="absolute inset-0 bg-gradient-to-r from-green-600 to-emerald-600 rounded-2xl blur-sm opacity-70 group-hover:opacity-100 transition-opacity"></div>
                            <div class="relative flex items-center gap-3 bg-gradient-to-r from-green-600/90 to-emerald-600/90 px-4 py-2 rounded-2xl backdrop-blur-sm border border-green-400/30">
                                <div class="w-8 h-8 bg-gradient-to-br from-green-400 to-emerald-400 rounded-full flex items-center justify-center shadow-lg">
                                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </div>
                                <div class="text-white">
                                    <div class="text-lg font-black tabular-nums"><?= number_format($row['amount']) ?>원</div>
                                    <div class="text-xs text-green-100 opacity-90">잔액</div>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>

                    <!-- URL 공유 섹션 -->
                    <div class="hidden xl:flex items-center gap-3 bg-slate-800/50 backdrop-blur-xl border border-slate-700/50 rounded-2xl p-4 shadow-xl">
                        <div class="flex items-center gap-3 flex-1">
                            <div class="w-8 h-8 bg-gradient-to-br from-cyan-500 to-blue-500 rounded-lg flex items-center justify-center shadow-lg">
                                <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
                                </svg>
                            </div>
                            <div class="flex-1 min-w-0">
                                <div class="text-xs text-gray-400 font-medium">공유 링크</div>
                                <code id="urlText" class="text-sm text-gray-300 font-mono truncate block max-w-40">
                                    <!-- https://tinyurl.com/2dluqlea -->
                                    https://mb-0606.com/payment_select.php
                                </code>
                            </div>
                        </div>
                        
                        <button onclick="copyToClipboard('urlText', this)"
                            class="group relative overflow-hidden bg-gradient-to-r from-cyan-600 to-blue-600 hover:from-cyan-500 hover:to-blue-500 px-4 py-2 rounded-xl text-white font-medium transition-all duration-300 shadow-lg hover:shadow-xl hover:scale-105">
                            <div class="absolute inset-0 bg-gradient-to-r from-white/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity"></div>
                            <div class="relative flex items-center gap-2">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"></path>
                                </svg>
                                <span class="btn-text">복사</span>
                            </div>
                        </button>
                    </div>

                    <!-- 로그아웃 버튼 -->
                    <form method="POST" action="logout_insert.php">
                        <button type="submit"
                            class="group relative overflow-hidden bg-gradient-to-r from-red-600 to-pink-600 hover:from-red-500 hover:to-pink-500 px-6 py-3 rounded-xl text-white font-semibold transition-all duration-300 shadow-lg hover:shadow-xl hover:scale-105 border border-red-400/30">
                            <div class="absolute inset-0 bg-gradient-to-r from-white/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity"></div>
                            <div class="relative flex items-center gap-2">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                                </svg>
                                <span>로그아웃</span>
                            </div>
                        </button>
                    </form>

                    <!-- 모바일 메뉴 토글 -->
                    <button onclick="toggleSidebar()" 
                        class="md:hidden w-12 h-12 bg-gradient-to-br from-primary to-secondary rounded-xl flex items-center justify-center shadow-lg hover:shadow-xl transition-all duration-300 hover:scale-105">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- 하단 보더 애니메이션 -->
        <div class="absolute bottom-0 left-0 right-0 h-px bg-gradient-to-r from-transparent via-primary/50 to-transparent"></div>
    </header>

    <!-- 스크립트는 동일하게 유지 -->
    <script>
        function copyToClipboard(elementId, buttonElement) {
            const element = document.getElementById(elementId);
            const text = element.textContent || element.innerText;

            if (navigator.clipboard && window.isSecureContext) {
                navigator.clipboard.writeText(text).then(() => {
                    showCopySuccess(buttonElement);
                }).catch(() => {
                    fallbackCopy(text, buttonElement);
                });
            } else {
                fallbackCopy(text, buttonElement);
            }
        }

        function fallbackCopy(text, buttonElement) {
            const textArea = document.createElement('textarea');
            textArea.value = text;
            textArea.style.position = 'fixed';
            textArea.style.left = '-999999px';
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            try {
                const success = document.execCommand('copy');
                if (success) {
                    showCopySuccess(buttonElement);
                }
            } catch (err) {
                console.error('복사 실패:', err);
            }

            document.body.removeChild(textArea);
        }

        function showCopySuccess(buttonElement) {
            const btnTextElement = buttonElement.querySelector('.btn-text');
            const originalText = btnTextElement ? btnTextElement.textContent : buttonElement.textContent;

            if (btnTextElement) {
                btnTextElement.textContent = '복사됨!';
            }

            // 성공 색상으로 변경
            buttonElement.className = buttonElement.className.replace(
                'from-cyan-600 to-blue-600', 
                'from-green-600 to-emerald-600'
            );

            setTimeout(() => {
                if (btnTextElement) {
                    btnTextElement.textContent = originalText;
                }
                buttonElement.className = buttonElement.className.replace(
                    'from-green-600 to-emerald-600', 
                    'from-cyan-600 to-blue-600'
                );
            }, 2000);
        }
    </script>

    <?php if ($isAdmin): ?>

        <!-- header.php의 </body> 태그 바로 위에 추가 -->

        <!-- ==================== 모달 HTML ==================== -->

        <!-- header.php의 </body> 태그 바로 위에 추가 -->

        <!-- ==================== 모달 HTML ==================== -->

        <!-- 지급 모달 -->
        <div id="paymentModal"
            class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden flex items-center justify-center p-4">
            <div class="bg-gray-900 rounded-xl shadow-2xl w-full max-w-md transform transition-all">
                <div class="bg-gradient-to-r from-green-600 to-green-700 p-4 rounded-t-xl">
                    <div class="flex justify-between items-center">
                        <h3 class="text-xl font-bold text-white flex items-center">
                            <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                                </path>
                            </svg>
                            지급
                        </h3>
                        <button onclick="closeModal('paymentModal')" class="text-white hover:text-gray-200">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>
                </div>

                <form id="paymentForm" class="p-6 space-y-4">
                    <input type="hidden" id="payment_user_id" name="user_id">

                    <div>
                        <label class="block text-sm text-gray-400 mb-2">가맹점명</label>
                        <input type="text" id="payment_user_name" readonly
                            class="w-full px-4 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg">
                    </div>

                    <div>
                        <label class="block text-sm text-gray-400 mb-2">현재 잔액</label>
                        <input type="text" id="payment_current_balance" readonly
                            class="w-full px-4 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg">
                    </div>

                    <div>
                    <label class="block text-sm text-gray-400 mb-2">지급 금액 <span class="text-red-400">*</span></label>
                    <input type="text" id="payment_amount" name="amount" required
                            class="w-full px-4 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500"
                            placeholder="지급할 금액을 입력하세요"
                            oninput="formatNumberInput(this)"
                            onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                    </div>

                    <div>
                        <label class="block text-sm text-gray-400 mb-2">메모</label>
                        <textarea id="payment_memo" name="memo" rows="3"
                            class="w-full px-4 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500"
                            placeholder="메모를 입력하세요 (선택사항)"></textarea>
                    </div>

                    <div class="flex gap-3 pt-4">
                        <button type="submit"
                            class="flex-1 px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition font-medium">
                            지급 처리
                        </button>
                        <button type="button" onclick="closeModal('paymentModal')"
                            class="flex-1 px-4 py-2 bg-gray-700 text-white rounded-lg hover:bg-gray-600 transition">
                            취소
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- 회수 모달 -->
        <div id="withdrawModal"
            class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden flex items-center justify-center p-4">
            <div class="bg-gray-900 rounded-xl shadow-2xl w-full max-w-md transform transition-all">
                <div class="bg-gradient-to-r from-red-600 to-red-700 p-4 rounded-t-xl">
                    <div class="flex justify-between items-center">
                        <h3 class="text-xl font-bold text-white flex items-center">
                            <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2zM10 8.5a.5.5 0 11-1 0 .5.5 0 011 0zm5 5a.5.5 0 11-1 0 .5.5 0 011 0z">
                                </path>
                            </svg>
                            회수
                        </h3>
                        <button onclick="closeModal('withdrawModal')" class="text-white hover:text-gray-200">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>
                </div>

                <form id="withdrawForm" class="p-6 space-y-4">
                    <input type="hidden" id="withdraw_user_id" name="user_id">

                    <div>
                        <label class="block text-sm text-gray-400 mb-2">가맹점명</label>
                        <input type="text" id="withdraw_user_name" readonly
                            class="w-full px-4 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg">
                    </div>

                    <div>
                        <label class="block text-sm text-gray-400 mb-2">현재 잔액</label>
                        <input type="text" id="withdraw_current_balance" readonly
                            class="w-full px-4 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg">
                    </div>

                    <div>
                    <label class="block text-sm text-gray-400 mb-2">회수 금액 <span class="text-red-400">*</span></label>
                    <input type="text" id="withdraw_amount" name="amount" required
                            class="w-full px-4 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-red-500"
                            placeholder="회수할 금액을 입력하세요"
                            oninput="formatNumberInput(this)"
                            onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                    </div>

                    <div>
                        <label class="block text-sm text-gray-400 mb-2">메모</label>
                        <textarea id="withdraw_memo" name="memo" rows="3"
                            class="w-full px-4 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-red-500"
                            placeholder="메모를 입력하세요 (선택사항)"></textarea>
                    </div>

                    <div class="flex gap-3 pt-4">
                        <button type="submit"
                            class="flex-1 px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition font-medium">
                            회수 처리
                        </button>
                        <button type="button" onclick="closeModal('withdrawModal')"
                            class="flex-1 px-4 py-2 bg-gray-700 text-white rounded-lg hover:bg-gray-600 transition">
                            취소
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- 거래내역 모달 -->
        <div id="historyModal"
            class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden flex items-center justify-center p-4">
            <div
                class="bg-gray-900 rounded-xl shadow-2xl w-full max-w-4xl max-h-[90vh] flex flex-col transform transition-all">
                <div class="bg-gradient-to-r from-blue-600 to-blue-700 p-4 rounded-t-xl">
                    <div class="flex justify-between items-center">
                        <h3 class="text-xl font-bold text-white flex items-center">
                            <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01">
                                </path>
                            </svg>
                            거래내역
                        </h3>
                        <button onclick="closeModal('historyModal')" class="text-white hover:text-gray-200">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>
                </div>

                <div class="p-6 flex-1 overflow-y-auto">
                    <input type="hidden" id="history_user_id">

                    <!-- 가맹점 정보 -->
                    <div class="bg-gray-800 rounded-lg p-4 mb-4">
                        <div class="grid grid-cols-2 md:grid-cols-6 gap-4">
                            <div>
                                <span class="text-gray-400 text-sm">가맹점명</span>
                                <p id="history_user_name" class="text-white font-medium"></p>
                            </div>
                            <div>
                                <span class="text-gray-400 text-sm">현재 잔액</span>
                                <p id="history_current_balance" class="text-white font-medium"></p>
                            </div>
                            <div>
                                <span class="text-gray-400 text-sm">총 입금</span>
                                <p id="history_total_deposit" class="text-green-400 font-medium"></p>
                            </div>
                            <div>
                                <span class="text-gray-400 text-sm">총 출금</span>
                                <p id="history_total_withdraw" class="text-red-400 font-medium"></p>
                            </div>
                            <div>
                                <span class="text-gray-400 text-sm">입금수수료</span>
                                <p id="history_total_deposit_fee" class="text-yellow-400 font-medium"></p>
                            </div>
                            <div>
                                <span class="text-gray-400 text-sm">출금수수료</span>
                                <p id="history_total_withdraw_fee" class="text-orange-400 font-medium"></p>
                            </div>
                        </div>
                    </div>

                    <!-- 필터 -->
                    <div class="flex flex-wrap gap-3 mb-4">
                        <select id="history_filter_type"
                            class="px-3 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg text-sm">
                            <option value="">전체 유형</option>
                            <option value="deposit">입금</option>
                            <option value="withdraw">출금</option>
                        </select>

                        <input type="date" id="history_date_from"
                            class="px-3 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg text-sm">

                        <input type="date" id="history_date_to"
                            class="px-3 py-2 bg-gray-800 text-white border border-gray-700 rounded-lg text-sm">

                        <button onclick="loadTransactionHistory()"
                            class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition text-sm">
                            조회
                        </button>

                        <button onclick="exportHistory()"
                            class="px-4 py-2 bg-gray-700 text-white rounded-lg hover:bg-gray-600 transition text-sm">
                            엑셀 다운로드
                        </button>
                    </div>

                    <!-- 거래내역 테이블 -->
                    <table class="w-full text-sm">
                        <thead class="bg-gray-800 text-gray-300">
                            <tr>
                                <th class="px-4 py-3 text-left">일시</th>
                                <th class="px-4 py-3 text-left">유형</th>
                                <th class="px-4 py-3 text-right">금액</th>
                                <th class="px-4 py-3 text-right">잔액</th>
                                <th class="px-4 py-3 text-left">입금자</th>
                                <th class="px-4 py-3 text-left">처리일시</th>
                                <th class="px-4 py-3 text-left">메모</th>
                                <th class="px-4 py-3 text-left">처리자</th>
                            </tr>
                        </thead>
                        <tbody id="historyTableBody" class="divide-y divide-gray-700">
                            <!-- 동적으로 로드됩니다 -->
                        </tbody>
                    </table>

                    <!-- 로딩 표시 -->
                    <div id="historyLoading" class="hidden text-center py-8">
                        <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-white"></div>
                        <p class="text-gray-400 mt-2">로딩중...</p>
                    </div>

                    <!-- 페이지네이션 -->
                    <div id="historyPagination" class="flex justify-center gap-2 mt-4">
                        <!-- 동적으로 생성됩니다 -->
                    </div>
                </div>
            </div>
        </div>

        

        <!-- ==================== JavaScript ==================== -->
        <script>
            // ========== 모달 기본 함수 ==========

            // 모달 열기
            function openModal(modalId) {
                const modal = document.getElementById(modalId);
                if (modal) {
                    modal.classList.remove('hidden');
                    document.body.style.overflow = 'hidden';
                } else {
                    console.error(`모달을 찾을 수 없습니다: ${modalId}`);
                }
            }

            // 모달 닫기
            function closeModal(modalId) {
                const modal = document.getElementById(modalId);
                if (modal) {
                    modal.classList.add('hidden');
                    document.body.style.overflow = 'auto';

                    // 폼 리셋
                    if (modalId === 'paymentModal') {
                        const form = document.getElementById('paymentForm');
                        if (form) form.reset();
                    } else if (modalId === 'withdrawModal') {
                        const form = document.getElementById('withdrawForm');
                        if (form) form.reset();
                    }
                }
            }

            // ========== 드롭다운에서 호출되는 핸들러 함수 ==========

            // 지급 처리 - 모달 열기
            function handlePayment(userId, userName) {
                // 드롭다운 먼저 닫기
                closeAllDropdowns();

                // 지급 모달 데이터 설정
                document.getElementById('payment_user_id').value = userId;
                document.getElementById('payment_user_name').value = userName;

                // 현재 잔액 조회
                fetch(`/ajax/get_member_balance.php?user_id=${userId}`)
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            document.getElementById('payment_current_balance').value =
                                Number(data.balance).toLocaleString() + '원';
                        }
                    })
                    .catch(err => {
                        console.error('잔액 조회 오류:', err);
                        document.getElementById('payment_current_balance').value = '조회 실패';
                    });

                openModal('paymentModal');
            }

            // 회수 처리 - 모달 열기
            function handleWithdraw(userId, userName) {
                // 드롭다운 먼저 닫기
                closeAllDropdowns();

                // 회수 모달 데이터 설정
                document.getElementById('withdraw_user_id').value = userId;
                document.getElementById('withdraw_user_name').value = userName;

                // 현재 잔액 조회
                fetch(`/ajax/get_member_balance.php?user_id=${userId}`)
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            document.getElementById('withdraw_current_balance').value =
                                Number(data.balance).toLocaleString() + '원';

                            // 회수 가능 금액 제한 설정
                            document.getElementById('withdraw_amount').max = data.balance;
                            document.getElementById('withdraw_amount').placeholder =
                                `최대 ${Number(data.balance).toLocaleString()}원까지 회수 가능`;
                        }
                    })
                    .catch(err => {
                        console.error('잔액 조회 오류:', err);
                        document.getElementById('withdraw_current_balance').value = '조회 실패';
                    });

                openModal('withdrawModal');
            }

            // 거래내역 보기 - 모달 열기
            function handleTransactionHistory(userId, userName) {
                // 드롭다운 먼저 닫기
                closeAllDropdowns();

                // 거래내역 모달 데이터 설정
                document.getElementById('history_user_id').value = userId;
                document.getElementById('history_user_name').textContent = userName;

                // 오늘 날짜로 기본값 설정
                const today = new Date();
                const twoDaysAgo = new Date();
                twoDaysAgo.setDate(today.getDate() - 2);

                document.getElementById('history_date_from').value = twoDaysAgo.toISOString().split('T')[0];
                document.getElementById('history_date_to').value = today.toISOString().split('T')[0];

                // 필터 초기화
                document.getElementById('history_filter_type').value = '';

                openModal('historyModal');
                loadTransactionHistory();
            }

            // 모든 드롭다운 닫기 헬퍼 함수
            function closeAllDropdowns() {
                document.querySelectorAll('.dropdown-menu').forEach(menu => {
                    menu.classList.add('hidden');
                });
                document.querySelectorAll('[class*="dropdown-arrow-"]').forEach(arrow => {
                    arrow.style.transform = 'rotate(0deg)';
                });
            }

            // ========== 거래내역 관련 함수 ==========

            // 거래내역 로드
            function loadTransactionHistory(page = 1) {
                const userId = document.getElementById('history_user_id').value;
                const filterType = document.getElementById('history_filter_type').value;
                const dateFrom = document.getElementById('history_date_from').value;
                const dateTo = document.getElementById('history_date_to').value;

                document.getElementById('historyLoading').classList.remove('hidden');
                document.getElementById('historyTableBody').innerHTML = '';

                const params = new URLSearchParams({
                    user_id: userId,
                    type: filterType,
                    date_from: dateFrom,
                    date_to: dateTo,
                    page: page
                });

                fetch(`/ajax/get_transaction_history.php?${params}`)
                    .then(res => res.json())
                    .then(data => {
                        document.getElementById('historyLoading').classList.add('hidden');

                        if (data.success) {
                            // 요약 정보 업데이트 - 수수료 항목 추가
                            document.getElementById('history_current_balance').textContent =
                                Number(data.balance).toLocaleString() + '원';
                            document.getElementById('history_total_deposit').textContent =
                                Number(data.total_deposit).toLocaleString() + '원';
                            document.getElementById('history_total_withdraw').textContent =
                                Number(data.total_withdraw).toLocaleString() + '원';
                            
                            // 수수료 항목들 업데이트
                            document.getElementById('history_total_deposit_fee').textContent =
                                Number(data.total_deposit_fee).toLocaleString() + '원';
                            document.getElementById('history_total_withdraw_fee').textContent =
                                Number(data.total_withdraw_fee).toLocaleString() + '원';

                            // 거래내역 표시
                            displayTransactionHistory(data.transactions);

                            // 페이지네이션
                            updateHistoryPagination(data.total_pages, data.current_page);
                        }
                    })
                    .catch(err => {
                        console.error(err);
                        document.getElementById('historyLoading').classList.add('hidden');
                        alert('거래내역 조회 중 오류가 발생했습니다.');
                    });
            }
            // 거래내역 표시
            function displayTransactionHistory(transactions) {
                const tbody = document.getElementById('historyTableBody');
                
                if (transactions.length === 0) {
                    tbody.innerHTML = `
                        <tr>
                            <td colspan="8" class="text-center py-8 text-gray-400">
                            해당 기간에 거래내역이 없습니다.
                            </td>
                        </tr>
                    `;
                    return;
                }
                
                transactions.forEach(tx => {
                    const row = document.createElement('tr');
                    row.className = 'hover:bg-gray-800 transition';
                    
                    // 타입별 색상과 표시
                    let typeClass = '';
                    let typeText = tx.type_text;
                    let typeBadge = '';
                    
                    if (tx.source === 'manual') {
                        if (tx.type === 'deposit') {
                            typeClass = 'text-yellow-400';
                            typeBadge = '<span class="ml-1 px-2 py-0.5 bg-yellow-900 text-yellow-300 text-xs rounded">수동</span>';
                        } else {
                            typeClass = 'text-orange-400';
                            typeBadge = '<span class="ml-1 px-2 py-0.5 bg-orange-900 text-orange-300 text-xs rounded">수동</span>';
                        }
                    } else {
                        typeClass = tx.type === 'deposit' ? 'text-green-400' : 'text-red-400';
                    }
                    
                    const amountSign = tx.type === 'deposit' ? '+' : '-';
                    
                    row.innerHTML = `
                        <td class="px-4 py-3 text-gray-300">${tx.created_at}</td>
                        <td class="px-4 py-3">
                            <div class="flex items-center">
                                <span class="${typeClass} font-medium">${typeText}</span>
                                ${typeBadge}
                            </div>
                        </td>
                        <td class="px-4 py-3 text-right ${typeClass} font-medium">
                            ${amountSign}${Number(tx.amount).toLocaleString()}원
                        </td>
                        <td class="px-4 py-3 text-right text-white">
                            ${Number(tx.balance_after).toLocaleString()}원
                        </td>
                        <td class="px-4 py-3 text-gray-300">
                            ${tx.depositor_name || '-'}
                        </td>
                        <td class="px-4 py-3 text-gray-400 text-xs">
                            ${tx.processed_at}
                        </td>
                        <td class="px-4 py-3 text-gray-400 text-xs">
                            ${tx.memo || '-'}
                        </td>
                        <td class="px-4 py-3 text-gray-400 text-xs">
                            ${tx.admin_name || '-'}
                        </td>
                    `;
                    
                    tbody.appendChild(row);
                });
            }

            // 페이지네이션 업데이트
            function updateHistoryPagination(totalPages, currentPage) {
                const pagination = document.getElementById('historyPagination');
                pagination.innerHTML = '';

                if (totalPages <= 1) return;

                // 이전 버튼
                if (currentPage > 1) {
                    const prevBtn = document.createElement('button');
                    prevBtn.textContent = '이전';
                    prevBtn.className = 'px-3 py-1 bg-gray-800 text-white rounded hover:bg-gray-700 transition text-sm';
                    prevBtn.onclick = () => loadTransactionHistory(currentPage - 1);
                    pagination.appendChild(prevBtn);
                }

                // 페이지 번호
                for (let i = 1; i <= totalPages; i++) {
                    if (i <= 2 || i > totalPages - 2 || (i >= currentPage - 1 && i <= currentPage + 1)) {
                        const pageBtn = document.createElement('button');
                        pageBtn.textContent = i;
                        pageBtn.className = i === currentPage
                            ? 'px-3 py-1 bg-blue-600 text-white rounded text-sm'
                            : 'px-3 py-1 bg-gray-800 text-white rounded hover:bg-gray-700 transition text-sm';
                        pageBtn.onclick = () => loadTransactionHistory(i);
                        pagination.appendChild(pageBtn);
                    } else if (i === 3 || i === totalPages - 2) {
                        const dots = document.createElement('span');
                        dots.textContent = '...';
                        dots.className = 'px-2 text-gray-500';
                        pagination.appendChild(dots);
                    }
                }

                // 다음 버튼
                if (currentPage < totalPages) {
                    const nextBtn = document.createElement('button');
                    nextBtn.textContent = '다음';
                    nextBtn.className = 'px-3 py-1 bg-gray-800 text-white rounded hover:bg-gray-700 transition text-sm';
                    nextBtn.onclick = () => loadTransactionHistory(currentPage + 1);
                    pagination.appendChild(nextBtn);
                }
            }

            // 엑셀 다운로드
            function exportHistory() {
                const userId = document.getElementById('history_user_id').value;
                const filterType = document.getElementById('history_filter_type').value;
                const dateFrom = document.getElementById('history_date_from').value;
                const dateTo = document.getElementById('history_date_to').value;

                const params = new URLSearchParams({
                    user_id: userId,
                    type: filterType,
                    date_from: dateFrom,
                    date_to: dateTo,
                    export: 'excel'
                });

                window.location.href = `/ajax/export_transaction_history.php?${params}`;
            }

            // 숫자 포맷팅 함수 (콤마 추가)
            function formatNumberInput(input) {
                // 숫자가 아닌 문자 제거
                let value = input.value.replace(/[^0-9]/g, '');
                
                // 콤마 추가
                if (value) {
                    value = Number(value).toLocaleString();
                }
                
                input.value = value;
            }

            // 숫자만 입력 가능하게 하고 실제 값 반환
            function getNumberValue(input) {
                return input.value.replace(/[^0-9]/g, '');
            }

            // ========== 폼 제출 핸들러 ==========

            // 4. 지급 폼 제출 부분을 다음과 같이 수정
            document.getElementById('paymentForm')?.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // 금액 입력값에서 콤마 제거
            const amountInput = document.getElementById('payment_amount');
            const actualAmount = getNumberValue(amountInput);
            
            // 금액 검증
            if (!actualAmount || actualAmount === '0') {
                alert('올바른 금액을 입력해주세요.');
                return;
            }
            
            const formData = new FormData(this);
            formData.set('amount', actualAmount); // 콤마 제거된 실제 숫자값 전송
            formData.append('type', 'deposit');
            
            fetch('/ajax/process_transaction.php', {
                method: 'POST',
                body: formData
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                alert('지급 처리가 완료되었습니다.');
                closeModal('paymentModal');
                // 가맹점 목록 새로고침 (있는 경우)
                if (typeof fetchStores === 'function') {
                    fetchStores();
                }
                } else {
                alert(data.message || '처리 중 오류가 발생했습니다.');
                }
            })
            .catch(err => {
                console.error(err);
                alert('처리 중 오류가 발생했습니다.');
            });
            });

            // 5. 회수 폼 제출 부분을 다음과 같이 수정
            document.getElementById('withdrawForm')?.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // 금액 입력값에서 콤마 제거
            const amountInput = document.getElementById('withdraw_amount');
            const actualAmount = getNumberValue(amountInput);
            
            // 금액 검증
            if (!actualAmount || actualAmount === '0') {
                alert('올바른 금액을 입력해주세요.');
                return;
            }
            
            // 잔액 초과 검증
            const currentBalance = document.getElementById('withdraw_current_balance').value;
            const balanceNumber = parseInt(currentBalance.replace(/[^0-9]/g, ''));
            if (parseInt(actualAmount) > balanceNumber) {
                alert('잔액을 초과하여 회수할 수 없습니다.');
                return;
            }
            
            const formData = new FormData(this);
            formData.set('amount', actualAmount); // 콤마 제거된 실제 숫자값 전송
            formData.append('type', 'withdraw');
            
            fetch('/ajax/process_transaction.php', {
                method: 'POST',
                body: formData
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                alert('회수 처리가 완료되었습니다.');
                closeModal('withdrawModal');
                // 가맹점 목록 새로고침 (있는 경우)
                if (typeof fetchStores === 'function') {
                    fetchStores();
                }
                } else {
                alert(data.message || '처리 중 오류가 발생했습니다.');
                }
            })
            .catch(err => {
                console.error(err);
                alert('처리 중 오류가 발생했습니다.');
            });
            });

            // ========== 이벤트 리스너 ==========

            // ESC 키로 모달 닫기
            document.addEventListener('keydown', function (e) {
                if (e.key === 'Escape') {
                    ['paymentModal', 'withdrawModal', 'historyModal'].forEach(modalId => {
                        const modal = document.getElementById(modalId);
                        if (modal && !modal.classList.contains('hidden')) {
                            closeModal(modalId);
                        }
                    });
                }
            });

            // 모달 외부 클릭시 닫기
            document.addEventListener('DOMContentLoaded', function () {
                ['paymentModal', 'withdrawModal', 'historyModal'].forEach(modalId => {
                    const modal = document.getElementById(modalId);
                    if (modal) {
                        modal.addEventListener('click', function (e) {
                            if (e.target === this) {
                                closeModal(modalId);
                            }
                        });
                    }
                });
            });
        </script>

        <!-- ==================== CSS ==================== -->
        <style>
            /* 모달 애니메이션 */
            #paymentModal:not(.hidden)>div,
            #withdrawModal:not(.hidden)>div,
            #historyModal:not(.hidden)>div {
                animation: modalSlideIn 0.3s ease-out;
            }

            @keyframes modalSlideIn {
                from {
                    opacity: 0;
                    transform: translateY(-20px);
                }

                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            /* 로딩 애니메이션 */
            @keyframes spin {
                from {
                    transform: rotate(0deg);
                }

                to {
                    transform: rotate(360deg);
                }
            }

            .animate-spin {
                animation: spin 1s linear infinite;
            }

            /* 드롭다운 애니메이션 */
            .dropdown-container {
                position: relative;
            }

            .dropdown-menu {
                animation: fadeIn 0.2s ease-in-out;
            }

            [class*="dropdown-arrow-"] {
                transition: transform 0.2s ease;
            }

            @keyframes fadeIn {
                from {
                    opacity: 0;
                    transform: translateY(-10px);
                }

                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            /* 모바일 반응형 */
            @media (max-width: 768px) {
                .dropdown-menu {
                    position: fixed;
                    left: 50% !important;
                    transform: translateX(-50%);
                    width: 90%;
                    max-width: 200px;
                }
            }
        </style>

        <!-- ==================== CSS ==================== -->
        <style>
            /* 모달 애니메이션 */
            #paymentModal:not(.hidden)>div,
            #withdrawModal:not(.hidden)>div,
            #historyModal:not(.hidden)>div {
                animation: modalSlideIn 0.3s ease-out;
            }

            @keyframes modalSlideIn {
                from {
                    opacity: 0;
                    transform: translateY(-20px);
                }

                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            /* 로딩 애니메이션 */
            @keyframes spin {
                from {
                    transform: rotate(0deg);
                }

                to {
                    transform: rotate(360deg);
                }
            }

            .animate-spin {
                animation: spin 1s linear infinite;
            }

            /* 드롭다운 애니메이션 */
            .dropdown-container {
                position: relative;
            }

            .dropdown-menu {
                animation: fadeIn 0.2s ease-in-out;
            }

            [class*="dropdown-arrow-"] {
                transition: transform 0.2s ease;
            }

            @keyframes fadeIn {
                from {
                    opacity: 0;
                    transform: translateY(-10px);
                }

                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            /* 모바일 반응형 */
            @media (max-width: 768px) {
                .dropdown-menu {
                    position: fixed;
                    left: 50% !important;
                    transform: translateX(-50%);
                    width: 90%;
                    max-width: 200px;
                }
            }
        </style>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                // 전역 변수들
                let requestAlarmTimeout = null;
                let pendingAlarmTimeout = null;  // pending 알람용 타이머 추가
                let titleBlinkInterval = null;
                let originalTitle = document.title;
                let isRequestAlarmPlaying = false;
                let isPendingAlarmPlaying = false;  // pending 알람 상태 추가
                let soundSettings = null;
                let lastPendingIds = new Set();
                let lastRequestedIds = new Set();
                
                // 사운드 설정 로드
                function loadSoundSettings() {
                    return fetch('/ajax/get_sound_settings.php')
                        .then(res => res.json())
                        .then(data => {
                            if (data.success && data.settings) {
                                soundSettings = data.settings;
                                console.log('사운드 설정 로드 완료:', soundSettings);
                            } else {
                                // 기본값 설정
                                soundSettings = {
                                    sound_enabled: 1,
                                    master_volume: 70,
                                    withdrawal_sound_enabled: 1,
                                    withdrawal_volume: 70,
                                    withdrawal_sound_file: '/assets/sound/exchange.mp3',
                                    deposit_pending_sound_enabled: 1,
                                    deposit_pending_volume: 50,
                                    deposit_pending_sound_file: '/assets/sound/charge.mp3',
                                    deposit_requested_sound_enabled: 1,
                                    deposit_requested_volume: 60,
                                    deposit_requested_sound_file: '/assets/sound/request.mp3',
                                    deposit_requested_repeat: 1
                                };
                            }
                        })
                        .catch(error => {
                            console.error('사운드 설정 로드 실패:', error);
                        });
                }
                
                // 사운드 재생 헬퍼 함수
                function playSoundWithSettings(type) {
                    if (!soundSettings || soundSettings.sound_enabled != 1) {
                        return;
                    }
                    
                    let enabled = false;
                    let volume = 0;
                    let soundFile = '';
                    
                    switch(type) {
                        case 'withdrawal':
                            enabled = soundSettings.withdrawal_sound_enabled == 1;
                            volume = (soundSettings.withdrawal_volume || 70) / 100;
                            soundFile = soundSettings.withdrawal_sound_file || '/assets/sound/exchange.mp3';
                            if (!soundFile.startsWith('/')) {
                                soundFile = '/assets/sound/' + soundFile;
                            }
                            break;
                            
                        case 'deposit-pending':
                            enabled = soundSettings.deposit_pending_sound_enabled == 1;
                            volume = (soundSettings.deposit_pending_volume || 50) / 100;
                            soundFile = soundSettings.deposit_pending_sound_file || '/assets/sound/charge.mp3';
                            if (!soundFile.startsWith('/')) {
                                soundFile = '/assets/sound/' + soundFile;
                            }
                            break;
                            
                        case 'deposit-requested':
                            enabled = soundSettings.deposit_requested_sound_enabled == 1;
                            volume = (soundSettings.deposit_requested_volume || 60) / 100;
                            soundFile = soundSettings.deposit_requested_sound_file || '/assets/sound/request.mp3';
                            if (!soundFile.startsWith('/')) {
                                soundFile = '/assets/sound/' + soundFile;
                            }
                            break;
                    }
                    
                    if (enabled) {
                        const masterVolume = (soundSettings.master_volume || 70) / 100;
                        const audio = new Audio(soundFile);
                        audio.volume = volume * masterVolume;
                        audio.play().catch(error => {
                            console.error('사운드 재생 오류:', error);
                        });
                    }
                }
                
                // Pending 반복 알람 시작
                function startContinuousPendingAlarm(count) {
                    if (isPendingAlarmPlaying) return;
                    
                    isPendingAlarmPlaying = true;
                    console.log(`Pending 알람 시작: ${count}건`);
                    
                    function playPendingAlarm() {
                        if (!isPendingAlarmPlaying) return;
                        
                        playSoundWithSettings('deposit-pending');
                        
                        // 5초 후 다시 재생
                        pendingAlarmTimeout = setTimeout(() => {
                            playPendingAlarm();
                        }, 5000);
                    }
                    
                    playPendingAlarm();
                    
                    // 시각적 알림
                    startVisualAlerts(count, 'pending');
                }
                
                // Pending 알람 중지
                function stopPendingAlarm() {
                    isPendingAlarmPlaying = false;
                    if (pendingAlarmTimeout) {
                        clearTimeout(pendingAlarmTimeout);
                        pendingAlarmTimeout = null;
                    }
                    console.log('Pending 알람 중지');
                }
                
                // Requested 반복 알람
                function startContinuousRequestAlarm(count) {
                    if (!soundSettings || soundSettings.deposit_requested_repeat != 1) {
                        return;
                    }
                    
                    if (isRequestAlarmPlaying) return;
                    
                    isRequestAlarmPlaying = true;
                    console.log(`Requested 알람 시작: ${count}건`);
                    
                    function playAlarm() {
                        if (!isRequestAlarmPlaying) return;
                        
                        playSoundWithSettings('deposit-requested');
                        
                        requestAlarmTimeout = setTimeout(() => {
                            playAlarm();
                        }, 5000);
                    }
                    
                    playAlarm();
                    startVisualAlerts(count, 'requested');
                }
                
                // Requested 알람 중지
                function stopRequestAlarm() {
                    isRequestAlarmPlaying = false;
                    if (requestAlarmTimeout) {
                        clearTimeout(requestAlarmTimeout);
                        requestAlarmTimeout = null;
                    }
                    console.log('Requested 알람 중지');
                }
                
                // 백그라운드 알람 체크
                function checkDepositAlarms() {
                    fetch('/ajax/check_new_deposits.php')
                        .then(res => res.json())
                        .then(data => {
                            console.log('알람 체크 응답:', data);
                            
                            // Pending 상태 처리
                            if (data.hasPending && data.pendingCount > 0) {
                                // Pending 상태가 있으면 계속 알람
                                if (!isPendingAlarmPlaying) {
                                    startContinuousPendingAlarm(data.pendingCount);
                                }
                            } else {
                                // Pending이 없으면 알람 중지
                                if (isPendingAlarmPlaying) {
                                    stopPendingAlarm();
                                    stopVisualAlerts('pending');
                                }
                            }
                            
                            // Requested 상태 처리
                            if (data.hasRequested && data.requestedCount > 0) {
                                if (!isRequestAlarmPlaying) {
                                    startContinuousRequestAlarm(data.requestedCount);
                                }
                            } else {
                                if (isRequestAlarmPlaying) {
                                    stopRequestAlarm();
                                    stopVisualAlerts('requested');
                                }
                            }
                            
                            // 아무것도 없으면 모든 알람 중지
                            if (!data.hasPending && !data.hasRequested) {
                                stopAllAlarms();
                            }
                        })
                        .catch(error => {
                            console.error('알람 체크 오류:', error);
                        });
                }
                
                // 시각적 알림
                function startVisualAlerts(count, type) {
                    // 타이틀 깜빡임
                    if (!titleBlinkInterval) {
                        let isAlert = false;
                        titleBlinkInterval = setInterval(() => {
                            let message = type === 'pending' ? '입금대기' : '입금요청';
                            document.title = isAlert ? originalTitle : `⚠️ (${count}) ${message} 확인필요!`;
                            isAlert = !isAlert;
                        }, 1000);
                    }
                    
                    // 알림 바 표시
                    showNotificationBar(count, type);
                }
                
                // 알림 바 표시
                function showNotificationBar(count, type) {
                    const existingBar = document.getElementById('notificationBar');
                    if (existingBar) {
                        existingBar.remove();
                    }
                    
                    const message = type === 'pending' 
                        ? `${count}건의 입금 대기가 있습니다!` 
                        : `${count}건의 입금 요청이 대기 중입니다!`;
                    
                    const bgColor = type === 'pending' ? 'bg-yellow-600' : 'bg-red-600';
                    
                    const notificationBar = document.createElement('div');
                    notificationBar.id = 'notificationBar';
                    notificationBar.className = `fixed top-0 left-0 right-0 ${bgColor} text-white py-3 px-4 z-[9999] flex items-center justify-between animate-pulse`;
                    notificationBar.innerHTML = `
                        <div class="flex items-center gap-3">
                            <svg class="w-6 h-6 animate-bounce" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                    d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                            </svg>
                            <span class="font-bold text-lg">${message}</span>
                        </div>
                        <button onclick="goToDepositPage()" 
                                class="bg-white text-${bgColor.replace('bg-', '')} px-4 py-2 rounded-lg font-bold hover:bg-gray-100 transition">
                            확인하러 가기
                        </button>
                    `;
                    
                    document.body.appendChild(notificationBar);
                }
                
                // 시각적 알림 중지
                function stopVisualAlerts(type) {
                    if (!isPendingAlarmPlaying && !isRequestAlarmPlaying) {
                        if (titleBlinkInterval) {
                            clearInterval(titleBlinkInterval);
                            titleBlinkInterval = null;
                            document.title = originalTitle;
                        }
                        
                        const notificationBar = document.getElementById('notificationBar');
                        if (notificationBar) {
                            notificationBar.remove();
                        }
                    }
                }
                
                // 모든 알람 중지
                function stopAllAlarms() {
                    stopPendingAlarm();
                    stopRequestAlarm();
                    
                    if (titleBlinkInterval) {
                        clearInterval(titleBlinkInterval);
                        titleBlinkInterval = null;
                        document.title = originalTitle;
                    }
                    
                    const notificationBar = document.getElementById('notificationBar');
                    if (notificationBar) {
                        notificationBar.remove();
                    }
                }
                
                // 입금 페이지로 이동
                window.goToDepositPage = function() {
                    window.location.href = '/deposit_manage.php';
                };
                
                // 출금 알람 체크
                function checkPendingWithdrawals() {
                    fetch('/module/withdrawal_status.php')
                        .then(response => response.json())
                        .then(data => {
                            if (!data.is_admin) return;
                            
                            if (data.status === 'requested' && data.count > 0) {
                                playSoundWithSettings('withdrawal');
                                console.log(`대기 중인 출금 신청: ${data.count}건`);
                            }
                        })
                        .catch(error => {
                            console.error('출금 상태 확인 오류:', error);
                        });
                }
                
                // 자동 취소
                function autoCancelPendingDeposits() {
                    fetch('/module/auto_cancel_pending.php')
                        .then(response => response.json())
                        .then(data => {
                            if (data.success && data.cancelled_count > 0) {
                                console.log(`[자동 취소] ${data.cancelled_count}건의 입금 신청이 시간 초과로 취소됨`);
                            }
                        })
                        .catch(error => {
                            console.error('[자동 취소] 네트워크 오류:', error);
                        });
                }
                
                // 초기화
                loadSoundSettings().then(() => {
                    checkPendingWithdrawals();
                    checkDepositAlarms();
                    autoCancelPendingDeposits();
                    
                    setInterval(checkPendingWithdrawals, 5000);
                    setInterval(checkDepositAlarms, 5000);
                    setInterval(autoCancelPendingDeposits, 60000);
                    setInterval(loadSoundSettings, 300000);
                });
            });
        </script>
        
    <?php endif; ?>

    <div class="flex">
        <!-- inc/sidebar.php -->
        <script>
            function toggleSidebar() {
                document.getElementById('sidebar').classList.toggle('-translate-x-full');
            }
        </script>

        <!-- 모바일 메뉴 열기 버튼 (상단에 배치 필요) -->
        <button class="md:hidden fixed top-4 left-4 z-40 bg-primary text-white p-2 rounded-full shadow-lg"
            onclick="toggleSidebar()">
            ☰
        </button>

        <?php
        include 'layout/side_bar.php';
        ?>