<!-- 데스크탑 사이드바 -->
<aside id="sidebar"
    class="fixed md:static z-30 top-0 left-0 w-64 h-full md:h-auto bg-gray-800/95 backdrop-blur-xl border-r border-gray-700/50 transform -translate-x-full md:translate-x-0 transition-transform duration-300 ease-in-out shadow-2xl">
    
    <!-- 사이드바 헤더 -->
    <div class="px-6 py-6 border-b border-gray-700/30">
        <div class="flex items-center gap-3">
            <div class="w-10 h-10 bg-gradient-to-br from-primary to-secondary rounded-xl flex items-center justify-center shadow-lg">
                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                </svg>
            </div>
            <div>
                <h2 class="text-lg font-bold text-white">관리 패널</h2>
                <p class="text-xs text-gray-400">올인원 페이</p>
            </div>
        </div>
    </div>

    <nav class="px-4 py-6 space-y-2">
        <!-- 가맹점 관리 섹션 -->
        <div class="mb-6">
            <div class="flex items-center gap-2 px-3 py-2 mb-3">
                <div class="w-1 h-4 bg-gradient-to-b from-primary to-secondary rounded-full"></div>
                <span class="text-xs font-semibold text-gray-400 uppercase tracking-wider">가맹점 관리</span>
            </div>
            
            <?php if ($row['grade'] != 'admin') { ?>
            <a href="code_manage.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-primary/20 hover:to-secondary/20 transition-all duration-200 border border-transparent hover:border-primary/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-primary/10 group-hover:bg-primary/20 transition-colors">
                    <svg class="w-4 h-4 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">코드 관리</div>
                    <div class="text-xs text-gray-500">가맹점 코드</div>
                </div>
            </a>
            <a href="partner_store_list.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-primary/20 hover:to-secondary/20 transition-all duration-200 border border-transparent hover:border-primary/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-blue-500/10 group-hover:bg-blue-500/20 transition-colors">
                    <svg class="w-4 h-4 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">가맹점 리스트</div>
                    <div class="text-xs text-gray-500">전체 가맹점</div>
                </div>
            </a>
            <?php } else { ?>

            <a href="admin_store_list.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-primary/20 hover:to-secondary/20 transition-all duration-200 border border-transparent hover:border-primary/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-blue-500/10 group-hover:bg-blue-500/20 transition-colors">
                    <svg class="w-4 h-4 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">가맹점 리스트</div>
                    <div class="text-xs text-gray-500">전체 가맹점</div>
                </div>
            </a>

            <a href="kakao_account_list.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-yellow-500/20 hover:to-yellow-600/20 transition-all duration-200 border border-transparent hover:border-yellow-500/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-yellow-500/10 group-hover:bg-yellow-500/20 transition-colors">
                    <svg class="w-4 h-4 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">카카오 계정</div>
                    <div class="text-xs text-gray-500">계정 리스트</div>
                </div>
            </a>

            <a href="bank_account_list.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-green-500/20 hover:to-green-600/20 transition-all duration-200 border border-transparent hover:border-green-500/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-green-500/10 group-hover:bg-green-500/20 transition-colors">
                    <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">은행 계좌</div>
                    <div class="text-xs text-gray-500">계좌 리스트</div>
                </div>
            </a>
            <?php } ?>
        </div>

        <!-- 거래 관리 섹션 -->
        <div class="mb-6">
            <div class="flex items-center gap-2 px-3 py-2 mb-3">
                <div class="w-1 h-4 bg-gradient-to-b from-green-400 to-blue-500 rounded-full"></div>
                <span class="text-xs font-semibold text-gray-400 uppercase tracking-wider">거래 관리</span>
            </div>

            <a href="deposit_manage.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-green-500/20 hover:to-emerald-500/20 transition-all duration-200 border border-transparent hover:border-green-500/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-green-500/10 group-hover:bg-green-500/20 transition-colors">
                    <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v12m-3-2.818l.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">입금 관리</div>
                    <div class="text-xs text-gray-500">입금 신청 내역</div>
                </div>
            </a>

            <?php if ($row['grade'] != 'admin') { ?>
            <a href="withdraw.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-red-500/20 hover:to-pink-500/20 transition-all duration-200 border border-transparent hover:border-red-500/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-red-500/10 group-hover:bg-red-500/20 transition-colors">
                    <svg class="w-4 h-4 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">출금 신청</div>
                    <div class="text-xs text-gray-500">가맹점 출금</div>
                </div>
            </a>
            <?php } else { ?>
            <a href="withdraw_manage.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-red-500/20 hover:to-pink-500/20 transition-all duration-200 border border-transparent hover:border-red-500/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-red-500/10 group-hover:bg-red-500/20 transition-colors">
                    <svg class="w-4 h-4 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">출금 관리</div>
                    <div class="text-xs text-gray-500">출금 신청 내역</div>
                </div>
            </a>

            <a href="manual_transaction.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-purple-500/20 hover:to-indigo-500/20 transition-all duration-200 border border-transparent hover:border-purple-500/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-purple-500/10 group-hover:bg-purple-500/20 transition-colors">
                    <svg class="w-4 h-4 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 12l3-3 3 3 4-4M8 21l4-4 4 4M3 4h18M4 4h16v12a1 1 0 01-1 1H5a1 1 0 01-1-1V4z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">수동 거래</div>
                    <div class="text-xs text-gray-500">지급/회수 내역</div>
                </div>
            </a>
            <?php } ?>
        </div>

        <!-- 설정 섹션 (드롭다운) -->
        <?php if ($row['grade'] == 'admin') { ?>
        <div class="mb-6">
            <div class="flex items-center gap-2 px-3 py-2 mb-3">
                <div class="w-1 h-4 bg-gradient-to-b from-cyan-400 to-blue-500 rounded-full"></div>
                <span class="text-xs font-semibold text-gray-400 uppercase tracking-wider">설정</span>
            </div>

            <!-- 설정 드롭다운 토글 버튼 -->
            <button onclick="toggleSettingsDropdown()" 
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-cyan-500/20 hover:to-blue-500/20 transition-all duration-200 border border-transparent hover:border-cyan-500/30 w-full">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-cyan-500/10 group-hover:bg-cyan-500/20 transition-colors">
                    <svg class="w-4 h-4 text-cyan-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                </div>
                <div class="flex-1 text-left">
                    <div class="font-medium">설정</div>
                    <div class="text-xs text-gray-500">시스템 설정</div>
                </div>
                <svg id="settingsArrow" class="w-4 h-4 text-gray-400 transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                </svg>
            </button>

            <!-- 드롭다운 메뉴 -->
            <div id="settingsDropdown" class="hidden mt-2 ml-4 space-y-1">
                <a href="withdraw_time_manage.php"
                    class="group flex items-center gap-3 py-2 px-4 rounded-lg text-gray-400 hover:text-white hover:bg-gradient-to-r hover:from-orange-500/20 hover:to-amber-500/20 transition-all duration-200 border border-transparent hover:border-orange-500/30">
                    <div class="flex items-center justify-center w-6 h-6 rounded-md bg-orange-500/10 group-hover:bg-orange-500/20 transition-colors">
                        <svg class="w-3 h-3 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div class="flex-1">
                        <div class="text-sm font-medium">출금시간 관리</div>
                        <div class="text-xs text-gray-500">출금 가능 시간 설정</div>
                    </div>
                </a>

                <a href="sound_settings.php"
                    class="group flex items-center gap-3 py-2 px-4 rounded-lg text-gray-400 hover:text-white hover:bg-gradient-to-r hover:from-orange-500/20 hover:to-amber-500/20 transition-all duration-200 border border-transparent hover:border-orange-500/30">
                    <div class="flex items-center justify-center w-6 h-6 rounded-md bg-orange-500/10 group-hover:bg-orange-500/20 transition-colors">
                        <svg class="w-3 h-3 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.536 8.464a5 5 0 010 7.072m2.828-9.9a9 9 0 010 12.728M5.586 15H4a1 1 0 01-1-1v-4a1 1 0 011-1h1.586l4.707-4.707C10.923 3.663 12 4.109 12 5v14c0 .891-1.077 1.337-1.707.707L5.586 15z"></path>
                        </svg>
                    </div>
                    <div class="flex-1">
                        <div class="text-sm font-medium">사운드 설정</div>
                        <div class="text-xs text-gray-500">알림음 및 효과음 관리</div>
                    </div>
                </a>

                <a href="site_settings.php"
                    class="group flex items-center gap-3 py-2 px-4 rounded-lg text-gray-400 hover:text-white hover:bg-gradient-to-r hover:from-orange-500/20 hover:to-amber-500/20 transition-all duration-200 border border-transparent hover:border-orange-500/30">
                    <div class="flex items-center justify-center w-6 h-6 rounded-md bg-orange-500/10 group-hover:bg-orange-500/20 transition-colors">
                        <svg class="w-3 h-3 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                    </div>
                    <div class="flex-1">
                        <div class="text-sm font-medium">사이트 점검 설정</div>
                        <div class="text-xs text-gray-500">점검 관리</div>
                    </div>
                </a>

                <a href="auto_approval_settings.php"
                    class="group flex items-center gap-3 py-2 px-4 rounded-lg text-gray-400 hover:text-white hover:bg-gradient-to-r hover:from-orange-500/20 hover:to-amber-500/20 transition-all duration-200 border border-transparent hover:border-orange-500/30">
                    <div class="flex items-center justify-center w-6 h-6 rounded-md bg-orange-500/10 group-hover:bg-orange-500/20 transition-colors">
                        <svg class="w-3 h-3 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div class="flex-1">
                        <div class="text-sm font-medium">자동 승인 설정</div>
                        <div class="text-xs text-gray-500">승인 관리</div>
                    </div>
                </a>
            </div>
        </div>
        <?php } ?>

        <!-- 관리자 전용 섹션 -->
        <?php if ($row['grade'] == 'admin') { ?>
        <div class="mb-6">
            <div class="flex items-center gap-2 px-3 py-2 mb-3">
                <div class="w-1 h-4 bg-gradient-to-b from-orange-400 to-red-500 rounded-full"></div>
                <span class="text-xs font-semibold text-gray-400 uppercase tracking-wider">시스템 관리</span>
            </div>

            <a href="history.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-indigo-500/20 hover:to-purple-500/20 transition-all duration-200 border border-transparent hover:border-indigo-500/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-indigo-500/10 group-hover:bg-indigo-500/20 transition-colors">
                    <svg class="w-4 h-4 text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">통계</div>
                    <div class="text-xs text-gray-500">데이터 분석</div>
                </div>
            </a>

            <a href="log_list.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-slate-500/20 hover:to-gray-500/20 transition-all duration-200 border border-transparent hover:border-slate-500/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-slate-500/10 group-hover:bg-slate-500/20 transition-colors">
                    <svg class="w-4 h-4 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">로그</div>
                    <div class="text-xs text-gray-500">시스템 로그</div>
                </div>
            </a>

            <a href="ip_blacklist.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-red-600/20 hover:to-red-700/20 transition-all duration-200 border border-transparent hover:border-red-600/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-red-600/10 group-hover:bg-red-600/20 transition-colors">
                    <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">IP 관리</div>
                    <div class="text-xs text-gray-500">접근 제어</div>
                </div>
            </a>
        </div>
        <?php } ?>


        <div class="mb-6">
            <div class="flex items-center gap-2 px-3 py-2 mb-3">
                <div class="w-1 h-4 bg-gradient-to-b from-orange-400 to-red-500 rounded-full"></div>
                <span class="text-xs font-semibold text-gray-400 uppercase tracking-wider">API 지원</span>
            </div>

            <a href="api_docs.php"
                class="group flex items-center gap-3 py-3 px-4 rounded-xl text-gray-300 hover:text-white hover:bg-gradient-to-r hover:from-emerald-500/20 hover:to-teal-500/20 transition-all duration-200 border border-transparent hover:border-emerald-500/30">
                <div class="flex items-center justify-center w-8 h-8 rounded-lg bg-emerald-500/10 group-hover:bg-emerald-500/20 transition-colors">
                    <svg class="w-4 h-4 text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="font-medium">API 문서</div>
                    <div class="text-xs text-gray-500">개발자 가이드</div>
                </div>
            </a>
        </div>
    </nav>

    <!-- 사이드바 푸터 -->
    <div class="absolute bottom-0 left-0 right-0 p-4 border-t border-gray-700/30">
        <div class="text-center">
            <p class="text-xs text-gray-500">© 2024 올인원 페이</p>
        </div>
    </div>
</aside>

<script>
// 설정 드롭다운 토글 함수
function toggleSettingsDropdown() {
    const dropdown = document.getElementById('settingsDropdown');
    const arrow = document.getElementById('settingsArrow');
    
    if (dropdown.classList.contains('hidden')) {
        dropdown.classList.remove('hidden');
        arrow.style.transform = 'rotate(180deg)';
    } else {
        dropdown.classList.add('hidden');
        arrow.style.transform = 'rotate(0deg)';
    }
}

// 페이지 로드 시 현재 페이지가 드롭다운 메뉴에 있으면 자동으로 열기
document.addEventListener('DOMContentLoaded', function() {
    const currentPage = window.location.pathname.split('/').pop();
    const dropdownPages = ['withdraw_time_manage.php']; // 드롭다운에 포함된 페이지들
    
    if (dropdownPages.includes(currentPage)) {
        toggleSettingsDropdown();
    }
});
</script>