<?php
include 'layout/header.php';

// 날짜 기본값 설정 (어제~오늘)
$defaultStartDate = date('Y-m-d', strtotime('-1 day'));
$defaultEndDate = date('Y-m-d');

// GET 파라미터에서 날짜 가져오기, 없으면 기본값 사용
$startDate = $_GET['start_date'] ?? '';
$endDate = $_GET['end_date'] ?? '';

// 둘 다 비어있으면 기본값 적용
if (empty($startDate) && empty($endDate)) {
    $startDate = $defaultStartDate;
    $endDate = $defaultEndDate;
}
?>

<!-- 모바일 메뉴 열기 버튼 (상단에 배치 필요) -->
<button class="md:hidden fixed top-4 left-4 z-40 bg-primary text-white p-2 rounded-full shadow-lg"
    onclick="toggleSidebar()">
    ☰
</button>

<main class="flex-1 p-8 space-y-8">
    <h2 class="text-3xl font-bold text-primary mb-6">시스템 로그</h2>

    <!-- 검색 필터 -->
    <div class="bg-white/5 border border-white/10 rounded-xl overflow-hidden shadow mb-6">
        <div class="p-4">
            <form method="GET" class="flex flex-wrap gap-4 items-end">
                <div class="flex-1 min-w-[200px]">
                    <label class="block text-sm text-gray-400 mb-1">검색어</label>
                    <input type="text" name="search" placeholder="사용자ID, 타입, 상세내용 검색"
                        value="<?php echo htmlspecialchars($_GET['search'] ?? ''); ?>"
                        class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
                </div>

                <div class="flex-1 min-w-[150px]">
                    <label class="block text-sm text-gray-400 mb-1">로그 타입</label>
                    <select name="type_filter"
                        class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
                        <option value="">전체 타입</option>
                        <optgroup label="입출금 관련">
                            <option value="DEPOSIT_STATUS_CHANGE" <?php echo ($_GET['type_filter'] ?? '') == 'DEPOSIT_STATUS_CHANGE' ? 'selected' : ''; ?>>입금상태변경</option>
                            <option value="WITHDRAWAL_STATUS_CHANGE" <?php echo ($_GET['type_filter'] ?? '') == 'WITHDRAWAL_STATUS_CHANGE' ? 'selected' : ''; ?>>출금상태변경</option>
                            <option value="DEPOSIT_BALANCE_ADD" <?php echo ($_GET['type_filter'] ?? '') == 'DEPOSIT_BALANCE_ADD' ? 'selected' : ''; ?>>입금잔액추가</option>
                            <option value="DEPOSIT_BALANCE_SUBTRACT" <?php echo ($_GET['type_filter'] ?? '') == 'DEPOSIT_BALANCE_SUBTRACT' ? 'selected' : ''; ?>>입금잔액차감</option>
                            <option value="WITHDRAWAL_BALANCE_SUBTRACT" <?php echo ($_GET['type_filter'] ?? '') == 'WITHDRAWAL_BALANCE_SUBTRACT' ? 'selected' : ''; ?>>출금잔액차감</option>
                            <option value="DEPOSIT_AMOUNT_UPDATE" <?php echo ($_GET['type_filter'] ?? '') == 'DEPOSIT_AMOUNT_UPDATE' ? 'selected' : ''; ?>>입금금액수정</option>
                            <option value="DEPOSIT_APPROVED" <?php echo ($_GET['type_filter'] ?? '') == 'DEPOSIT_APPROVED' ? 'selected' : ''; ?>>입금승인</option>
                            <option value="DEPOSIT_CANCELLED" <?php echo ($_GET['type_filter'] ?? '') == 'DEPOSIT_CANCELLED' ? 'selected' : ''; ?>>입금취소</option>
                            <option value="manual_deposit" <?php echo ($_GET['type_filter'] ?? '') == 'manual_deposit' ? 'selected' : ''; ?>>수동입금</option>
                            <option value="manual_withdraw" <?php echo ($_GET['type_filter'] ?? '') == 'manual_withdraw' ? 'selected' : ''; ?>>수동출금</option>
                        </optgroup>
                        <optgroup label="계좌 관리">
                            <option value="bank_account_add" <?php echo ($_GET['type_filter'] ?? '') == 'bank_account_add' ? 'selected' : ''; ?>>은행계좌추가</option>
                            <option value="bank_account_update" <?php echo ($_GET['type_filter'] ?? '') == 'bank_account_update' ? 'selected' : ''; ?>>은행계좌수정</option>
                            <option value="bank_account_delete" <?php echo ($_GET['type_filter'] ?? '') == 'bank_account_delete' ? 'selected' : ''; ?>>은행계좌삭제</option>
                            <option value="BANK_ACCOUNT_ADD_SUCCESS" <?php echo ($_GET['type_filter'] ?? '') == 'BANK_ACCOUNT_ADD_SUCCESS' ? 'selected' : ''; ?>>은행계좌추가성공</option>
                            <option value="BANK_ACCOUNT_ADD_FAILED" <?php echo ($_GET['type_filter'] ?? '') == 'BANK_ACCOUNT_ADD_FAILED' ? 'selected' : ''; ?>>은행계좌추가실패</option>
                            <option value="BANK_ACCOUNT_DELETE_SUCCESS" <?php echo ($_GET['type_filter'] ?? '') == 'BANK_ACCOUNT_DELETE_SUCCESS' ? 'selected' : ''; ?>>은행계좌삭제성공</option>
                        </optgroup>
                        <optgroup label="카카오 계좌 관리">
                            <option value="kakao_account_add" <?php echo ($_GET['type_filter'] ?? '') == 'kakao_account_add' ? 'selected' : ''; ?>>카카오계좌추가</option>
                            <option value="kakao_account_update" <?php echo ($_GET['type_filter'] ?? '') == 'kakao_account_update' ? 'selected' : ''; ?>>카카오계좌수정</option>
                            <option value="kakao_account_delete" <?php echo ($_GET['type_filter'] ?? '') == 'kakao_account_delete' ? 'selected' : ''; ?>>카카오계좌삭제</option>
                            <option value="KAKAO_ACCOUNT_ADD_SUCCESS" <?php echo ($_GET['type_filter'] ?? '') == 'KAKAO_ACCOUNT_ADD_SUCCESS' ? 'selected' : ''; ?>>카카오계좌추가성공</option>
                            <option value="KAKAO_ACCOUNT_ADD_FAILED" <?php echo ($_GET['type_filter'] ?? '') == 'KAKAO_ACCOUNT_ADD_FAILED' ? 'selected' : ''; ?>>카카오계좌추가실패</option>
                            <option value="KAKAO_ACCOUNT_DELETE_SUCCESS" <?php echo ($_GET['type_filter'] ?? '') == 'KAKAO_ACCOUNT_DELETE_SUCCESS' ? 'selected' : ''; ?>>카카오계좌삭제성공</option>
                            <option value="KAKAO_ACCOUNT_UPDATE_SUCCESS" <?php echo ($_GET['type_filter'] ?? '') == 'KAKAO_ACCOUNT_UPDATE_SUCCESS' ? 'selected' : ''; ?>>카카오계좌수정성공</option>
                        </optgroup>
                        <optgroup label="회원 관리">
                            <option value="MEMBER_CREATE_SUCCESS" <?php echo ($_GET['type_filter'] ?? '') == 'MEMBER_CREATE_SUCCESS' ? 'selected' : ''; ?>>회원생성성공</option>
                            <option value="MEMBER_UPDATE_SUCCESS" <?php echo ($_GET['type_filter'] ?? '') == 'MEMBER_UPDATE_SUCCESS' ? 'selected' : ''; ?>>회원수정성공</option>
                            <option value="MEMBER_UPDATE_NO_CHANGE" <?php echo ($_GET['type_filter'] ?? '') == 'MEMBER_UPDATE_NO_CHANGE' ? 'selected' : ''; ?>>회원수정변경없음</option>
                        </optgroup>
                        <optgroup label="정산 및 통계">
                            <option value="DAILY_SETTLEMENT" <?php echo ($_GET['type_filter'] ?? '') == 'DAILY_SETTLEMENT' ? 'selected' : ''; ?>>일일정산</option>
                            <option value="HISTORY_STATS_UPDATE" <?php echo ($_GET['type_filter'] ?? '') == 'HISTORY_STATS_UPDATE' ? 'selected' : ''; ?>>통계업데이트</option>
                            <option value="MULTI_LEVEL_ROLLING" <?php echo ($_GET['type_filter'] ?? '') == 'MULTI_LEVEL_ROLLING' ? 'selected' : ''; ?>>다단계롤링</option>
                        </optgroup>
                        <optgroup label="오류 및 기타">
                            <option value="DEPOSIT_PROCESS_ERROR" <?php echo ($_GET['type_filter'] ?? '') == 'DEPOSIT_PROCESS_ERROR' ? 'selected' : ''; ?>>입금처리오류</option>
                            <option value="WITHDRAWAL_PROCESS_ERROR" <?php echo ($_GET['type_filter'] ?? '') == 'WITHDRAWAL_PROCESS_ERROR' ? 'selected' : ''; ?>>출금처리오류</option>
                            <option value="MANUAL_TRANSACTION_ERROR" <?php echo ($_GET['type_filter'] ?? '') == 'MANUAL_TRANSACTION_ERROR' ? 'selected' : ''; ?>>수동거래오류</option>
                            <option value="manual_transaction_failed" <?php echo ($_GET['type_filter'] ?? '') == 'manual_transaction_failed' ? 'selected' : ''; ?>>수동거래실패</option>
                            <option value="AUTO_CANCEL_DEPOSIT" <?php echo ($_GET['type_filter'] ?? '') == 'AUTO_CANCEL_DEPOSIT' ? 'selected' : ''; ?>>자동입금취소</option>
                            <option value="AUTO_CANCEL_BATCH" <?php echo ($_GET['type_filter'] ?? '') == 'AUTO_CANCEL_BATCH' ? 'selected' : ''; ?>>자동취소배치</option>
                            <option value="CALLBACK_EXECUTED" <?php echo ($_GET['type_filter'] ?? '') == 'CALLBACK_EXECUTED' ? 'selected' : ''; ?>>콜백실행</option>
                        </optgroup>
                    </select>
                </div>

                <div class="flex-1 min-w-[150px]">
                    <label class="block text-sm text-gray-400 mb-1">시작 날짜</label>
                    <input type="date" name="start_date" id="start_date" value="<?php echo htmlspecialchars($startDate); ?>"
                        class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
                </div>

                <div class="flex-1 min-w-[150px]">
                    <label class="block text-sm text-gray-400 mb-1">종료 날짜</label>
                    <input type="date" name="end_date" id="end_date" value="<?php echo htmlspecialchars($endDate); ?>"
                        class="w-full px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary">
                </div>

                <button type="submit" class="px-6 py-2 bg-primary text-white rounded hover:bg-teal-600 transition">
                    검색
                </button>

                <button type="button" onclick="resetForm()" class="px-6 py-2 bg-gray-700 text-white rounded hover:bg-gray-600 transition">
                    초기화
                </button>
            </form>
        </div>
    </div>

    <!-- 로그 리스트 테이블 -->
    <div class="bg-white/5 border border-white/10 rounded-xl overflow-hidden shadow">
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm text-left">
                <thead class="bg-gray-800 text-gray-300">
                    <tr>
                        <th class="px-4 py-3 border-b border-white/10 text-center">#</th>
                        <th class="px-4 py-3 border-b border-white/10">처리자</th>
                        <th class="px-4 py-3 border-b border-white/10">IP 주소</th>
                        <th class="px-4 py-3 border-b border-white/10">타입</th>
                        <th class="px-4 py-3 border-b border-white/10">상태</th>
                        <th class="px-4 py-3 border-b border-white/10">상세내용</th>
                        <th class="px-4 py-3 border-b border-white/10">일시</th>
                        <th class="px-4 py-3 border-b border-white/10 text-center">액션</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/10" id="logTableBody">
                    <!-- 동적으로 데이터가 로드됩니다 -->
                </tbody>
            </table>
        </div>
        
        <!-- 로딩 표시 -->
        <div id="loadingIndicator" class="hidden p-8 text-center text-gray-400">
            <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-primary"></div>
            <p class="mt-2">데이터를 불러오는 중...</p>
        </div>
    </div>

    <!-- 페이지네이션 -->
    <div class="flex justify-center space-x-2 text-sm mt-4" id="pagination">
        <!-- 동적으로 생성됩니다 -->
    </div>
</main>

<!-- 상세 보기 모달 -->
<div id="detailModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-gray-900 rounded-xl p-6 max-w-4xl w-full max-h-[90vh] overflow-y-auto border border-white/10">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-xl font-bold text-white">로그 상세 정보</h3>
                <button onclick="closeDetailModal()" class="text-gray-400 hover:text-white">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
            <div id="modalContent" class="space-y-4 text-gray-300">
                <!-- 상세 내용이 여기에 표시됩니다 -->
            </div>
        </div>
    </div>
</div>

<script>
    // 날짜 포맷 함수
    function formatDate(date) {
        const year = date.getFullYear();
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const day = String(date.getDate()).padStart(2, '0');
        return `${year}-${month}-${day}`;
    }

    // 기본 날짜 가져오기
    function getDefaultDates() {
        const today = new Date();
        const yesterday = new Date(today);
        yesterday.setDate(yesterday.getDate() - 1);
        
        return {
            startDate: formatDate(yesterday),
            endDate: formatDate(today)
        };
    }

    // 폼 초기화
    function resetForm() {
        const defaults = getDefaultDates();
        
        document.querySelector('input[name="search"]').value = '';
        document.querySelector('select[name="type_filter"]').value = '';
        document.getElementById('start_date').value = defaults.startDate;
        document.getElementById('end_date').value = defaults.endDate;
        
        // 초기화 후 바로 검색
        fetchLogs();
    }

    // 페이지 로드 시 로그 목록 가져오기
    document.addEventListener('DOMContentLoaded', function () {
        // 날짜가 비어있으면 기본값 설정
        const startInput = document.getElementById('start_date');
        const endInput = document.getElementById('end_date');
        
        if (!startInput.value && !endInput.value) {
            const defaults = getDefaultDates();
            startInput.value = defaults.startDate;
            endInput.value = defaults.endDate;
        }
        
        fetchLogs();
    });

    // 로그 목록 가져오기
    function fetchLogs() {
        const loadingIndicator = document.getElementById('loadingIndicator');
        const tbody = document.getElementById('logTableBody');
        
        // 로딩 표시
        tbody.innerHTML = '';
        loadingIndicator.classList.remove('hidden');
        
        const urlParams = new URLSearchParams(window.location.search);
        
        // 날짜가 URL에 없으면 폼에서 가져오기
        if (!urlParams.has('start_date') || !urlParams.has('end_date')) {
            const startDate = document.getElementById('start_date').value;
            const endDate = document.getElementById('end_date').value;
            if (startDate) urlParams.set('start_date', startDate);
            if (endDate) urlParams.set('end_date', endDate);
        }
        
        const params = urlParams.toString();

        fetch(`/ajax/fetch_logs.php?${params}`)
            .then(res => res.text())
            .then(text => {
                // PHP 경고 제거
                const jsonStart = text.indexOf('{');
                if (jsonStart !== -1) {
                    text = text.substring(jsonStart);
                }

                try {
                    const data = JSON.parse(text);
                    loadingIndicator.classList.add('hidden');
                    
                    if (data.success) {
                        displayLogs(data.logs);
                        updatePagination(data.totalPages, data.currentPage);
                    } else {
                        console.error('데이터 조회 실패:', data.message);
                        tbody.innerHTML =
                            '<tr><td colspan="8" class="px-4 py-8 text-center text-gray-400">데이터 조회에 실패했습니다.</td></tr>';
                    }
                } catch (e) {
                    console.error('JSON 파싱 에러:', e);
                    console.error('원본 응답:', text);
                    loadingIndicator.classList.add('hidden');
                }
            })
            .catch(err => {
                console.error('요청 실패:', err);
                loadingIndicator.classList.add('hidden');
                tbody.innerHTML =
                    '<tr><td colspan="8" class="px-4 py-8 text-center text-gray-400">서버 연결에 실패했습니다.</td></tr>';
            });
    }

    // 로그 타입에 따른 한글명 반환
    function getTypeLabel(type) {
        const typeLabels = {
            // 입출금 관련
            'DEPOSIT_STATUS_CHANGE': '입금상태변경',
            'WITHDRAWAL_STATUS_CHANGE': '출금상태변경',
            'DEPOSIT_BALANCE_ADD': '입금잔액추가',
            'DEPOSIT_BALANCE_SUBTRACT': '입금잔액차감',
            'WITHDRAWAL_BALANCE_SUBTRACT': '출금잔액차감',
            'DEPOSIT_AMOUNT_UPDATE': '입금금액수정',
            'DEPOSIT_APPROVED': '입금승인',
            'DEPOSIT_CANCELLED': '입금취소',
            'manual_deposit': '수동입금',
            'manual_withdraw': '수동출금',
            
            // 계좌 관리
            'bank_account_add': '은행계좌추가',
            'bank_account_update': '은행계좌수정',
            'bank_account_delete': '은행계좌삭제',
            'BANK_ACCOUNT_ADD_SUCCESS': '은행계좌추가성공',
            'BANK_ACCOUNT_ADD_FAILED': '은행계좌추가실패',
            'BANK_ACCOUNT_DELETE_SUCCESS': '은행계좌삭제성공',
            
            // 카카오 계좌 관리
            'kakao_account_add': '카카오계좌추가',
            'kakao_account_update': '카카오계좌수정',
            'kakao_account_delete': '카카오계좌삭제',
            'KAKAO_ACCOUNT_ADD_SUCCESS': '카카오계좌추가성공',
            'KAKAO_ACCOUNT_ADD_FAILED': '카카오계좌추가실패',
            'KAKAO_ACCOUNT_DELETE_SUCCESS': '카카오계좌삭제성공',
            'KAKAO_ACCOUNT_UPDATE_SUCCESS': '카카오계좌수정성공',
            
            // 회원 관리
            'MEMBER_CREATE_SUCCESS': '회원생성성공',
            'MEMBER_UPDATE_SUCCESS': '회원수정성공',
            'MEMBER_UPDATE_NO_CHANGE': '회원수정변경없음',
            
            // 정산 및 통계
            'DAILY_SETTLEMENT': '일일정산',
            'HISTORY_STATS_UPDATE': '통계업데이트',
            'MULTI_LEVEL_ROLLING': '다단계롤링',
            
            // 오류 및 기타
            'DEPOSIT_PROCESS_ERROR': '입금처리오류',
            'WITHDRAWAL_PROCESS_ERROR': '출금처리오류',
            'MANUAL_TRANSACTION_ERROR': '수동거래오류',
            'manual_transaction_failed': '수동거래실패',
            'AUTO_CANCEL_DEPOSIT': '자동입금취소',
            'AUTO_CANCEL_BATCH': '자동취소배치',
            'CALLBACK_EXECUTED': '콜백실행'
        };
        
        return typeLabels[type] || type;
    }

    // 로그 목록 표시 함수 수정
    function displayLogs(logs) {
        const tbody = document.getElementById('logTableBody');
        tbody.innerHTML = '';

        if (logs.length === 0) {
            tbody.innerHTML = '<tr><td colspan="8" class="px-4 py-8 text-center text-gray-400">조회된 로그가 없습니다.</td></tr>';
            return;
        }

        logs.forEach((log, index) => {
            const row = document.createElement('tr');
            row.className = 'hover:bg-white/5 transition';

            // 타입별 색상
            const typeColor = getTypeColor(log.type);

            // 상태별 표시
            const statusBadge = getStatusBadge(log.status);

            // 상세내용 미리보기 (50자)
            const detailPreview = truncateText(log.detail, 50);
            const hasLongDetail = log.detail && log.detail.length > 50;

            // 처리자 정보 표시
            const processorInfo = log.processor_name 
                ? `${log.processor_user_id} (${log.processor_name})`
                : (log.processor_user_id || '-');

            // 레벨 뱃지 추가
            const levelBadge = getLevelBadge(log.processor_level);

            // 타입 한글명 가져오기
            const typeLabel = getTypeLabel(log.type);

            row.innerHTML = `
                <td class="px-4 py-2 text-center text-gray-500">${log.display_id || log.id}</td>
                <td class="px-4 py-2">
                    <div class="text-gray-300 text-sm">
                        ${escapeHtml(processorInfo)}
                        ${levelBadge}
                    </div>
                </td>
                <td class="px-4 py-2">
                    <span class="text-xs text-gray-400 font-mono">
                        ${escapeHtml(log.ip_address || '-')}
                    </span>
                </td>
                <td class="px-4 py-2">
                    <span class="px-2 py-1 text-xs rounded ${typeColor}" title="${escapeHtml(log.type)}">
                        ${escapeHtml(typeLabel)}
                    </span>
                </td>
                <td class="px-4 py-2">${statusBadge}</td>
                <td class="px-4 py-2">
                    <div class="text-gray-300">
                        ${escapeHtml(detailPreview || '-')}
                        ${hasLongDetail ? '<span class="text-primary">...</span>' : ''}
                    </div>
                </td>
                <td class="px-4 py-2 text-gray-400 text-xs">${log.created_at || '-'}</td>
                <td class="px-4 py-2 text-center">
                    <button onclick='showDetailModal(${JSON.stringify(log).replace(/'/g, "&apos;")})' 
                        class="px-3 py-1 text-xs bg-blue-600 hover:bg-blue-700 text-white rounded">
                        상세보기
                    </button>
                </td>
            `;
            tbody.appendChild(row);
        });
    }

    // 레벨 뱃지 함수 추가
    function getLevelBadge(level) {
        if (!level) return '';
        
        const levelColors = {
            'admin': 'bg-red-600 text-white',
            'manager': 'bg-orange-600 text-white',
            'user': 'bg-blue-600 text-white',
            'guest': 'bg-gray-600 text-white'
        };
        
        const color = levelColors[level] || 'bg-gray-600 text-white';
        return `<span class="ml-1 px-1 py-0.5 text-xs rounded ${color}">${level}</span>`;
    }

    // 상세 모달 표시
    function showDetailModal(log) {
        // JSON 파싱된 데이터 처리
        let oldData = '';
        let newData = '';
        
        try {
            if (log.old_data) {
                const parsed = JSON.parse(log.old_data);
                oldData = JSON.stringify(parsed, null, 2);
            }
        } catch (e) {
            oldData = log.old_data || '-';
        }
        
        try {
            if (log.new_data) {
                const parsed = JSON.parse(log.new_data);
                newData = JSON.stringify(parsed, null, 2);
            }
        } catch (e) {
            newData = log.new_data || '-';
        }

        const typeLabel = getTypeLabel(log.type);

        const content = `
            <div class="grid grid-cols-2 gap-6">
                <div>
                    <label class="text-sm text-gray-500 block mb-1">로그 ID</label>
                    <p class="text-white bg-gray-800 p-2 rounded">${log.id}</p>
                </div>
                <div>
                    <label class="text-sm text-gray-500 block mb-1">처리자</label>
                    <p class="text-white bg-gray-800 p-2 rounded">
                        ${escapeHtml(log.processor_user_id || '-')}
                        ${log.processor_name ? ` (${escapeHtml(log.processor_name)})` : ''}
                        ${getLevelBadge(log.processor_level)}
                    </p>
                </div>
                <div>
                    <label class="text-sm text-gray-500 block mb-1">IP 주소</label>
                    <p class="text-white bg-gray-800 p-2 rounded font-mono text-sm">
                        ${escapeHtml(log.ip_address || '-')}
                    </p>
                </div>
                <div>
                    <label class="text-sm text-gray-500 block mb-1">타입</label>
                    <p class="bg-gray-800 p-2 rounded">
                        <span class="px-2 py-1 text-xs rounded ${getTypeColor(log.type)}">
                            ${escapeHtml(typeLabel)}
                        </span>
                        <span class="text-gray-500 text-xs ml-2">(${escapeHtml(log.type)})</span>
                    </p>
                </div>
                <div>
                    <label class="text-sm text-gray-500 block mb-1">상태</label>
                    <p class="bg-gray-800 p-2 rounded">${getStatusBadge(log.status)}</p>
                </div>
                <div>
                    <label class="text-sm text-gray-500 block mb-1">일시</label>
                    <p class="text-white bg-gray-800 p-2 rounded">${log.created_at || '-'}</p>
                </div>
            </div>
            
            <div class="mt-6">
                <label class="text-sm text-gray-500 block mb-1">상세 내용</label>
                <div class="bg-gray-800 rounded p-4 max-h-40 overflow-y-auto">
                    <pre class="text-sm text-white whitespace-pre-wrap">${escapeHtml(log.detail || '-')}</pre>
                </div>
            </div>
            
            <div class="mt-6">
                <label class="text-sm text-gray-500 block mb-1">이전 데이터</label>
                <div class="bg-gray-800 rounded p-4 max-h-60 overflow-y-auto">
                    <pre class="text-sm text-green-400">${escapeHtml(oldData)}</pre>
                </div>
            </div>
            
            <div class="mt-6">
                <label class="text-sm text-gray-500 block mb-1">변경된 데이터</label>
                <div class="bg-gray-800 rounded p-4 max-h-60 overflow-y-auto">
                    <pre class="text-sm text-yellow-400">${escapeHtml(newData)}</pre>
                </div>
            </div>
        `;

        document.getElementById('modalContent').innerHTML = content;
        document.getElementById('detailModal').classList.remove('hidden');
    }

    // 타입별 색상 반환 (카테고리별로 색상 통일)
    function getTypeColor(type) {
        // 입출금 관련
        if (type.includes('DEPOSIT') || type === 'manual_deposit') {
            return 'bg-green-600 text-white';
        }
        if (type.includes('WITHDRAWAL') || type === 'manual_withdraw') {
            return 'bg-orange-600 text-white';
        }
        
        // 계좌 관리
        if (type.includes('bank_account') || type.includes('BANK_ACCOUNT')) {
            return 'bg-blue-600 text-white';
        }
        if (type.includes('kakao_account') || type.includes('KAKAO_ACCOUNT')) {
            return 'bg-yellow-600 text-white';
        }
        
        // 회원 관리
        if (type.includes('MEMBER')) {
            return 'bg-purple-600 text-white';
        }
        
        // 정산 및 통계
        if (type.includes('SETTLEMENT') || type.includes('STATS') || type.includes('ROLLING')) {
            return 'bg-indigo-600 text-white';
        }
        
        // 오류
        if (type.includes('ERROR') || type.includes('failed')) {
            return 'bg-red-800 text-white';
        }
        
        // 자동 처리
        if (type.includes('AUTO')) {
            return 'bg-teal-600 text-white';
        }
        
        // 기타
        return 'bg-gray-600 text-white';
    }

    // 상태별 뱃지 반환
    function getStatusBadge(status) {
        if (status == 1) {
            return '<span class="px-2 py-1 text-xs bg-green-600 text-white rounded">성공</span>';
        } else if (status == 0) {
            return '<span class="px-2 py-1 text-xs bg-red-600 text-white rounded">실패</span>';
        } else {
            return '<span class="px-2 py-1 text-xs bg-gray-600 text-white rounded">-</span>';
        }
    }

    // 텍스트 자르기
    function truncateText(text, maxLength) {
        if (!text) return '';
        if (text.length <= maxLength) return text;
        return text.substring(0, maxLength);
    }

    // 모달 닫기
    function closeDetailModal() {
        document.getElementById('detailModal').classList.add('hidden');
    }

    // 페이지네이션 업데이트
    function updatePagination(totalPages, currentPage) {
        const pagination = document.getElementById('pagination');
        pagination.innerHTML = '';

        if (totalPages <= 1) return;

        const urlParams = new URLSearchParams(window.location.search);

        // 이전 버튼
        if (currentPage > 1) {
            const prevLink = createPageLink(currentPage - 1, '이전', urlParams);
            prevLink.classList.add('px-3', 'py-1', 'bg-gray-800', 'hover:bg-gray-700', 'rounded');
            pagination.appendChild(prevLink);
        }

        // 페이지 번호
        let startPage = Math.max(1, currentPage - 2);
        let endPage = Math.min(totalPages, startPage + 4);

        if (startPage > 1) {
            const firstLink = createPageLink(1, '1', urlParams);
            firstLink.classList.add('px-3', 'py-1', 'bg-gray-800', 'hover:bg-gray-700', 'rounded');
            pagination.appendChild(firstLink);

            if (startPage > 2) {
                const dots = document.createElement('span');
                dots.textContent = '...';
                dots.classList.add('px-2', 'text-gray-400');
                pagination.appendChild(dots);
            }
        }

        for (let i = startPage; i <= endPage; i++) {
            const pageLink = createPageLink(i, i, urlParams);
            if (i == currentPage) {
                pageLink.classList.add('px-3', 'py-1', 'rounded', 'bg-primary', 'text-white');
            } else {
                pageLink.classList.add('px-3', 'py-1', 'rounded', 'bg-gray-800', 'hover:bg-gray-700');
            }
            pagination.appendChild(pageLink);
        }

        if (endPage < totalPages) {
            if (endPage < totalPages - 1) {
                const dots = document.createElement('span');
                dots.textContent = '...';
                dots.classList.add('px-2', 'text-gray-400');
                pagination.appendChild(dots);
            }

            const lastLink = createPageLink(totalPages, totalPages, urlParams);
            lastLink.classList.add('px-3', 'py-1', 'bg-gray-800', 'hover:bg-gray-700', 'rounded');
            pagination.appendChild(lastLink);
        }

        // 다음 버튼
        if (currentPage < totalPages) {
            const nextLink = createPageLink(currentPage + 1, '다음', urlParams);
            nextLink.classList.add('px-3', 'py-1', 'bg-gray-800', 'hover:bg-gray-700', 'rounded');
            pagination.appendChild(nextLink);
        }
    }

    // 페이지 링크 생성
    function createPageLink(page, text, urlParams) {
        const link = document.createElement('a');
        urlParams.set('page', page);
        link.href = `?${urlParams.toString()}`;
        link.textContent = text;
        return link;
    }

    // HTML 이스케이프
    function escapeHtml(text) {
        if (!text) return '';
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return text.toString().replace(/[&<>"']/g, m => map[m]);
    }

    // ESC 키로 모달 닫기
    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape') {
            closeDetailModal();
        }
    });

    // 모달 외부 클릭시 닫기
    document.getElementById('detailModal').addEventListener('click', function(e) {
        if (e.target === this) {
            closeDetailModal();
        }
    });
</script>

</body>
</html>