<!DOCTYPE html>
<html lang="ko" class="dark">
<head>
    <meta charset="UTF-8">
    <title>관리자 로그인 - Allinone Pay</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        primary: '#00C896',
                    },
                    backdropBlur: {
                        xs: '2px',
                    },
                    animation: {
                        'float': 'float 3s ease-in-out infinite',
                        'pulse-glow': 'pulse-glow 2s ease-in-out infinite alternate',
                        'slide-up': 'slide-up 0.8s cubic-bezier(0.4, 0, 0.2, 1)',
                    }
                }
            }
        }
    </script>
</head>
<body class="min-h-screen relative overflow-hidden">
    <!-- Animated Background -->
    <div class="fixed inset-0 bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900"></div>
    
    <!-- Background Pattern Overlay -->
    <div class="fixed inset-0 opacity-20">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%239C92AC" fill-opacity="0.1"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>
    
    <!-- Floating Geometric Shapes -->
    <div class="fixed inset-0 pointer-events-none overflow-hidden">
        <div class="absolute top-1/4 left-1/4 w-64 h-64 bg-blue-500/10 rounded-full blur-3xl animate-float"></div>
        <div class="absolute top-3/4 right-1/4 w-96 h-96 bg-purple-500/10 rounded-full blur-3xl animate-float" style="animation-delay: -1s;"></div>
        <div class="absolute top-1/2 left-3/4 w-48 h-48 bg-teal-500/10 rounded-full blur-3xl animate-float" style="animation-delay: -2s;"></div>
    </div>
    
    <!-- Particle Effect -->
    <div class="fixed inset-0 pointer-events-none">
        <div class="particles-container">
            <!-- Particles will be generated by JavaScript -->
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="relative z-10 min-h-screen flex items-center justify-center p-6">
        <!-- Login Container -->
        <div class="w-full max-w-md">
            <!-- Logo Section -->
            <div class="text-center mb-8 animate-slide-up">
                <div class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-primary to-emerald-400 rounded-2xl shadow-2xl mb-6 animate-pulse-glow">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                </div>
                <h1 class="text-4xl font-bold text-white mb-2 bg-gradient-to-r from-white to-gray-200 bg-clip-text text-transparent">
                    Allinone Pay
                </h1>
                <p class="text-gray-400">관리자 시스템 접근 인증</p>
            </div>
            
            <!-- Login Form -->
            <div class="bg-white/10 backdrop-blur-xl border border-white/20 rounded-3xl p-8 shadow-2xl animate-slide-up" style="animation-delay: 0.2s;">
                <!-- Status Message -->
                <div id="statusMessage" class="hidden mb-6 p-4 rounded-xl text-sm font-medium"></div>
                
                <form id="loginForm" action="login_insert.php" method="POST" class="space-y-6" autocomplete="off">
                    <!-- Username Field -->
                    <div class="space-y-2">
                        <label for="username" class="block text-sm font-semibold text-gray-200 mb-2">
                            <svg class="inline w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            아이디
                        </label>
                        <div class="relative group">
                            <input type="text" 
                                   id="username" 
                                   name="username" 
                                   required 
                                   autocomplete="off"
                                   class="w-full px-4 py-4 bg-gray-800/50 backdrop-blur border border-gray-600/50 rounded-2xl text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary/50 focus:border-primary/50 transition-all duration-300 group-hover:border-gray-500/70"
                                   placeholder="관리자 아이디를 입력하세요">
                            <div class="absolute inset-0 bg-gradient-to-r from-primary/0 via-primary/5 to-primary/0 rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-300 pointer-events-none"></div>
                        </div>
                    </div>
                    
                    <!-- Password Field -->
                    <div class="space-y-2">
                        <label for="password" class="block text-sm font-semibold text-gray-200 mb-2">
                            <svg class="inline w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                            </svg>
                            비밀번호
                        </label>
                        <div class="relative group">
                            <input type="password" 
                                   id="password" 
                                   name="password" 
                                   required 
                                   autocomplete="off"
                                   class="w-full px-4 py-4 bg-gray-800/50 backdrop-blur border border-gray-600/50 rounded-2xl text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary/50 focus:border-primary/50 transition-all duration-300 group-hover:border-gray-500/70"
                                   placeholder="비밀번호를 입력하세요">
                            <div class="absolute inset-0 bg-gradient-to-r from-primary/0 via-primary/5 to-primary/0 rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-300 pointer-events-none"></div>
                            <button type="button" 
                                    id="togglePassword"
                                    class="absolute right-4 top-1/2 transform -translate-y-1/2 text-gray-400 hover:text-white transition-colors duration-200">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Login Button -->
                    <button type="submit" 
                            id="loginButton"
                            class="w-full py-4 px-6 bg-gradient-to-r from-primary to-emerald-400 hover:from-emerald-400 hover:to-primary text-white font-bold rounded-2xl shadow-lg hover:shadow-xl transform hover:scale-[1.02] active:scale-[0.98] transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-primary/50 focus:ring-offset-2 focus:ring-offset-transparent">
                        <span class="flex items-center justify-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                            </svg>
                            <span id="loginText">관리자 로그인</span>
                        </span>
                    </button>
                </form>
                
                <!-- Security Notice -->
                <div class="mt-6 p-4 bg-blue-500/10 border border-blue-500/20 rounded-2xl">
                    <div class="flex items-center text-blue-200 text-sm">
                        <svg class="w-4 h-4 mr-2 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                        </svg>
                        <span>보안 연결로 안전하게 보호됩니다</span>
                    </div>
                </div>
            </div>
            
            <!-- Footer -->
            <div class="text-center mt-8 animate-slide-up" style="animation-delay: 0.4s;">
                <p class="text-gray-500 text-sm">
                    © 2025 Allinone Pay. All rights reserved.
                </p>
                <div class="flex justify-center space-x-4 mt-4 text-xs text-gray-600">
                    <span>보안</span>
                    <span>•</span>
                    <span>프라이버시</span>
                    <span>•</span>
                    <span>지원</span>
                </div>
            </div>
        </div>
    </div>

    <style>
        /* Custom Animations */
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }
        
        @keyframes pulse-glow {
            0% { box-shadow: 0 0 20px rgba(0, 200, 150, 0.3); }
            100% { box-shadow: 0 0 30px rgba(0, 200, 150, 0.6), 0 0 60px rgba(0, 200, 150, 0.2); }
        }
        
        @keyframes slide-up {
            from { 
                opacity: 0; 
                transform: translateY(30px); 
            }
            to { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        
        @keyframes particle-move {
            0% {
                transform: translateY(100vh) translateX(0px);
                opacity: 0;
            }
            10% { opacity: 1; }
            90% { opacity: 1; }
            100% {
                transform: translateY(-100px) translateX(100px);
                opacity: 0;
            }
        }
        
        .animate-float { animation: float 3s ease-in-out infinite; }
        .animate-pulse-glow { animation: pulse-glow 2s ease-in-out infinite alternate; }
        .animate-slide-up { animation: slide-up 0.8s cubic-bezier(0.4, 0, 0.2, 1) forwards; opacity: 0; }
        
        /* Particle Styles */
        .particle {
            position: absolute;
            width: 4px;
            height: 4px;
            background: rgba(0, 200, 150, 0.6);
            border-radius: 50%;
            animation: particle-move linear infinite;
        }
        
        /* Loading Animation */
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 2px solid transparent;
            border-top: 2px solid currentColor;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>

    <script>
        // Particle System
        function createParticle() {
            const particle = document.createElement('div');
            particle.className = 'particle';
            particle.style.left = Math.random() * window.innerWidth + 'px';
            particle.style.animationDuration = (Math.random() * 3 + 2) + 's';
            particle.style.animationDelay = Math.random() * 2 + 's';
            
            document.querySelector('.particles-container').appendChild(particle);
            
            setTimeout(() => {
                particle.remove();
            }, 5000);
        }
        
        // Create particles periodically
        setInterval(createParticle, 300);
        
        // Password toggle functionality
        document.getElementById('togglePassword').addEventListener('click', function() {
            const passwordInput = document.getElementById('password');
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            
            // Change icon
            this.innerHTML = type === 'password' 
                ? `<svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                     <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                     <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                   </svg>`
                : `<svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                     <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21"></path>
                   </svg>`;
        });
        
        // Form submission with loading state
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const button = document.getElementById('loginButton');
            const buttonText = document.getElementById('loginText');
            
            // Add loading state
            button.disabled = true;
            button.classList.add('opacity-75');
            buttonText.innerHTML = '<div class="loading mr-2"></div>로그인 중...';
        });
        
        // Input focus effects
        document.querySelectorAll('input').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.classList.add('ring-2', 'ring-primary/30');
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.classList.remove('ring-2', 'ring-primary/30');
            });
        });
        
        // Keyboard shortcuts
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Enter' && (e.ctrlKey || e.metaKey)) {
                document.getElementById('loginForm').submit();
            }
        });
        
        // Status message function
        function showStatusMessage(message, type = 'error') {
            const statusEl = document.getElementById('statusMessage');
            statusEl.className = `mb-6 p-4 rounded-xl text-sm font-medium ${type === 'success' ? 'bg-green-500/20 border border-green-500/30 text-green-200' : 'bg-red-500/20 border border-red-500/30 text-red-200'}`;
            statusEl.textContent = message;
            statusEl.classList.remove('hidden');
            
            setTimeout(() => {
                statusEl.classList.add('hidden');
            }, 5000);
        }
        
        // Check for URL parameters (login errors, etc.)
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.get('error')) {
            showStatusMessage('로그인에 실패했습니다. 아이디와 비밀번호를 확인해주세요.', 'error');
        }
        
        // Auto-focus first input
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('username').focus();
        });
    </script>
</body>
</html>