<?php
include "inc/db_connect.php";

// IP 주소 가져오기 함수
function get_client_ip() { 
    $ipaddress = '';
    if (getenv('HTTP_CLIENT_IP'))
        $ipaddress = getenv('HTTP_CLIENT_IP');
    else if (getenv('HTTP_X_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
    else if (getenv('HTTP_X_FORWARDED'))
        $ipaddress = getenv('HTTP_X_FORWARDED');
    else if (getenv('HTTP_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_FORWARDED_FOR');
    else if (getenv('HTTP_FORWARDED'))
        $ipaddress = getenv('HTTP_FORWARDED');
    else if (getenv('REMOTE_ADDR'))
        $ipaddress = getenv('REMOTE_ADDR');
    else
        $ipaddress = 'UNKNOWN';
    return $ipaddress;
}

// 로그인 시도 기록 함수
function log_login_attempt($con, $user_id, $ip, $type, $reason = null) {
    $user_agent = mysqli_real_escape_string($con, $_SERVER['HTTP_USER_AGENT'] ?? '');
    $sql = "INSERT INTO login_attempts (user_id, ip_address, attempt_type, fail_reason, user_agent) 
            VALUES ('$user_id', '$ip', '$type', '$reason', '$user_agent')";
    mysqli_query($con, $sql);
}

// IP 차단 함수
function block_ip($con, $ip, $user_id = null, $reason = '로그인 3회 실패', $hours = 24) {
    $blocked_until = $hours ? "DATE_ADD(NOW(), INTERVAL $hours HOUR)" : "NULL";
    
    // 기존 차단 기록이 있는지 확인
    $check_sql = "SELECT * FROM ip_blacklist WHERE ip_address = '$ip' AND status = 'active'";
    $check_result = mysqli_query($con, $check_sql);
    
    if (mysqli_num_rows($check_result) == 0) {
        // 새로운 차단 추가
        $sql = "INSERT INTO ip_blacklist (ip_address, user_id, reason, blocked_until, failed_attempts) 
                VALUES ('$ip', '$user_id', '$reason', $blocked_until, 3)
                ON DUPLICATE KEY UPDATE 
                    status = 'active',
                    reason = '$reason',
                    blocked_until = $blocked_until,
                    failed_attempts = failed_attempts + 1,
                    updated_at = NOW()";
        mysqli_query($con, $sql);
    } else {
        // 기존 차단 업데이트
        $sql = "UPDATE ip_blacklist 
                SET failed_attempts = failed_attempts + 1,
                    blocked_until = $blocked_until,
                    updated_at = NOW()
                WHERE ip_address = '$ip'";
        mysqli_query($con, $sql);
    }
}

// IP 차단 확인 함수
function is_ip_blocked($con, $ip) {
    $sql = "SELECT * FROM ip_blacklist 
            WHERE ip_address = '$ip' 
            AND status = 'active' 
            AND (blocked_until IS NULL OR blocked_until > NOW())";
    $result = mysqli_query($con, $sql);
    return mysqli_num_rows($result) > 0;
}

// 메인 로그인 로직 시작
$current_ip = get_client_ip();

// 1. IP 차단 확인
if (is_ip_blocked($con, $current_ip)) {
    log_login_attempt($con, null, $current_ip, 'blocked', 'IP 차단됨');
    echo "<script>
        window.alert('접속이 차단된 IP입니다. 관리자에게 문의하세요.')
        history.go(-1)
    </script>";
    exit;
}

// 2. 입력값 받기
$id = mysqli_real_escape_string($con, strip_tags(trim($_POST["username"])));
$pass = mysqli_real_escape_string($con, strip_tags(trim($_POST["password"])));
$regist_date = date("Y-m-d H:i:s");

// 3. 사용자 조회
$sql = "SELECT * FROM member WHERE user_id='$id'";
$result = mysqli_query($con, $sql);
$num_match = mysqli_num_rows($result);
$row = mysqli_fetch_assoc($result);

if (!$num_match) { 
    // 아이디가 존재하지 않는 경우
    log_login_attempt($con, $id, $current_ip, 'failed', '존재하지 않는 아이디');
    echo "<script>
        window.alert('아이디/비밀번호를 확인해주세요!')
        history.go(-1)
    </script>";
    exit;
} else { 
    // 아이디는 존재하는 경우
    $db_pass = $row["password"];
    $user_db_id = $row['id'];
    $current_attempts = $row['failed_login_attempts'];
    
    // 계정 잠금 상태 확인
    if ($row['account_locked'] == 1 && $row['locked_until'] && $row['locked_until'] > date("Y-m-d H:i:s")) {
        log_login_attempt($con, $id, $current_ip, 'blocked', '계정 잠금');
        echo "<script>
            window.alert('계정이 잠겨있습니다. 잠금 해제 시간: {$row['locked_until']}')
            history.go(-1)
        </script>";
        exit;
    }
    
    // 비밀번호 확인 (평문 비교 - 실제로는 password_verify() 사용 권장)
    if ($pass !== $db_pass) {
        // 비밀번호 틀림
        $new_attempts = $current_attempts + 1;
        
        if ($new_attempts >= 3) {
            // 3회 이상 실패 - IP 차단 및 계정 잠금
            block_ip($con, $current_ip, $id, '비밀번호 3회 실패', 24); // 24시간 차단
            
            // 계정도 24시간 잠금
            $locked_until = date("Y-m-d H:i:s", strtotime("+24 hours"));
            $sql = "UPDATE member 
                    SET failed_login_attempts = $new_attempts,
                        last_failed_login = NOW(),
                        account_locked = 1,
                        locked_until = '$locked_until'
                    WHERE id = '$user_db_id'";
            mysqli_query($con, $sql);
            
            log_login_attempt($con, $id, $current_ip, 'failed', '3회 실패로 차단');
            
            echo "<script>
                window.alert('비밀번호를 3회 잘못 입력하여 24시간 동안 접속이 차단됩니다.')
                history.go(-1)
            </script>";
        } else {
            // 3회 미만 실패
            $sql = "UPDATE member 
                    SET failed_login_attempts = $new_attempts,
                        last_failed_login = NOW()
                    WHERE id = '$user_db_id'";
            mysqli_query($con, $sql);
            
            log_login_attempt($con, $id, $current_ip, 'failed', '비밀번호 틀림');
            
            $remaining = 3 - $new_attempts;
            echo "<script>
                window.alert('비밀번호가 틀렸습니다. (남은 기회: {$remaining}회)')
                history.go(-1)
            </script>";
        }
        exit;
    } else {
        // 로그인 성공
        session_start();
        
        // 세션 변수 설정
        $_SESSION["id"] = $row["user_id"];
        $_SESSION["user_name"] = $row["user_name"];
        $_SESSION["grade"] = $row["grade"];
        $_SESSION["user_grade"] = $row["grade"];
        
        // 로그인 성공 시 실패 횟수 초기화 및 계정 잠금 해제
        $sql = "UPDATE member 
                SET last_login_at = NOW(),
                    failed_login_attempts = 0,
                    last_failed_login = NULL,
                    account_locked = 0,
                    locked_until = NULL
                WHERE id = '$user_db_id'";
        mysqli_query($con, $sql);
        
        // 로그인 성공 기록
        log_login_attempt($con, $id, $current_ip, 'success', null);
        
        mysqli_close($con);
        
        echo "<script>
            location.href='index.php';
        </script>";
        exit;
    }
}
?>