<!DOCTYPE html>
<html lang="ko" class="dark">
<head>
    <meta charset="UTF-8">
    <title>시스템 점검 중 -  페이</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Pretendard', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            overflow: hidden;
            position: relative;
        }

        /* 애니메이션 배경 효과 */
        .bg-animation {
            position: absolute;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 1;
        }

        .bg-animation::before,
        .bg-animation::after {
            content: '';
            position: absolute;
            width: 400px;
            height: 400px;
            border-radius: 50%;
        }

        .bg-animation::before {
            background: rgba(255, 255, 255, 0.1);
            top: -200px;
            left: -200px;
            animation: float 20s infinite ease-in-out;
        }

        .bg-animation::after {
            background: rgba(255, 255, 255, 0.05);
            bottom: -200px;
            right: -200px;
            animation: float 15s infinite ease-in-out reverse;
        }

        @keyframes float {
            0%, 100% {
                transform: translate(0, 0) rotate(0deg);
            }
            25% {
                transform: translate(100px, -100px) rotate(90deg);
            }
            50% {
                transform: translate(-100px, 100px) rotate(180deg);
            }
            75% {
                transform: translate(-50px, -50px) rotate(270deg);
            }
        }

        /* 메인 컨테이너 */
        .maintenance-container {
            position: relative;
            z-index: 10;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 24px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            padding: 60px 40px;
            max-width: 500px;
            width: 90%;
            text-align: center;
            backdrop-filter: blur(10px);
            animation: slideUp 0.6s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* 기어 아이콘 애니메이션 */
        .gear-container {
            position: relative;
            width: 120px;
            height: 120px;
            margin: 0 auto 30px;
        }

        .gear {
            position: absolute;
            animation: rotate 3s linear infinite;
        }

        .gear-1 {
            top: 20%;
            left: 20%;
            font-size: 60px;
        }

        .gear-2 {
            bottom: 20%;
            right: 20%;
            font-size: 40px;
            animation-direction: reverse;
            animation-duration: 2s;
        }

        @keyframes rotate {
            from {
                transform: rotate(0deg);
            }
            to {
                transform: rotate(360deg);
            }
        }

        /* 프로그레스 바 */
        .progress-container {
            width: 100%;
            height: 6px;
            background: rgba(99, 102, 241, 0.1);
            border-radius: 3px;
            overflow: hidden;
            margin: 30px 0;
        }

        .progress-bar {
            height: 100%;
            background: linear-gradient(90deg, #667eea, #764ba2);
            border-radius: 3px;
            animation: progress 2s ease-in-out infinite;
        }

        @keyframes progress {
            0% {
                width: 0%;
                transform: translateX(0);
            }
            50% {
                width: 100%;
                transform: translateX(0);
            }
            100% {
                width: 100%;
                transform: translateX(100%);
            }
        }

        /* 점 애니메이션 */
        .dots {
            display: inline-block;
        }

        .dots::after {
            content: '...';
            animation: dots 1.5s infinite;
        }

        @keyframes dots {
            0%, 20% {
                content: '.';
            }
            40% {
                content: '..';
            }
            60%, 100% {
                content: '...';
            }
        }

        /* 타이머 효과 */
        .timer {
            display: inline-block;
            font-family: 'Monaco', 'Courier New', monospace;
            background: linear-gradient(135deg, #667eea, #764ba2);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-weight: bold;
            font-size: 1.2rem;
        }

        /* 반응형 */
        @media (max-width: 480px) {
            .maintenance-container {
                padding: 40px 30px;
            }
            
            .gear-container {
                width: 80px;
                height: 80px;
            }
            
            .gear-1 {
                font-size: 40px;
            }
            
            .gear-2 {
                font-size: 30px;
            }
        }
    </style>
</head>
<body>
    <!-- 애니메이션 배경 -->
    <div class="bg-animation"></div>

    <!-- 메인 컨테이너 -->
    <div class="maintenance-container">
        <!-- 기어 아이콘 -->
        <div class="gear-container">
            <div class="gear gear-1">⚙️</div>
            <div class="gear gear-2">⚙️</div>
        </div>

        <!-- 제목 -->
        <h1 class="text-3xl font-bold text-gray-800 mb-4">
            시스템 점검 중
        </h1>

        <!-- 프로그레스 바 -->
        <div class="progress-container">
            <div class="progress-bar"></div>
        </div>

        <!-- 메시지 -->
        <p class="text-gray-600 mb-6 leading-relaxed">
            더 나은 서비스 제공을 위해<br>
            시스템 점검을 진행하고 있습니다<span class="dots"></span>
        </p>

        <!-- 점검 시간 정보 -->
        <div class="bg-gray-50 rounded-lg p-4 mb-6">
            <p class="text-sm text-gray-500 mb-2">점검 시작 시간</p>
            <p class="text-lg font-semibold text-gray-700" id="startTime">
                <?php echo date('Y년 m월 d일 H:i'); ?>
            </p>
        </div>

        <!-- 예상 시간 -->
        <div class="flex items-center justify-center gap-2 text-sm text-gray-500 mb-6">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            <span>점검 완료 예정: <span class="timer" id="timer">계산 중...</span></span>
        </div>

        <!-- 안내 메시지 -->
        <div class="border-t border-gray-200 pt-6">
            <p class="text-xs text-gray-400 mb-3">
                점검이 완료되면 자동으로 접속 가능합니다.<br>
                불편을 드려 죄송합니다.
            </p>
            
            <!-- 로고 -->
            <div class="flex items-center justify-center gap-2 mt-4">
                <img src="/assets/images/logo.png" alt="페이" class="w-8 h-8">
                <span class="text-sm font-semibold text-gray-600"> 페이</span>
            </div>
        </div>

        <!-- 관리자용 로그아웃 버튼 (관리자는 점검 중에도 접속 가능) -->
        <?php if (isset($_SESSION["id"])): ?>
        <div class="mt-6">
            <a href="logout.php" 
               class="inline-block px-6 py-2 bg-gradient-to-r from-red-500 to-pink-500 text-white rounded-lg text-sm hover:opacity-90 transition">
                로그아웃
            </a>
        </div>
        <?php endif; ?>
    </div>

    <script>
        // 타이머 업데이트
        function updateTimer() {
            const now = new Date();
            const hours = now.getHours().toString().padStart(2, '0');
            const minutes = now.getMinutes().toString().padStart(2, '0');
            const seconds = now.getSeconds().toString().padStart(2, '0');
            
            document.getElementById('timer').textContent = `${hours}:${minutes}:${seconds}`;
        }

        // 1초마다 타이머 업데이트
        setInterval(updateTimer, 1000);
        updateTimer();

        // 5초마다 점검 상태 확인
        setInterval(() => {
            fetch('/ajax/check_maintenance_status.php')
                .then(res => res.json())
                .then(data => {
                    if (!data.partner_maintenance_enabled) {
                        // 점검이 해제되면 자동으로 새로고침
                        location.reload();
                    }
                })
                .catch(err => console.error('점검 상태 확인 오류:', err));
        }, 5000);
    </script>
</body>
</html>