<?php
// 세션 시작
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// 데이터베이스 연결 파일 포함
require_once('../inc/db_connect.php');

// CORS 헤더 설정
header('Content-Type: application/json; charset=UTF-8');
header('Cache-Control: no-cache');

// 응답 데이터 초기화
$response = [
    'status' => 'none',
    'count' => 0,
    'alarm_setting' => 0,
    'is_admin' => false
];

try {
    // 0. 현재 사용자가 관리자인지 확인
    if (!isset($_SESSION['id'])) {
        // 로그인하지 않은 경우
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit;
    }
    
    $current_user_id = $_SESSION['id'];
    
    // 현재 사용자의 grade 확인
    $adminCheckQuery = "SELECT grade FROM member WHERE user_id = ? LIMIT 1";
    $adminCheckStmt = mysqli_prepare($con, $adminCheckQuery);
    mysqli_stmt_bind_param($adminCheckStmt, "s", $current_user_id);
    mysqli_stmt_execute($adminCheckStmt);
    $adminCheckResult = mysqli_stmt_get_result($adminCheckStmt);
    
    if ($adminCheckResult && $adminRow = mysqli_fetch_assoc($adminCheckResult)) {
        if ($adminRow['grade'] !== 'admin') {
            // 관리자가 아닌 경우 빈 응답 반환
            echo json_encode($response, JSON_UNESCAPED_UNICODE);
            exit;
        }
        $response['is_admin'] = true;
    } else {
        // 사용자 정보를 찾을 수 없는 경우
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit;
    }
    mysqli_stmt_close($adminCheckStmt);
    
    // 여기서부터는 관리자만 실행됨
    
    // 1. 설정 테이블에서 알람 설정 확인
    // $settingQuery = "SELECT alarm FROM setting LIMIT 1";
    // $settingResult = mysqli_query($con, $settingQuery);
    
    // if ($settingResult && $settingRow = mysqli_fetch_assoc($settingResult)) {
    //     $response['alarm_setting'] = (int)$settingRow['alarm'];
    // }
    
    // 2. 신청된(requested) 출금 요청 확인
    $withdrawalQuery = "
        SELECT COUNT(*) as requested_count 
        FROM transfer 
        WHERE status = 'requested' 
        AND type = 'withdraw'
        AND created_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR)
    ";
    
    $withdrawalResult = mysqli_query($con, $withdrawalQuery);
    
    if ($withdrawalResult && $row = mysqli_fetch_assoc($withdrawalResult)) {
        if ($row['requested_count'] > 0) {
            $response['status'] = 'requested';
            $response['count'] = (int)$row['requested_count'];
        }
    }
    
    // 3. 선택사항: 가장 최근 신청된 출금 요청 정보 추가
    if ($response['count'] > 0) {
        $recentQuery = "
            SELECT 
                t.id,
                t.user_id,
                t.amount,
                t.created_at,
                m.user_id as member_user_id,
                m.account_holder,
                m.bank
            FROM transfer t
            LEFT JOIN member m ON t.user_id = m.id
            WHERE t.status = 'requested'
            AND t.type = 'withdraw'
            ORDER BY t.created_at DESC 
            LIMIT 5
        ";
        
        $recentResult = mysqli_query($con, $recentQuery);
        
        if ($recentResult) {
            $recentRequests = [];
            while ($recentRow = mysqli_fetch_assoc($recentResult)) {
                $recentRequests[] = [
                    'id' => $recentRow['id'],
                    'member_user_id' => $recentRow['member_user_id'],
                    'account_holder' => $recentRow['account_holder'],
                    'bank' => $recentRow['bank'],
                    'amount' => $recentRow['amount'],
                    'created_at' => $recentRow['created_at']
                ];
            }
            $response['recent_requests'] = $recentRequests;
        }
    }
    
} catch (Exception $e) {
    // 오류 처리
    $response['error'] = 'System error';
    error_log('Withdrawal status check error: ' . $e->getMessage());
}

// 데이터베이스 연결 종료
if (isset($con) && $con) {
    mysqli_close($con);
}

// JSON 응답 출력
echo json_encode($response, JSON_UNESCAPED_UNICODE);
exit;
?>