<?php
// payment_select.php - 페이지 이동 버전
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>송금 - 정보 입력</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        function closeInfoModal() {
            document.getElementById('infoModal').style.display = 'none';
            localStorage.setItem('paymentInfoSeen', 'true');
        }
        
        function showInfoModal() {
            document.getElementById('infoModal').style.display = 'flex';
        }
    </script>
</head>
<body class="bg-gray-900 text-white min-h-screen">
    <!-- 송금 안내 팝업 모달 -->
    <div id="infoModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
        <div class="bg-gray-800 rounded-xl p-6 max-w-md w-full mx-4 border border-yellow-400/30">
            <div class="text-center mb-6">
                <div class="w-20 h-20 bg-yellow-400 rounded-full flex items-center justify-center mx-auto mb-4">
                    <span class="text-3xl">💳</span>
                </div>
                <h2 class="text-2xl font-bold text-yellow-400 mb-2">송금 안내</h2>
                <p class="text-gray-300 text-sm">송금하기 전에 꼭 확인해주세요</p>
            </div>
            
            <div class="space-y-4 mb-6">
                <div class="bg-gray-700 rounded-lg p-4">
                    <div class="flex items-center space-x-3 mb-3">
                        <span class="text-purple-400 text-xl">🔑</span>
                        <h3 class="font-semibold text-purple-400">가맹점 코드</h3>
                    </div>
                    <p class="text-white">• 가맹점에서 제공한 고유 코드를 입력하세요</p>
                    <p class="text-gray-300 text-sm mt-1">예: 6789, ABCD, 1234 등</p>
                </div>

                <div class="bg-gray-700 rounded-lg p-4">
                    <div class="flex items-center space-x-3 mb-3">
                        <span class="text-green-400 text-xl">💰</span>
                        <h3 class="font-semibold text-green-400">송금 금액</h3>
                    </div>
                    <p class="text-white">• 최소 10,000원부터 송금 가능합니다</p>
                    <p class="text-white">• 최대 200만원까지 송금 가능합니다</p>
                </div>

                <div class="bg-red-900/30 border border-red-500/50 rounded-lg p-4">
                    <div class="flex items-center space-x-3 mb-3">
                        <span class="text-red-400 text-xl">⚠️</span>
                        <h3 class="font-semibold text-red-400">필수 확인사항</h3>
                    </div>
                    <ul class="text-red-200 text-sm space-y-2">
                        <li class="flex items-start space-x-2">
                            <span class="text-red-400 mt-0.5">•</span>
                            <span><strong>반드시 입금 신청 후</strong>입금해 주세요.</span>
                        </li>
                        <li class="flex items-start space-x-2">
                            <span class="text-red-400 mt-0.5">•</span>
                            <span><strong>입금자명</strong>을 반드시 정확히 입력해주세요</span>
                        </li>
                        <li class="flex items-start space-x-2">
                            <span class="text-red-400 mt-0.5">•</span>
                            <span><strong>입금 신청 시 기재한 액수와 입금</strong><br>금액이 정확히 일치해야 합니다.</span>
                        </li>
                    </ul>
                </div>
            </div>
            
            <div class="text-center">
                <button onclick="closeInfoModal()" 
                        class="w-full px-6 py-4 bg-yellow-400 text-gray-900 font-bold text-lg rounded-lg hover:bg-yellow-500 transition">
                    확인했습니다
                </button>
            </div>
        </div>
    </div>

    <div class="container mx-auto px-4 py-8 max-w-md">
        <!-- 헤더 -->
        <div class="text-center mb-8">
            <div class="w-20 h-20 bg-yellow-400 rounded-full flex items-center justify-center mx-auto mb-4">
                <span class="text-3xl">💳</span>
            </div>
            <h1 class="text-2xl font-bold text-yellow-400 mb-2">송금</h1>
            <p class="text-gray-300">송금 정보를 입력해주세요</p>
        </div>

        <!-- 가맹점 코드 입력 -->
        <div class="bg-gray-800 rounded-xl p-4 mb-6">
            <h3 class="text-lg font-semibold mb-3 text-purple-400">가맹점 정보</h3>
            <div class="space-y-3">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">가맹점 코드 *</label>
                    <input type="text" 
                           id="storeCode" 
                           placeholder="가맹점 코드를 입력하세요 (예: 6789)" 
                           class="w-full px-4 py-3 bg-gray-700 text-white rounded-lg border border-gray-600 focus:outline-none focus:ring-2 focus:ring-purple-400"
                           maxlength="20"
                           required>
                    <p class="text-xs text-gray-400 mt-1">* 가맹점에서 제공한 고유 코드</p>
                </div>
            </div>
        </div>

        <!-- 입금자명 입력 -->
        <div class="bg-gray-800 rounded-xl p-4 mb-6">
            <h3 class="text-lg font-semibold mb-3 text-yellow-400">입금자 정보</h3>
            <div class="space-y-3">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">입금자명 *</label>
                    <input type="text" 
                           id="depositorName" 
                           placeholder="입금하시는 분의 성함을 입력하세요" 
                           class="w-full px-4 py-3 bg-gray-700 text-white rounded-lg border border-gray-600 focus:outline-none focus:ring-2 focus:ring-yellow-400"
                           maxlength="20"
                           required>
                    <p class="text-xs text-gray-400 mt-1">* 필수 입력 항목입니다</p>
                </div>
            </div>
        </div>

        <!-- 금액 선택 버튼들 -->
        <div class="bg-gray-800 rounded-xl p-4 mb-6">
            <h3 class="text-lg font-semibold mb-4 text-green-400">송금 금액 선택</h3>
            <div class="grid grid-cols-2 gap-3 mb-4">
                <button onclick="addAmount(10000)" 
                        class="amount-btn bg-gray-700 hover:bg-green-600 border border-gray-600 hover:border-green-400 rounded-lg p-3 transition">
                    <div class="text-center">
                        <div class="text-lg font-semibold">1만원</div>
                    </div>
                </button>
                <button onclick="addAmount(30000)" 
                        class="amount-btn bg-gray-700 hover:bg-green-600 border border-gray-600 hover:border-green-400 rounded-lg p-3 transition">
                    <div class="text-center">
                        <div class="text-lg font-semibold">3만원</div>
                    </div>
                </button>
                <button onclick="addAmount(50000)" 
                        class="amount-btn bg-gray-700 hover:bg-green-600 border border-gray-600 hover:border-green-400 rounded-lg p-3 transition">
                    <div class="text-center">
                        <div class="text-lg font-semibold">5만원</div>
                    </div>
                </button>
                <button onclick="addAmount(100000)" 
                        class="amount-btn bg-gray-700 hover:bg-green-600 border border-gray-600 hover:border-green-400 rounded-lg p-3 transition">
                    <div class="text-center">
                        <div class="text-lg font-semibold">10만원</div>
                    </div>
                </button>
                <button onclick="addAmount(500000)" 
                        class="amount-btn bg-gray-700 hover:bg-green-600 border border-gray-600 hover:border-green-400 rounded-lg p-3 transition">
                    <div class="text-center">
                        <div class="text-lg font-semibold">50만원</div>
                    </div>
                </button>
                <button onclick="addAmount(1000000)" 
                        class="amount-btn bg-gray-700 hover:bg-green-600 border border-gray-600 hover:border-green-400 rounded-lg p-3 transition">
                    <div class="text-center">
                        <div class="text-lg font-semibold">100만원</div>
                    </div>
                </button>
            </div>
            
            <div class="grid grid-cols-1 gap-3 mb-4">
                <button onclick="addAmount(2000000)" 
                        class="amount-btn bg-gray-700 hover:bg-green-600 border border-gray-600 hover:border-green-400 rounded-lg p-3 transition">
                    <div class="text-center">
                        <div class="text-lg font-semibold">200만원</div>
                    </div>
                </button>
            </div>
            
            <div class="border-t border-gray-600 pt-4">
                <div class="flex justify-between items-center mb-3">
                    <h4 class="text-md font-medium text-gray-300">총 금액</h4>
                    <button onclick="resetAmount()" 
                            class="px-3 py-1 bg-red-500 text-white text-sm rounded hover:bg-red-600 transition">
                        초기화
                    </button>
                </div>
                <div class="flex space-x-2">
                    <input type="text" 
                           id="customAmount" 
                           placeholder="0" 
                           class="flex-1 px-4 py-3 bg-gray-700 text-white rounded-lg border border-gray-600 focus:outline-none focus:ring-2 focus:ring-green-400">
                    <button onclick="selectCustomAmount()" 
                            class="px-6 py-3 bg-green-400 text-gray-900 font-semibold rounded-lg hover:bg-green-500 transition">
                        선택
                    </button>
                </div>
                <p class="text-xs text-gray-400 mt-2">* 최대 200만원까지 선택 가능합니다</p>
                <p class="text-xs text-yellow-400 mt-1">💡 금액 버튼을 여러 번 눌러서 합산 가능합니다</p>
            </div>
        </div>

        <!-- <div class="bg-blue-900/20 border border-blue-500/30 rounded-lg p-4">
            <div class="flex items-start space-x-3">
                <span class="text-blue-400 text-xl">ℹ️</span>
                <div>
                    <h4 class="font-semibold text-blue-400 mb-1">이용 안내</h4>
                    <ul class="text-sm text-blue-200 space-y-1">
                        <li>• 가맹점 코드를 먼저 입력하세요</li>
                        <li>• 입금자명과 금액을 정확히 입력하세요</li>
                        <li>• 정보 확인 후 카카오페이로 연결됩니다</li>
                    </ul>
                </div>
            </div>
        </div> -->
    </div>

    <!-- 송금하기 버튼 -->
    <div class="container mx-auto px-4 pb-8 max-w-md">
        <button onclick="proceedWithSelectedAmount()" 
                class="w-full bg-gradient-to-r from-green-500 to-green-600 text-white font-bold py-4 px-6 rounded-xl hover:from-green-600 hover:to-green-700 transition text-lg shadow-lg">
            💳 송금하기
        </button>
    </div>

    <script>
        // 전역 변수
        let selectedAmount = 0;
        let storeData = null;
        const MAX_AMOUNT = 100000000;

        // 콤마 추가/제거 함수
        function formatWithComma(num) {
            return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',');
        }

        function removeComma(str) {
            return str.replace(/,/g, '');
        }

        // 인풋창 업데이트
        function updateAmountDisplay() {
            const customAmountInput = document.getElementById('customAmount');
            if (selectedAmount === 0) {
                customAmountInput.value = '0';
            } else {
                customAmountInput.value = formatWithComma(selectedAmount);
            }
        }

        // 금액 추가 함수 (합산 방식)
        function addAmount(amount) {
            let newAmount = selectedAmount + amount;
            
            if (newAmount > MAX_AMOUNT) {
                alert(`최대 ${formatWithComma(MAX_AMOUNT)}원까지 선택 가능합니다.\n현재 금액: ${formatWithComma(selectedAmount)}원`);
                return;
            }
            
            selectedAmount = newAmount;
            updateAmountDisplay();
            
            // console.log('누적된 금액:', formatWithComma(selectedAmount) + '원');
        }

        // 금액 리셋
        function resetAmount() {
            selectedAmount = 0;
            updateAmountDisplay();
            console.log('금액 초기화됨');
        }

        // 직접 입력 금액 처리
        function handleCustomAmountInput() {
            const customAmountInput = document.getElementById('customAmount');
            let value = customAmountInput.value;
            
            let cleanValue = removeComma(value);
            cleanValue = cleanValue.replace(/[^\d]/g, '');
            
            if (!cleanValue || cleanValue === '') {
                selectedAmount = 0;
                customAmountInput.value = '0';
                return;
            }
            
            let numValue = parseInt(cleanValue);
            
            if (numValue > MAX_AMOUNT) {
                numValue = MAX_AMOUNT;
                alert(`최대 ${formatWithComma(MAX_AMOUNT)}원까지 입력 가능합니다.`);
            }
            
            selectedAmount = numValue;
            customAmountInput.value = formatWithComma(numValue);
        }

        // 직접 입력 금액 선택
        function selectCustomAmount() {
            if (selectedAmount <= 0) {
                alert('1,000원 이상의 금액을 입력해주세요.');
                return;
            }
            
            if (selectedAmount < 10000) {
                alert('최소 10,000원 이상 입력해주세요.');
                return;
            }
            
            if (selectedAmount > MAX_AMOUNT) {
                alert(`${formatWithComma(MAX_AMOUNT)}원 이하의 금액을 입력해주세요.`);
                return;
            }
            
            validateInputs().then((isValid) => {
                if (isValid) {
                    proceedToPayment(selectedAmount);
                }
            });
        }

        // 페이지 로드 시 초기화
        document.addEventListener('DOMContentLoaded', function() {
            const hasSeenInfo = localStorage.getItem('paymentInfoSeen');
            if (!hasSeenInfo) {
                showInfoModal();
            }
            
            updateAmountDisplay();
            
            const customAmountInput = document.getElementById('customAmount');
            
            customAmountInput.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    selectCustomAmount();
                }
            });
            
            customAmountInput.addEventListener('input', function(e) {
                handleCustomAmountInput();
            });
            
            customAmountInput.addEventListener('blur', function(e) {
                handleCustomAmountInput();
            });
            
            document.getElementById('depositorName').addEventListener('keypress', function(e) {
                if (e.key === 'Enter' && selectedAmount > 0) {
                    proceedWithSelectedAmount();
                }
            });
        });

        // 가맹점 코드 확인
        function checkStoreCode(code) {
            return new Promise((resolve, reject) => {
                fetch('check_store_code.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ store_code: code })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        storeData = data.store;
                        // console.log('가맹점 확인됨:', data.store);
                        resolve(data.store);
                    } else {
                        storeData = null;
                        reject(data.message);
                    }
                })
                .catch(error => {
                    storeData = null;
                    reject('네트워크 오류가 발생했습니다.');
                });
            });
        }

        // 송금하기 버튼 처리
        function proceedWithSelectedAmount() {
            if (selectedAmount <= 0) {
                alert('송금할 금액을 선택해주세요.');
                return;
            }
            
            if (selectedAmount < 10000) {
                alert('최소 10,000원 이상 송금 가능합니다.');
                return;
            }
            
            validateInputs().then((isValid) => {
                if (isValid) {
                    proceedToPayment(selectedAmount);
                }
            });
        }

        // 입력값 검증
        function validateInputs() {
            const storeCode = document.getElementById('storeCode').value.trim();
            const depositorName = document.getElementById('depositorName').value.trim();
            
            if (!storeCode) {
                alert('가맹점 코드를 입력해주세요.');
                document.getElementById('storeCode').focus();
                return Promise.resolve(false);
            }
            
            if (!depositorName) {
                alert('입금자명을 입력해주세요.');
                document.getElementById('depositorName').focus();
                return Promise.resolve(false);
            }
            
            if (depositorName.length < 2) {
                alert('입금자명은 2글자 이상 입력해주세요.');
                document.getElementById('depositorName').focus();
                return Promise.resolve(false);
            }
            
            return checkStoreCode(storeCode)
                .then(() => {
                    return true;
                })
                .catch((error) => {
                    alert('가맹점 코드가 일치하지 않습니다.');
                    document.getElementById('storeCode').focus();
                    return false;
                });
        }

        // 결제 진행 (페이지 이동 방식)
        function proceedToPayment(amount) {
            const storeCode = document.getElementById('storeCode').value.trim();
            const depositorName = document.getElementById('depositorName').value.trim();
            
            // console.log('storeData:', storeData);
            // console.log('분기 확인:', {
            //     kakao_account_id: storeData.kakao_account_id,
            //     bank_account_id: storeData.bank_account_id,
            //     has_kakao: storeData.has_kakao,
            //     has_bank: storeData.has_bank
            // });
            
            // 원본 로직: ID 기반 분기
            if (storeData.kakao_account_id && storeData.kakao_account_id > 0 && storeData.has_kakao) {
                // 카카오페이 송금
                if (confirm(`가맹점: ${storeData.user_name}\n입금자: ${depositorName}\n금액: ${amount.toLocaleString()}원\n\n카카오페이로 송금하시겠습니까?`)) {
                    redirectToPayment('kakao', amount, depositorName, storeCode);
                }
            } else if (storeData.bank_account_id && storeData.bank_account_id > 0 && storeData.has_bank) {
                // 은행 송금
                if (confirm(`가맹점: ${storeData.user_name}\n입금자: ${depositorName}\n금액: ${amount.toLocaleString()}원\n\n은행 송금으로 진행하시겠습니까?`)) {
                    redirectToPayment('bank', amount, depositorName, storeCode);
                }
            } else {
                alert('해당 가맹점의 송금 방법이 설정되지 않았습니다. 관리자에게 문의하세요.');
                // console.error('송금 방법 설정 오류:', storeData);
            }
        }

   // 페이지 이동 (원래 버전으로 복구)
function redirectToPayment(type, amount, depositorName, storeCode) {
    const paymentData = {
        type: type,
        amount: amount,
        depositorName: depositorName,
        storeCode: storeCode,
        storeData: storeData,
        timestamp: new Date().getTime()
    };
    
    localStorage.setItem('paymentData', JSON.stringify(paymentData));
    
    if (type === 'kakao') {
        window.location.href = 'payment_process.php';  // 직접 이동
    } else if (type === 'bank') {
        window.location.href = `bank_transfer.php?store=${encodeURIComponent(storeCode)}`;  // 직접 이동
    }
}
    </script>
</body>
</html>