<?php
// quick_generate.php - 관리자용 링크 생성기
// 이 파일을 서버에 업로드하고 웹브라우저에서 접속

// 1. 실제 도메인 설정 (⚠️ 본인 도메인으로 변경!)
$your_domain = 'https://sgr-777.com'; // 여기에 실제 도메인 입력

// 2. 사용 가능한 접근 코드들
$access_codes = [
    'pay2024' => '일반 결제용',
    'send123' => '긴급 송금용', 
    'money456' => 'VIP 고객용',
    'quick999' => '빠른 결제용'
];

?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>사용자 링크 생성기</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 0 auto; padding: 20px; }
        .container { background: #f9f9f9; padding: 20px; border-radius: 10px; margin: 10px 0; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; color: #155724; }
        .warning { background: #fff3cd; border: 1px solid #ffeaa7; color: #856404; }
        .danger { background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; }
        .link-box { background: white; padding: 15px; border-radius: 5px; margin: 10px 0; border-left: 4px solid #007bff; }
        .copy-btn { background: #007bff; color: white; border: none; padding: 5px 10px; border-radius: 3px; cursor: pointer; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { border: 1px solid #ddd; padding: 12px; text-align: left; }
        th { background: #f2f2f2; }
        .generate-btn { background: #28a745; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; font-size: 16px; }
    </style>
</head>
<body>
    <h1>🔗 사용자 제공 링크 생성기</h1>
    
    <?php if ($your_domain === 'https://your-domain.com'): ?>
    <div class="container danger">
        <h3>⚠️ 도메인 설정 필요!</h3>
        <p>파일에서 <code>$your_domain</code>을 실제 도메인으로 변경해주세요.</p>
        <p>예: <code>$your_domain = 'https://admin-secret.com';</code></p>
    </div>
    <?php else: ?>
    
    <div class="container success">
        <h3>✅ 도메인 설정 완료</h3>
        <p>현재 도메인: <strong><?php echo $your_domain; ?></strong></p>
    </div>
    
    <div class="container">
        <h3>📋 링크 생성 방법</h3>
        <form method="POST">
            <label>접근 코드 선택:</label>
            <select name="selected_code" style="width: 200px; padding: 8px; margin: 10px;">
                <option value="">선택하세요</option>
                <?php foreach ($access_codes as $code => $desc): ?>
                <option value="<?php echo $code; ?>"><?php echo $code; ?> (<?php echo $desc; ?>)</option>
                <?php endforeach; ?>
            </select>
            
            <input type="text" name="memo" placeholder="메모 (선택사항)" style="width: 200px; padding: 8px; margin: 10px;">
            <button type="submit" name="generate" class="generate-btn">링크 생성</button>
        </form>
    </div>
    
    <?php
    if (isset($_POST['generate']) && $_POST['selected_code']) {
        $selected_code = $_POST['selected_code'];
        $memo = $_POST['memo'] ?? '';
        
        // 실제 접근 URL
        $real_url = $your_domain . '/secure_access.php?code=' . $selected_code;
        
        // TinyURL 생성 시도
        $tiny_url = generateTinyURL($real_url);
        
        if ($tiny_url && strpos($tiny_url, 'tinyurl.com') !== false) {
            ?>
            <div class="container success">
                <h3>🎉 링크 생성 성공!</h3>
                
                <div class="link-box">
                    <h4>📱 사용자에게 보낼 링크:</h4>
                    <div style="font-size: 20px; color: #007bff; font-weight: bold; margin: 10px 0;">
                        <?php echo $tiny_url; ?>
                    </div>
                    <button class="copy-btn" onclick="copyLink('<?php echo $tiny_url; ?>')">📋 복사</button>
                </div>
                
                <table>
                    <tr><th>구분</th><th>내용</th></tr>
                    <tr><td>사용자 링크</td><td><?php echo $tiny_url; ?></td></tr>
                    <tr><td>실제 URL</td><td><?php echo $real_url; ?></td></tr>
                    <tr><td>접근 코드</td><td><?php echo $selected_code; ?></td></tr>
                    <tr><td>설명</td><td><?php echo $access_codes[$selected_code]; ?></td></tr>
                    <?php if ($memo): ?>
                    <tr><td>메모</td><td><?php echo htmlspecialchars($memo); ?></td></tr>
                    <?php endif; ?>
                    <tr><td>생성 시간</td><td><?php echo date('Y-m-d H:i:s'); ?></td></tr>
                </table>
                
                <div class="container warning">
                    <h4>📋 사용 방법:</h4>
                    <ol>
                        <li>위의 <strong>사용자 링크</strong>를 복사</li>
                        <li>고객에게 "결제는 이 링크로: <?php echo $tiny_url; ?>" 전송</li>
                        <li>고객이 링크 클릭하면 바로 결제 페이지 표시</li>
                    </ol>
                </div>
            </div>
            <?php
        } else {
            ?>
            <div class="container danger">
                <h3>❌ TinyURL 생성 실패</h3>
                <p>네트워크 문제로 단축 URL 생성에 실패했습니다.</p>
                <p><strong>임시 대안:</strong> 아래 링크를 직접 사용하세요</p>
                <div class="link-box">
                    <code><?php echo $real_url; ?></code>
                    <button class="copy-btn" onclick="copyLink('<?php echo $real_url; ?>')">📋 복사</button>
                </div>
            </div>
            <?php
        }
    }
    ?>
    
    <div class="container">
        <h3>🔄 전체 접근 코드 현황</h3>
        <table>
            <tr><th>접근 코드</th><th>용도</th><th>테스트 링크</th></tr>
            <?php foreach ($access_codes as $code => $desc): ?>
            <tr>
                <td><code><?php echo $code; ?></code></td>
                <td><?php echo $desc; ?></td>
                <td><a href="<?php echo $your_domain; ?>/secure_access.php?code=<?php echo $code; ?>" target="_blank">테스트</a></td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
    
    <?php endif; ?>
    
    <script>
        function copyLink(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('링크가 복사되었습니다!\n\n' + text);
            }).catch(function() {
                prompt('다음 링크를 복사하세요:', text);
            });
        }
    </script>
</body>
</html>

<?php
function generateTinyURL($long_url) {
    $api_url = 'http://tinyurl.com/api-create.php?url=' . urlencode($long_url);
    $context = stream_context_create([
        'http' => [
            'timeout' => 10,
            'method' => 'GET'
        ]
    ]);
    
    $result = @file_get_contents($api_url, false, $context);
    
    if (!$result || strpos($result, 'tinyurl.com') === false) {
        return false;
    }
    
    return trim($result);
}
?>