<?php
// secure_access.php - DB 연동 가맹점별 보안 접근 처리
// URL: domain.com/secure_access.php?code=store6789_pay&store=6789

$access_code = $_GET['code'] ?? '';
$store_code = $_GET['store'] ?? '';

// DB 연결
include 'inc/db_connect.php';

// 기본 보안 검사
if (empty($access_code) || empty($store_code)) {
    showNotFoundPage();
    exit;
}

// DB에서 가맹점 존재 여부 확인
$store_query = "SELECT code FROM member WHERE code = ? AND grade != 'admin'";
$store_stmt = mysqli_prepare($con, $store_query);
mysqli_stmt_bind_param($store_stmt, 's', $store_code);
mysqli_stmt_execute($store_stmt);
$store_result = mysqli_fetch_assoc(mysqli_stmt_get_result($store_stmt));

if (!$store_result) {
    showNotFoundPage();
    exit;
}

// 접근 코드 패턴 검증 (store{코드}_xxx 형태여야 함)
$expected_prefix = 'store' . $store_code . '_';
if (strpos($access_code, $expected_prefix) !== 0) {
    showNotFoundPage();
    exit;
}

// 유효한 접근 코드 패턴들
$valid_patterns = ['_pay', '_quick', '_vip', '_bank', '_urgent', '_large'];
$is_valid_pattern = false;

foreach ($valid_patterns as $pattern) {
    if (substr($access_code, -strlen($pattern)) === $pattern) {
        $is_valid_pattern = true;
        break;
    }
}

if (!$is_valid_pattern) {
    showNotFoundPage();
    exit;
}

// 접근 성공 로그
error_log("Valid store access: Store={$store_code}, Code={$access_code}, IP=" . ($_SERVER['REMOTE_ADDR'] ?? 'unknown'));

// 기존 payment_select.php는 URL에 store 파라미터가 없어도 작동하도록 수정된 버전으로 리다이렉트
// 또는 새로운 universal_payment.php로 리다이렉트
header('Location: payment_select.php');
exit;

function showNotFoundPage() {
    http_response_code(404);
    ?>
    <!DOCTYPE html>
    <html lang="ko">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Page Not Found</title>
        <style>
            body { font-family: Arial, sans-serif; text-align: center; padding: 50px; background: #f8f9fa; }
            .error-container { max-width: 500px; margin: 0 auto; background: white; padding: 40px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
            h1 { color: #dc3545; margin-bottom: 20px; }
            p { color: #6c757d; line-height: 1.6; }
            .back-btn { background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block; margin-top: 20px; }
        </style>
    </head>
    <body>
        <div class="error-container">
            <h1>404 - Page Not Found</h1>
            <p>요청하신 페이지를 찾을 수 없습니다.</p>
            <p>링크가 올바른지 확인해주세요.</p>
            <a href="/" class="back-btn">홈으로 돌아가기</a>
        </div>
    </body>
    </html>
    <?php
}
?>