<?php
include 'layout/header.php';
?>

<style>
.setting-card {
  background: rgba(255, 255, 255, 0.05);
  border: 1px solid rgba(255, 255, 255, 0.1);
  border-radius: 12px;
  padding: 24px;
  margin-bottom: 20px;
  transition: all 0.3s ease;
}

.setting-card:hover {
  background: rgba(255, 255, 255, 0.07);
  border-color: rgba(255, 255, 255, 0.15);
}

.toggle-switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.toggle-switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #4b5563;
  transition: .4s;
  border-radius: 34px;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  transition: .4s;
  border-radius: 50%;
}

input:checked + .slider {
  background-color: #10b981;
}

input:checked + .slider:before {
  transform: translateX(26px);
}

.status-badge {
  display: inline-flex;
  align-items: center;
  padding: 0.5rem 1rem;
  border-radius: 9999px;
  font-size: 0.875rem;
  font-weight: 600;
  gap: 0.5rem;
}

.status-active {
  background-color: rgba(34, 197, 94, 0.2);
  color: rgb(34, 197, 94);
  border: 1px solid rgba(34, 197, 94, 0.3);
}

.status-inactive {
  background-color: rgba(107, 114, 128, 0.2);
  color: rgb(156, 163, 175);
  border: 1px solid rgba(107, 114, 128, 0.3);
}

.page-icon {
  width: 48px;
  height: 48px;
  border-radius: 12px;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 24px;
}

.partner-icon {
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.user-icon {
  background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.preview-section {
  background: rgba(0, 0, 0, 0.3);
  border: 1px solid rgba(255, 255, 255, 0.1);
  border-radius: 8px;
  padding: 20px;
  margin-top: 20px;
  opacity: 0.5;
  transition: opacity 0.3s ease;
}

.preview-section.enabled {
  opacity: 1;
}

.maintenance-preview {
  text-align: center;
  padding: 40px 20px;
  background: linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(168, 85, 247, 0.1));
  border-radius: 12px;
  border: 2px dashed rgba(168, 85, 247, 0.3);
}

.pulse-dot {
  height: 10px;
  width: 10px;
  border-radius: 50%;
  display: inline-block;
  animation: pulse 2s infinite;
}

@keyframes pulse {
  0% {
    box-shadow: 0 0 0 0 rgba(34, 197, 94, 0.7);
  }
  70% {
    box-shadow: 0 0 0 10px rgba(34, 197, 94, 0);
  }
  100% {
    box-shadow: 0 0 0 0 rgba(34, 197, 94, 0);
  }
}

.maintenance-icon {
  font-size: 64px;
  margin-bottom: 20px;
}

.info-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
  gap: 1rem;
  margin-top: 1rem;
}

.info-item {
  background: rgba(255, 255, 255, 0.03);
  padding: 1rem;
  border-radius: 8px;
  border: 1px solid rgba(255, 255, 255, 0.1);
}

.info-label {
  color: #9ca3af;
  font-size: 0.75rem;
  text-transform: uppercase;
  letter-spacing: 0.05em;
  margin-bottom: 0.25rem;
}

.info-value {
  color: #ffffff;
  font-size: 1.125rem;
  font-weight: 600;
}
</style>

<main class="flex-1 p-8 space-y-8">
  <!-- 헤더 -->
  <div class="flex justify-between items-center mb-6">
    <div>
      <h2 class="text-3xl font-bold text-primary">사이트 점검 관리</h2>
      <p class="text-gray-400 mt-2">파트너 페이지와 유저 페이지의 점검 모드를 관리합니다</p>
    </div>
    <button onclick="saveMaintenanceSettings()" class="px-6 py-3 bg-primary text-white rounded-lg hover:bg-teal-600 transition font-semibold">
      <span class="mr-2">💾</span> 설정 저장
    </button>
  </div>

  <!-- 현재 상태 요약 -->
  <div class="bg-gradient-to-r from-purple-500/10 to-blue-500/10 border border-purple-500/20 rounded-xl p-6">
    <h3 class="text-lg font-semibold text-white mb-4">📊 현재 점검 상태</h3>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <div class="flex items-center justify-between bg-black/20 rounded-lg p-4">
        <div class="flex items-center gap-3">
          <div class="page-icon partner-icon">👥</div>
          <div>
            <div class="text-white font-medium">파트너 페이지</div>
            <div class="text-gray-400 text-sm">Partner System</div>
          </div>
        </div>
        <span id="partner-current-status" class="status-badge status-inactive">
          <span class="pulse-dot bg-gray-500"></span>
          정상 운영
        </span>
      </div>
      
      <div class="flex items-center justify-between bg-black/20 rounded-lg p-4">
        <div class="flex items-center gap-3">
          <div class="page-icon user-icon">👤</div>
          <div>
            <div class="text-white font-medium">유저 페이지</div>
            <div class="text-gray-400 text-sm">User System</div>
          </div>
        </div>
        <span id="user-current-status" class="status-badge status-inactive">
          <span class="pulse-dot bg-gray-500"></span>
          정상 운영
        </span>
      </div>
    </div>
  </div>

  <!-- 파트너 페이지 점검 설정 -->
  <div class="setting-card">
    <div class="flex items-center justify-between mb-6">
      <div class="flex items-center gap-4">
        <div class="page-icon partner-icon">👥</div>
        <div>
          <h3 class="text-xl font-semibold text-white">파트너 페이지 점검</h3>
          <p class="text-gray-400 text-sm mt-1">총판 및 가맹점 관리자 접속 차단</p>
        </div>
      </div>
      <label class="toggle-switch">
        <input type="checkbox" id="partner-maintenance" onchange="toggleMaintenance('partner')">
        <span class="slider"></span>
      </label>
    </div>

    <div id="partner-preview" class="preview-section">
      <div class="maintenance-preview">
        <div class="maintenance-icon">🛠️</div>
        <h4 class="text-2xl font-bold text-white mb-2">시스템 점검 중</h4>
        <p class="text-gray-300 mb-4">
          더 나은 서비스 제공을 위해 시스템 점검을 진행하고 있습니다.<br>
          점검이 완료되면 다시 이용하실 수 있습니다.
        </p>
        <div class="text-sm text-gray-400">
          <p>📅 점검 시작: <span id="partner-start-time" class="text-yellow-400">-</span></p>
          <p>🔚 점검 완료 예정: <span class="text-blue-400">추후 공지</span></p>
        </div>
      </div>
      
      <div class="info-grid mt-4">
        <div class="info-item">
          <div class="info-label">영향 받는 사용자</div>
          <div class="info-value text-purple-400">총판, 가맹점</div>
        </div>
        <div class="info-item">
          <div class="info-label">차단 기능</div>
          <div class="info-value text-orange-400">전체 접속</div>
        </div>
      </div>
    </div>
  </div>

  <!-- 유저 페이지 점검 설정 -->
  <div class="setting-card">
    <div class="flex items-center justify-between mb-6">
      <div class="flex items-center gap-4">
        <div class="page-icon user-icon">👤</div>
        <div>
          <h3 class="text-xl font-semibold text-white">유저 페이지 점검</h3>
          <p class="text-gray-400 text-sm mt-1">일반 사용자 접속 차단</p>
        </div>
      </div>
      <label class="toggle-switch">
        <input type="checkbox" id="user-maintenance" onchange="toggleMaintenance('user')">
        <span class="slider"></span>
      </label>
    </div>

    <div id="user-preview" class="preview-section">
      <div class="maintenance-preview">
        <div class="maintenance-icon">🔧</div>
        <h4 class="text-2xl font-bold text-white mb-2">서비스 점검 안내</h4>
        <p class="text-gray-300 mb-4">
          시스템 업그레이드를 위한 정기 점검 중입니다.<br>
          잠시만 기다려 주시면 더 좋은 서비스로 찾아뵙겠습니다.
        </p>
        <div class="text-sm text-gray-400">
          <p>📅 점검 시작: <span id="user-start-time" class="text-yellow-400">-</span></p>
          <p>🔚 점검 완료 예정: <span class="text-blue-400">추후 공지</span></p>
        </div>
      </div>
      
      <div class="info-grid mt-4">
        <div class="info-item">
          <div class="info-label">영향 받는 사용자</div>
          <div class="info-value text-pink-400">일반 회원</div>
        </div>
        <div class="info-item">
          <div class="info-label">차단 기능</div>
          <div class="info-value text-red-400">전체 서비스</div>
        </div>
      </div>
    </div>
  </div>

  <!-- 주의사항 -->
  <div class="bg-red-500/10 border border-red-500/20 rounded-xl p-6">
    <h3 class="text-lg font-semibold text-red-400 mb-3">⚠️ 주의사항</h3>
    <ul class="space-y-2 text-sm text-red-300">
      <li class="flex items-start">
        <span class="mr-2">•</span>
        <span>점검 모드 활성화 시 해당 페이지의 모든 사용자가 접속할 수 없습니다.</span>
      </li>
      <li class="flex items-start">
        <span class="mr-2">•</span>
        <span>점검 중에도 관리자 계정은 정상적으로 접속 가능합니다.</span>
      </li>
      <li class="flex items-start">
        <span class="mr-2">•</span>
        <span>점검 해제 후 사용자들이 정상적으로 접속할 수 있는지 확인하세요.</span>
      </li>
      <li class="flex items-start">
        <span class="mr-2">•</span>
        <span>긴급 상황이 아닌 경우, 사전에 공지 후 점검을 진행하는 것을 권장합니다.</span>
      </li>
    </ul>
  </div>
</main>

<script>
// 페이지 로드 시 현재 설정 가져오기
document.addEventListener('DOMContentLoaded', function() {
  loadMaintenanceSettings();
});

// 현재 설정 불러오기
function loadMaintenanceSettings() {
  fetch('ajax/get_maintenance_settings.php')
    .then(response => response.json())
    .then(data => {
      if (data.success) {
        // 파트너 페이지 설정
        const partnerEnabled = data.settings.partner_maintenance_enabled == 1;
        document.getElementById('partner-maintenance').checked = partnerEnabled;
        toggleMaintenance('partner', false);
        
        // 유저 페이지 설정
        const userEnabled = data.settings.user_maintenance_enabled == 1;
        document.getElementById('user-maintenance').checked = userEnabled;
        toggleMaintenance('user', false);
        
        console.log('점검 설정 로드 완료:', data.settings);
      }
    })
    .catch(error => {
      console.error('설정 로드 실패:', error);
    });
}

// 점검 모드 토글
function toggleMaintenance(type, showAlert = true) {
  const checkbox = document.getElementById(type + '-maintenance');
  const preview = document.getElementById(type + '-preview');
  const statusBadge = document.getElementById(type + '-current-status');
  const isEnabled = checkbox.checked;
  
  // 프리뷰 섹션 업데이트
  if (isEnabled) {
    preview.classList.add('enabled');
    statusBadge.className = 'status-badge status-active';
    statusBadge.innerHTML = '<span class="pulse-dot bg-red-500"></span> 점검 중';
    
    // 현재 시간 표시
    const now = new Date();
    const timeString = now.toLocaleString('ko-KR');
    document.getElementById(type + '-start-time').textContent = timeString;
  } else {
    preview.classList.remove('enabled');
    statusBadge.className = 'status-badge status-inactive';
    statusBadge.innerHTML = '<span class="pulse-dot bg-gray-500"></span> 정상 운영';
  }
  
  // 활성화 시 경고
  if (isEnabled && showAlert) {
    const pageName = type === 'partner' ? '파트너' : '유저';
    const confirmMsg = `${pageName} 페이지를 점검 모드로 전환하시겠습니까?\n\n` +
                       `⚠️ 주의: 모든 ${pageName === '파트너' ? '총판 및 가맹점' : '일반 사용자'}의 접속이 차단됩니다.`;
    
    if (!confirm(confirmMsg)) {
      checkbox.checked = false;
      toggleMaintenance(type, false);
      return;
    }
  }
}

// 설정 저장
function saveMaintenanceSettings() {
  const settings = {
    partner_maintenance_enabled: document.getElementById('partner-maintenance').checked ? 1 : 0,
    user_maintenance_enabled: document.getElementById('user-maintenance').checked ? 1 : 0
  };
  
  // 로딩 표시
  const saveBtn = event.target;
  const originalText = saveBtn.innerHTML;
  saveBtn.innerHTML = '<span class="mr-2">⏳</span> 저장 중...';
  saveBtn.disabled = true;
  
  fetch('ajax/save_maintenance_settings.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify(settings)
  })
  .then(response => response.json())
  .then(data => {
    if (data.success) {
      // 성공 알림
      showNotification('✅ 점검 설정이 저장되었습니다.', 'success');
      
      // 상태 다시 로드
      loadMaintenanceSettings();
    } else {
      showNotification('❌ ' + (data.message || '설정 저장에 실패했습니다.'), 'error');
    }
  })
  .catch(error => {
    console.error('저장 실패:', error);
    showNotification('❌ 네트워크 오류가 발생했습니다.', 'error');
  })
  .finally(() => {
    // 버튼 원상복구
    saveBtn.innerHTML = originalText;
    saveBtn.disabled = false;
  });
}

// 알림 표시 함수
function showNotification(message, type = 'info') {
  // 기존 알림 제거
  const existingNotif = document.querySelector('.notification-toast');
  if (existingNotif) {
    existingNotif.remove();
  }
  
  // 새 알림 생성
  const notif = document.createElement('div');
  notif.className = 'notification-toast fixed top-4 right-4 p-4 rounded-lg shadow-lg transition-all z-50';
  
  // 타입별 스타일
  const styles = {
    success: 'bg-green-500 text-white',
    error: 'bg-red-500 text-white',
    info: 'bg-blue-500 text-white'
  };
  
  notif.className += ' ' + styles[type];
  notif.textContent = message;
  
  document.body.appendChild(notif);
  
  // 3초 후 제거
  setTimeout(() => {
    notif.style.opacity = '0';
    setTimeout(() => notif.remove(), 300);
  }, 3000);
}
</script>

</body>
</html>