<?php
// store_generate_no_access_code.php - 접근 코드 없는 간단한 버전
// 실제 DB에서 가맹점 정보를 가져옴

// 1. 실제 도메인 설정
$your_domain = 'https://sgr-777.com'; // 실제 도메인으로 변경

// 2. DB 연결
include 'inc/db_connect.php';

// 3. DB에서 가맹점 정보 조회
$store_query = "
    SELECT m.*, 
           ka.name as kakao_name, ka.qr_links,
           ba.bank as bank_name, ba.account_holder, ba.account_number
    FROM member m 
    LEFT JOIN kakao_account ka ON m.kakao_account_id = ka.id 
    LEFT JOIN bank_account ba ON m.bank_account_id = ba.id
    WHERE m.grade != 'admin' AND m.code IS NOT NULL AND m.code != ''
    ORDER BY m.user_name
";

$result = mysqli_query($con, $store_query);
$stores = array();

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        // 결제 방식 결정
        $payment_type = 'none';
        if (!empty($row['qr_links']) && $row['kakao_account_id'] > 0) {
            $payment_type = 'kakao';
        } elseif (!empty($row['bank_name']) && $row['bank_account_id'] > 0) {
            $payment_type = 'bank';
        }
        
        // 결제 방식이 설정된 가맹점만 포함
        if ($payment_type !== 'none') {
            $stores[$row['code']] = array(
                'id' => $row['id'],
                'name' => $row['user_name'],
                'code' => $row['code'],
                'type' => $payment_type,
                'kakao_name' => $row['kakao_name'],
                'bank_name' => $row['bank_name'],
                'account_holder' => $row['account_holder'],
                'phone_number' => $row['phone_number'],
                'created_at' => $row['created_at']
            );
        }
    }
}

// TinyURL 생성 함수
function generateTinyURL($long_url) {
    $api_url = 'http://tinyurl.com/api-create.php?url=' . urlencode($long_url);
    $context = stream_context_create(array(
        'http' => array(
            'timeout' => 10,
            'method' => 'GET'
        )
    ));
    
    $result = @file_get_contents($api_url, false, $context);
    
    if (!$result || strpos($result, 'tinyurl.com') === false) {
        return false;
    }
    
    return trim($result);
}

?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>가맹점 링크</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            max-width: 1000px; 
            margin: 0 auto; 
            padding: 20px; 
        }
        .container { 
            background: #f9f9f9; 
            padding: 20px; 
            border-radius: 10px; 
            margin: 10px 0; 
        }
        .success { 
            background: #d4edda; 
            border: 1px solid #c3e6cb; 
            color: #155724; 
        }
        .warning { 
            background: #fff3cd; 
            border: 1px solid #ffeaa7; 
            color: #856404; 
        }
        .danger { 
            background: #f8d7da; 
            border: 1px solid #f5c6cb; 
            color: #721c24; 
        }
        .info { 
            background: #d1ecf1; 
            border: 1px solid #bee5eb; 
            color: #0c5460; 
        }
        .link-box { 
            background: white; 
            padding: 15px; 
            border-radius: 5px; 
            margin: 10px 0; 
            border-left: 4px solid #007bff; 
        }
        .copy-btn { 
            background: #007bff; 
            color: white; 
            border: none; 
            padding: 5px 10px; 
            border-radius: 3px; 
            cursor: pointer; 
            margin: 0 5px; 
        }
        .kakao-badge { 
            background: #fee500; 
            color: #333; 
            padding: 2px 8px; 
            border-radius: 12px; 
            font-size: 12px; 
            font-weight: bold; 
        }
        .bank-badge { 
            background: #007bff; 
            color: white; 
            padding: 2px 8px; 
            border-radius: 12px; 
            font-size: 12px; 
            font-weight: bold; 
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 20px 0; 
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 8px; 
            text-align: left; 
            font-size: 14px; 
        }
        th { 
            background: #f2f2f2; 
        }
        .generate-btn { 
            background: #28a745; 
            color: white; 
            border: none; 
            padding: 10px 20px; 
            border-radius: 5px; 
            cursor: pointer; 
            font-size: 16px; 
        }
        .store-card { 
            background: white; 
            border: 1px solid #ddd; 
            border-radius: 8px; 
            padding: 15px; 
            margin: 10px 0; 
        }
        .store-grid { 
            display: grid; 
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); 
            gap: 15px; 
        }
    </style>
</head>
<body>
    <h1>🏪 가맹점 링크</h1>
    
    <div class="container info">
        <h3>📊 DB 연동 현황</h3>
        <p><strong>총 <?php echo count($stores); ?>개 가맹점</strong>이 결제 시스템에 등록되어 있습니다.</p>
        <ul>
            <?php
            $kakao_count = 0;
            $bank_count = 0;
            foreach ($stores as $store) {
                if ($store['type'] === 'kakao') $kakao_count++;
                if ($store['type'] === 'bank') $bank_count++;
            }
            ?>
            <li>카카오페이 가맹점: <strong><?php echo $kakao_count; ?>개</strong></li>
            <li>은행송금 가맹점: <strong><?php echo $bank_count; ?>개</strong></li>
        </ul>
    </div>
    
    <?php if (empty($stores)): ?>
    <div class="container danger">
        <h3>⚠️ 등록된 가맹점이 없습니다</h3>
        <p>결제 방식이 설정된 가맹점이 없습니다. 다음을 확인해주세요:</p>
        <ul>
            <li>member 테이블에 code가 설정된 가맹점이 있는지</li>
            <li>kakao_account 또는 bank_account가 연결되어 있는지</li>
            <li>qr_links 또는 은행 정보가 입력되어 있는지</li>
        </ul>
    </div>
    <?php else: ?>
    
    <div class="container">
        <h3>🎯 링크 생성</h3>
        <form method="POST">
            <label>가맹점 선택:</label>
            <select name="selected_store" style="width: 400px; padding: 8px; margin: 10px;" required>
                <option value="">가맹점을 선택하세요</option>
                <?php foreach ($stores as $store_code => $store_info): ?>
                <option value="<?php echo $store_code; ?>">
                    [<?php echo $store_code; ?>] <?php echo $store_info['name']; ?>
                    (<?php echo $store_info['type'] === 'kakao' ? '카카오페이' : '은행송금'; ?>)
                </option>
                <?php endforeach; ?>
            </select>
            
            <br>
            
            <input type="text" name="memo" placeholder="메모 (예: 홍길동님 전용, VIP 고객용)" style="width: 380px; padding: 8px; margin: 10px;">
            <button type="submit" name="generate" class="generate-btn">링크 생성</button>
        </form>
    </div>
    
    <?php
    if (isset($_POST['generate']) && $_POST['selected_store']) {
        $selected_store = $_POST['selected_store'];
        $memo = $_POST['memo'] ?? '';
        
        if (!isset($stores[$selected_store])) {
            echo "<div class='container danger'><h3>❌ 잘못된 가맹점입니다.</h3></div>";
        } else {
            $store_info = $stores[$selected_store];
            
            // 실제 접근 URL (단순히 결제 페이지로만 연결)
            $real_url = $your_domain . '/payment_select.php';
            
            // TinyURL 생성
            $tiny_url = generateTinyURL($real_url);
            
            if ($tiny_url && strpos($tiny_url, 'tinyurl.com') !== false) {
                ?>
                <div class="container success">
                    <h3>🎉 가맹점 전용 링크 생성 완료!</h3>
                    
                    <div class="store-card">
                        <h4>🏪 가맹점 정보</h4>
                        <table>
                            <tr><th>항목</th><th>내용</th></tr>
                            <tr><td>가맹점 코드</td><td><strong><?php echo $selected_store; ?></strong></td></tr>
                            <tr><td>가맹점명</td><td><?php echo $store_info['name']; ?></td></tr>
                            <tr><td>결제 방식</td><td>
                                <?php if ($store_info['type'] === 'kakao'): ?>
                                <span class="kakao-badge">카카오페이</span>
                                <?php if ($store_info['kakao_name']): ?>
                                <small>(<?php echo $store_info['kakao_name']; ?>)</small>
                                <?php endif; ?>
                                <?php else: ?>
                                <span class="bank-badge">은행송금</span>
                                <small>(<?php echo $store_info['bank_name']; ?> - <?php echo $store_info['account_holder']; ?>)</small>
                                <?php endif; ?>
                            </td></tr>
                            <tr><td>등록일</td><td><?php echo date('Y-m-d', strtotime($store_info['created_at'])); ?></td></tr>
                        </table>
                    </div>
                    
                    <div class="link-box">
                        <h4>📱 이 가맹점 전용 링크:</h4>
                        <div style="font-size: 20px; color: #007bff; font-weight: bold; margin: 10px 0;">
                            <?php echo $tiny_url; ?>
                        </div>
                        <button class="copy-btn" onclick="copyLink('<?php echo $tiny_url; ?>')">📋 복사</button>
                        <button class="copy-btn" onclick="testLink('<?php echo $tiny_url; ?>')" style="background: #6c757d;">🔗 테스트</button>
                        <button class="copy-btn" onclick="copyMessage('<?php echo $store_info['name']; ?>', '<?php echo $tiny_url; ?>')" style="background: #28a745;">💬 메시지 복사</button>
                    </div>
                    
                    <table>
                        <tr><th>구분</th><th>내용</th></tr>
                        <tr><td>사용자 링크</td><td style="word-break: break-all;"><?php echo $tiny_url; ?></td></tr>
                        <tr><td>가맹점 코드</td><td><?php echo $selected_store; ?></td></tr>
                        <tr><td>결제 방식</td><td><?php echo $store_info['type'] === 'kakao' ? '카카오페이' : '은행송금'; ?></td></tr>
                        <?php if ($memo): ?>
                        <tr><td>메모</td><td><?php echo htmlspecialchars($memo); ?></td></tr>
                        <?php endif; ?>
                        <tr><td>생성 시간</td><td><?php echo date('Y-m-d H:i:s'); ?></td></tr>
                    </table>
                </div>
                <?php
            } else {
                ?>
                <div class="container danger">
                    <h3>❌ TinyURL 생성 실패</h3>
                    <p><strong>대안:</strong> 실제 URL을 직접 사용하세요</p>
                    <div class="link-box">
                        <code style="word-break: break-all;"><?php echo $real_url; ?></code>
                        <button class="copy-btn" onclick="copyLink('<?php echo $real_url; ?>')">📋 복사</button>
                    </div>
                </div>
                <?php
            }
        }
    }
    ?>
    
    <div class="container">
        <h3>🏪 전체 가맹점 현황</h3>
        <div class="store-grid">
            <?php foreach ($stores as $store_code => $store_info): ?>
            <div class="store-card">
                <h4>
                    [<?php echo $store_code; ?>] <?php echo $store_info['name']; ?>
                    <?php if ($store_info['type'] === 'kakao'): ?>
                    <span class="kakao-badge">카카오페이</span>
                    <?php else: ?>
                    <span class="bank-badge">은행송금</span>
                    <?php endif; ?>
                </h4>
                
                <table style="margin: 10px 0; font-size: 12px;">
                    <tr><th>정보</th><th>내용</th></tr>
                    <tr><td>코드</td><td><?php echo $store_code; ?></td></tr>
                    <?php if ($store_info['type'] === 'kakao' && $store_info['kakao_name']): ?>
                    <tr><td>카카오명</td><td><?php echo $store_info['kakao_name']; ?></td></tr>
                    <?php endif; ?>
                    <?php if ($store_info['type'] === 'bank'): ?>
                    <tr><td>은행</td><td><?php echo $store_info['bank_name']; ?></td></tr>
                    <tr><td>예금주</td><td><?php echo $store_info['account_holder']; ?></td></tr>
                    <?php endif; ?>
                    <?php if ($store_info['phone_number']): ?>
                    <tr><td>연락처</td><td><?php echo $store_info['phone_number']; ?></td></tr>
                    <?php endif; ?>
                </table>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    
    <?php endif; ?>
    
    <script>
        function copyLink(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('링크가 복사되었습니다!\n\n' + text);
            }).catch(function() {
                prompt('다음 링크를 복사하세요:', text);
            });
        }
        
        function copyMessage(storeName, link) {
            var message = '안녕하세요! ' + storeName + ' 결제는 다음 링크에서 진행해주세요:\n\n' + link + '\n\n감사합니다.';
            navigator.clipboard.writeText(message).then(function() {
                alert('고객 전송용 메시지가 복사되었습니다!');
            }).catch(function() {
                prompt('다음 메시지를 복사하세요:', message);
            });
        }
        
        function testLink(url) {
            window.open(url, '_blank');
        }
    </script>
</body>
</html>