<?php
header('Content-Type: application/json; charset=utf-8');

// POST 요청만 허용
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => '잘못된 요청 방법입니다.']);
    exit;
}

// 세션 시작 및 로그인 확인
session_start();
if (!isset($_SESSION["id"]) || empty($_SESSION["id"])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

// 데이터베이스 연결
include "inc/db_connect.php";

// MySQLi 연결 확인
if (!isset($con) || !$con) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => '데이터베이스 연결 오류가 발생했습니다.']);
    exit;
}

try {
    // 입력 데이터 검증 및 정제
    $user_id = trim($_POST['user_id'] ?? '');
    $user_name = trim($_POST['user_name'] ?? '');
    $code = trim($_POST['code'] ?? '');
    $kakao_account_id = intval($_POST['kakao_account_id'] ?? 0);
    $bank_account_id = intval($_POST['bank_account_id'] ?? 0);
    $bank = trim($_POST['bank'] ?? '');
    $account_number = trim($_POST['account_number'] ?? '');
    $account_holder = trim($_POST['account_holder'] ?? '');
    $rate = floatval($_POST['rate'] ?? 0);

    // 필수 필드 검증
    if (empty($user_id)) {
        throw new Exception('가맹점 아이디가 필요합니다.');
    }
    if (empty($user_name)) {
        throw new Exception('가맹점명을 입력해주세요.');
    }
    if (empty($code)) {
        throw new Exception('가맹점 코드를 입력해주세요.');
    }

    // 카카오 계정과 은행 연결계정 중 하나는 반드시 선택해야 함
    if ($kakao_account_id <= 0 && $bank_account_id <= 0) {
        throw new Exception('카카오 연결계정 또는 은행 연결계정 중 하나를 선택해주세요.');
    }

    // 카카오 계정과 은행 연결계정을 둘 다 선택할 수 없음
    if ($kakao_account_id > 0 && $bank_account_id > 0) {
        throw new Exception('카카오 연결계정과 은행 연결계정 중 하나만 선택할 수 있습니다.');
    }

    // 개별 출금정보는 필수
    if (empty($bank) || empty($account_number) || empty($account_holder)) {
        throw new Exception('개별 출금정보(은행명, 계좌번호, 예금주)를 모두 입력해주세요.');
    }

    // 입력값 유효성 검사
    if (strlen($user_name) > 100) {
        throw new Exception('가맹점명은 100자 이하여야 합니다.');
    }
    if (strlen($code) > 20) {
        throw new Exception('가맹점 코드는 20자 이하여야 합니다.');
    }
    if ($rate < 0 || $rate > 100) {
        throw new Exception('수수료율은 0~100% 사이여야 합니다.');
    }

    // 계좌번호 형식 검증
    if (!preg_match('/^[0-9-]+$/', $account_number)) {
        throw new Exception('계좌번호는 숫자와 하이픈(-)만 사용할 수 있습니다.');
    }

    // 카카오 계정 존재 확인 (선택된 경우에만)
    if ($kakao_account_id > 0) {
        $kakaoCheckSql = "SELECT id FROM kakao_account WHERE id = $kakao_account_id";
        $kakaoCheckResult = mysqli_query($con, $kakaoCheckSql);
        if (!$kakaoCheckResult || mysqli_num_rows($kakaoCheckResult) === 0) {
            throw new Exception('존재하지 않는 카카오 계정입니다.');
        }
    }

    // 은행 연결계정 존재 확인 (선택된 경우에만)
    if ($bank_account_id > 0) {
        $bankCheckSql = "SELECT id FROM bank_account WHERE id = $bank_account_id";
        $bankCheckResult = mysqli_query($con, $bankCheckSql);
        if (!$bankCheckResult || mysqli_num_rows($bankCheckResult) === 0) {
            throw new Exception('존재하지 않는 은행 계정입니다.');
        }
    }

    // 해당 가맹점이 존재하는지 확인
    $user_id_escaped = mysqli_real_escape_string($con, $user_id);
    $checkSql = "SELECT id FROM member WHERE user_id = '$user_id_escaped'";
    $checkResult = mysqli_query($con, $checkSql);
    
    if (!$checkResult || mysqli_num_rows($checkResult) === 0) {
        throw new Exception('존재하지 않는 가맹점입니다.');
    }

    // 다른 가맹점에서 같은 코드를 사용하는지 확인
    $code_escaped = mysqli_real_escape_string($con, $code);
    $duplicateCheckSql = "SELECT user_id FROM member WHERE code = '$code_escaped' AND user_id != '$user_id_escaped'";
    $duplicateResult = mysqli_query($con, $duplicateCheckSql);
    
    if ($duplicateResult && mysqli_num_rows($duplicateResult) > 0) {
        throw new Exception('이미 사용 중인 가맹점 코드입니다.');
    }

    // 데이터 이스케이프
    $user_name_escaped = mysqli_real_escape_string($con, $user_name);
    $bank_escaped = mysqli_real_escape_string($con, $bank);
    $account_number_escaped = mysqli_real_escape_string($con, $account_number);
    $account_holder_escaped = mysqli_real_escape_string($con, $account_holder);

    // 가맹점 정보 업데이트
    $updateSql = "UPDATE member SET 
                    user_name = '$user_name_escaped',
                    code = '$code_escaped',
                    kakao_account_id = " . ($kakao_account_id > 0 ? $kakao_account_id : "0") . ",
                    bank_account_id = " . ($bank_account_id > 0 ? $bank_account_id : "0") . ",
                    bank = '$bank_escaped',
                    account_number = '$account_number_escaped',
                    account_holder = '$account_holder_escaped',
                    rate = $rate,
                    updated_at = NOW()
                  WHERE user_id = '$user_id_escaped'";

    $result = mysqli_query($con, $updateSql);

    if ($result) {
        $affected_rows = mysqli_affected_rows($con);
        
        if ($affected_rows > 0) {
            echo json_encode([
                'success' => true,
                'message' => '가맹점 정보가 성공적으로 수정되었습니다.',
                'data' => [
                    'user_id' => $user_id,
                    'user_name' => $user_name,
                    'code' => $code,
                    'kakao_account_id' => $kakao_account_id,
                    'bank_account_id' => $bank_account_id,
                    'rate' => $rate
                ]
            ]);
        } else {
            echo json_encode([
                'success' => true,
                'message' => '변경된 내용이 없습니다.',
                'data' => ['user_id' => $user_id]
            ]);
        }
    } else {
        throw new Exception('가맹점 수정 중 오류가 발생했습니다: ' . mysqli_error($con));
    }

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>