<?php
include 'layout/header.php';
?>

<style>
.time-input {
  width: 180px;
  font-family: 'Courier New', monospace;
  font-size: 16px;
}

.setting-card {
  background: rgba(255, 255, 255, 0.05);
  border: 1px solid rgba(255, 255, 255, 0.1);
  border-radius: 12px;
  padding: 24px;
  margin-bottom: 20px;
}

.grade-badge {
  display: inline-flex;
  align-items: center;
  padding: 0.375rem 0.75rem;
  border-radius: 9999px;
  font-size: 0.875rem;
  font-weight: 600;
  white-space: nowrap;
}

.grade-partner {
  background-color: rgb(59, 130, 246);
  color: white;
}

.grade-basic {
  background-color: rgb(34, 197, 94);
  color: white;
}

.grade-hourly {
  background-color: rgb(168, 85, 247);
  color: white;
}

.toggle-switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.toggle-switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  transition: .4s;
  border-radius: 34px;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  transition: .4s;
  border-radius: 50%;
}

input:checked + .slider {
  background-color: #10b981;
}

input:checked + .slider:before {
  transform: translateX(26px);
}

.time-setting-row {
  opacity: 0.5;
  pointer-events: none;
  transition: opacity 0.3s ease;
}

.time-setting-row.enabled {
  opacity: 1;
  pointer-events: auto;
}

.status-indicator {
  display: inline-flex;
  align-items: center;
  padding: 0.25rem 0.75rem;
  border-radius: 9999px;
  font-size: 0.75rem;
  font-weight: 500;
}

.status-active {
  background-color: rgba(34, 197, 94, 0.2);
  color: rgb(34, 197, 94);
}

.status-inactive {
  background-color: rgba(107, 114, 128, 0.2);
  color: rgb(107, 114, 128);
}

.time-format-note {
  font-size: 0.75rem;
  color: rgb(156, 163, 175);
  margin-top: 0.25rem;
  font-style: italic;
}
</style>

<main class="flex-1 p-8 space-y-8">
  <div class="flex justify-between items-center">
    <h2 class="text-3xl font-bold text-primary mb-6">출금 시간 관리</h2>
    <button onclick="saveAllSettings()" class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-teal-600 transition">
      설정 저장
    </button>
  </div>

  <!-- 12시간 형식 안내 -->
  <div class="bg-blue-500/10 border border-blue-500/20 rounded-lg p-4">
    <h4 class="text-blue-300 font-semibold mb-2">💡 시간 입력 안내</h4>
    <p class="text-blue-200 text-sm">
      시간은 <strong>시간 형식</strong>으로 입력해주세요. (예: 오전 6시 → 06:00, 오후 11시 → 11:00)
    </p>
  </div>

  <!-- 디버그 정보 -->
  <div id="debug-info" class="bg-red-500/10 border border-red-500/20 rounded-lg p-4 hidden">
    <h4 class="text-red-300 font-semibold mb-2">디버그 정보:</h4>
    <pre id="debug-content" class="text-red-200 text-sm"></pre>
  </div>

  <!-- 설정 상태 표시 -->
  <div class="bg-white/5 border border-white/10 rounded-xl p-6">
    <h3 class="text-lg font-semibold text-white mb-4">현재 설정 상태</h3>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
      <div class="flex items-center justify-between">
        <div class="flex items-center space-x-3">
          <span class="grade-badge grade-partner">총판</span>
          <span class="text-gray-300">출금 차단</span>
        </div>
        <span id="partner-status" class="status-indicator status-inactive">비활성화</span>
      </div>
      <div class="flex items-center justify-between">
        <div class="flex items-center space-x-3">
          <span class="grade-badge grade-basic">가맹점</span>
          <span class="text-gray-300">출금 차단</span>
        </div>
        <span id="basic-status" class="status-indicator status-inactive">비활성화</span>
      </div>
      <div class="flex items-center justify-between">
        <div class="flex items-center space-x-3">
          <span class="grade-badge grade-hourly">매시간</span>
          <span class="text-gray-300">출금 차단</span>
        </div>
        <span id="hourly-status" class="status-indicator status-inactive">비활성화</span>
      </div>
    </div>
  </div>

  <!-- 매시간 출금 차단 설정 (새로 추가) -->
  <div class="setting-card">
    <div class="flex items-center justify-between mb-6">
      <div class="flex items-center space-x-3">
        <span class="grade-badge grade-hourly">매시간</span>
        <h3 class="text-xl font-semibold text-white">출금 차단 설정 (50분~정각)</h3>
      </div>
      <label class="toggle-switch">
        <input type="checkbox" id="hourly-enabled" onchange="toggleHourlySettings()">
        <span class="slider"></span>
      </label>
    </div>

    <div class="mb-4 p-4 bg-purple-500/10 border border-purple-500/20 rounded-lg">
      <h4 class="text-purple-300 font-semibold mb-2">🕒 매시간 자동 차단</h4>
      <p class="text-purple-200 text-sm mb-2">
        <strong>차단 시간:</strong> 매시간 50분 ~ 정각 (10분간)
      </p>
      <p class="text-purple-200 text-sm">
        <strong>예시:</strong> 09:50~10:00, 10:50~11:00, 11:50~12:00 등 모든 시간대에 적용
      </p>
    </div>

    <div class="mt-4 p-4 bg-yellow-500/10 border border-yellow-500/20 rounded-lg">
      <p class="text-yellow-300 text-sm">
        <strong>주의:</strong> 이 설정이 활성화되면 매시간 50분부터 정각까지 10분 동안 모든 등급의 출금이 차단됩니다.
      </p>
    </div>
  </div>

  <!-- 총판 출금 시간 설정 -->
  <div class="setting-card">
    <div class="flex items-center justify-between mb-6">
      <div class="flex items-center space-x-3">
        <span class="grade-badge grade-partner">총판</span>
        <h3 class="text-xl font-semibold text-white">출금 차단 시간 설정</h3>
      </div>
      <label class="toggle-switch">
        <input type="checkbox" id="partner-enabled" onchange="toggleTimeSettings('partner')">
        <span class="slider"></span>
      </label>
    </div>

    <div id="partner-time-settings" class="time-setting-row">
      <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
          <label class="block text-sm text-gray-400 mb-2">차단 시작 시간</label>
          <input type="time" id="partner-start-time" 
            class="time-input px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary"
            step="300">
          <div class="time-format-note">12시간 형식 (예: 11:00)</div>
        </div>
        <div>
          <label class="block text-sm text-gray-400 mb-2">차단 종료 시간</label>
          <input type="time" id="partner-end-time" 
            class="time-input px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary"
            step="300">
          <div class="time-format-note">12시간 형식 (예: 06:00)</div>
        </div>
      </div>
      <div class="mt-4 p-4 bg-yellow-500/10 border border-yellow-500/20 rounded-lg">
        <p class="text-yellow-300 text-sm">
          <strong>주의:</strong> 설정된 시간 동안 총판 등급의 가맹점들은 출금을 할 수 없습니다.
        </p>
      </div>
    </div>
  </div>

  <!-- 가맹점 출금 시간 설정 -->
  <div class="setting-card">
    <div class="flex items-center justify-between mb-6">
      <div class="flex items-center space-x-3">
        <span class="grade-badge grade-basic">가맹점</span>
        <h3 class="text-xl font-semibold text-white">출금 차단 시간 설정</h3>
      </div>
      <label class="toggle-switch">
        <input type="checkbox" id="basic-enabled" onchange="toggleTimeSettings('basic')">
        <span class="slider"></span>
      </label>
    </div>

    <div id="basic-time-settings" class="time-setting-row">
      <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
          <label class="block text-sm text-gray-400 mb-2">차단 시작 시간</label>
          <input type="time" id="basic-start-time" 
            class="time-input px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary"
            step="300">
          <div class="time-format-note">12시간 형식 (예: 18:00)</div>
        </div>
        <div>
          <label class="block text-sm text-gray-400 mb-2">차단 종료 시간</label>
          <input type="time" id="basic-end-time" 
            class="time-input px-4 py-2 rounded bg-gray-800 text-white border border-gray-600 focus:outline-none focus:ring-2 focus:ring-primary"
            step="300"
            pattern="[0-9]{2}:[0-9]{2}"
            title="12시간 형식으로 입력하세요 (예: 09:00)"
            placeholder="09:00">
          <div class="time-format-note">12시간 형식 (예: 09:00)</div>
        </div>
      </div>
      <div class="mt-4 p-4 bg-yellow-500/10 border border-yellow-500/20 rounded-lg">
        <p class="text-yellow-300 text-sm">
          <strong>주의:</strong> 설정된 시간 동안 일반 가맹점 등급의 가맹점들은 출금을 할 수 없습니다.
        </p>
      </div>
    </div>
  </div>

  <!-- 설정 예시 -->
  <div class="bg-white/5 border border-white/10 rounded-xl p-6">
    <h3 class="text-lg font-semibold text-white mb-4">설정 예시 (12시간 형식)</h3>
    <div class="space-y-3 text-sm text-gray-300">
      <div class="flex items-center">
        <span class="w-3 h-3 bg-purple-500 rounded-full mr-3"></span>
        <span>매시간 자동 차단 (09:50~10:00, 10:50~11:00, 11:50~12:00 등)</span>
      </div>
      <div class="flex items-center">
        <span class="w-3 h-3 bg-blue-500 rounded-full mr-3"></span>
        <span>야간 시간대 (오후 11:00 ~ 오전 06:00) 출금 차단 - 자정 넘나드는 시간</span>
      </div>
      <div class="flex items-center">
        <span class="w-3 h-3 bg-green-500 rounded-full mr-3"></span>
        <span>점심 시간대 (오전 12:00 ~ 오후 01:00) 출금 차단 - 같은 날 시간</span>
      </div>
      <div class="flex items-center">
        <span class="w-3 h-3 bg-orange-500 rounded-full mr-3"></span>
        <span>업무 시간외 (오후 06:00 ~ 오전 09:00) 출금 차단 - 자정 넘나드는 시간</span>
      </div>
    </div>
    <div class="mt-4 p-3 bg-green-500/10 border border-green-500/20 rounded-lg">
      <p class="text-green-200 text-xs">
        <strong>참고:</strong> 매시간 차단과 다른 차단 설정이 동시에 활성화된 경우, 모든 조건이 적용됩니다.
      </p>
    </div>
  </div>
</main>

<script>
// 페이지 로드 시 현재 설정 가져오기
document.addEventListener('DOMContentLoaded', function() {
  console.log('페이지 로드됨 - 설정 로드 시작');
  loadCurrentSettings();
});

// 디버그 정보 표시
function showDebug(message) {
  console.log('Debug:', message);
  const debugInfo = document.getElementById('debug-info');
  const debugContent = document.getElementById('debug-content');
  debugContent.textContent = JSON.stringify(message, null, 2);
  debugInfo.classList.remove('hidden');
}

// 현재 설정 가져오기
function loadCurrentSettings() {
  console.log('설정 로드 요청 시작');
  
  fetch('ajax/get_withdraw_settings.php')
    .then(response => {
      console.log('응답 상태:', response.status);
      if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
      }
      return response.text();
    })
    .then(text => {
      console.log('응답 텍스트:', text);
      try {
        const data = JSON.parse(text);
        console.log('파싱된 데이터:', data);
        
        if (data.success && data.settings) {
          const settings = data.settings;
          
          // 총판 설정
          document.getElementById('partner-enabled').checked = settings.partner_withdraw_block_enabled == 1;
          document.getElementById('partner-start-time').value = settings.partner_withdraw_block_start || '';
          document.getElementById('partner-end-time').value = settings.partner_withdraw_block_end || '';
          toggleTimeSettings('partner');
          
          // 가맹점 설정
          document.getElementById('basic-enabled').checked = settings.basic_withdraw_block_enabled == 1;
          document.getElementById('basic-start-time').value = settings.basic_withdraw_block_start || '';
          document.getElementById('basic-end-time').value = settings.basic_withdraw_block_end || '';
          toggleTimeSettings('basic');
          
          // 매시간 설정 (새로 추가)
          document.getElementById('hourly-enabled').checked = settings.hourly_withdraw_block_enabled == 1;
          
          // 상태 업데이트
          updateStatusIndicators();
          
          console.log('설정 로드 완료');
        } else {
          showDebug('API 응답 오류: ' + (data.message || '알 수 없는 오류'));
        }
      } catch (e) {
        console.error('JSON 파싱 오류:', e);
        showDebug('JSON 파싱 실패: ' + text);
      }
    })
    .catch(error => {
      console.error('설정 로드 실패:', error);
      showDebug('네트워크 오류: ' + error.message);
      alert('설정을 불러오는 중 오류가 발생했습니다: ' + error.message);
    });
}

// 시간 설정 토글
function toggleTimeSettings(grade) {
  const enabled = document.getElementById(grade + '-enabled').checked;
  const timeSettings = document.getElementById(grade + '-time-settings');
  
  if (enabled) {
    timeSettings.classList.add('enabled');
  } else {
    timeSettings.classList.remove('enabled');
  }
  
  updateStatusIndicators();
}

// 매시간 설정 토글 (새로 추가)
function toggleHourlySettings() {
  updateStatusIndicators();
}

// 상태 표시기 업데이트
function updateStatusIndicators() {
  // 총판 상태
  const partnerEnabled = document.getElementById('partner-enabled').checked;
  const partnerStatus = document.getElementById('partner-status');
  
  if (partnerEnabled) {
    partnerStatus.textContent = '활성화';
    partnerStatus.className = 'status-indicator status-active';
  } else {
    partnerStatus.textContent = '비활성화';
    partnerStatus.className = 'status-indicator status-inactive';
  }
  
  // 가맹점 상태
  const basicEnabled = document.getElementById('basic-enabled').checked;
  const basicStatus = document.getElementById('basic-status');
  
  if (basicEnabled) {
    basicStatus.textContent = '활성화';
    basicStatus.className = 'status-indicator status-active';
  } else {
    basicStatus.textContent = '비활성화';
    basicStatus.className = 'status-indicator status-inactive';
  }
  
  // 매시간 상태 (새로 추가)
  const hourlyEnabled = document.getElementById('hourly-enabled').checked;
  const hourlyStatus = document.getElementById('hourly-status');
  
  if (hourlyEnabled) {
    hourlyStatus.textContent = '활성화';
    hourlyStatus.className = 'status-indicator status-active';
  } else {
    hourlyStatus.textContent = '비활성화';
    hourlyStatus.className = 'status-indicator status-inactive';
  }
}

// 모든 설정 저장
function saveAllSettings() {
  // 유효성 검사
  const partnerEnabled = document.getElementById('partner-enabled').checked;
  const basicEnabled = document.getElementById('basic-enabled').checked;
  const hourlyEnabled = document.getElementById('hourly-enabled').checked;
  
  if (partnerEnabled) {
    const partnerStart = document.getElementById('partner-start-time').value;
    const partnerEnd = document.getElementById('partner-end-time').value;
    
    if (!partnerStart || !partnerEnd) {
      alert('총판 출금 차단이 활성화된 경우 시작 시간과 종료 시간을 모두 입력해주세요.\n12시간 형식: 예 - 오후 11:00, 오전 06:00)');
      return;
    }
  }
  
  if (basicEnabled) {
    const basicStart = document.getElementById('basic-start-time').value;
    const basicEnd = document.getElementById('basic-end-time').value;
    
    if (!basicStart || !basicEnd) {
      alert('가맹점 출금 차단이 활성화된 경우 시작 시간과 종료 시간을 모두 입력해주세요.\n(12시간 형식: 예 - 오후 06:00, 오전 09:00)');
      return;
    }
  }
  
  // 설정 데이터 구성
  const settingsData = {
    partner_withdraw_block_enabled: partnerEnabled ? 1 : 0,
    partner_withdraw_block_start: partnerEnabled ? document.getElementById('partner-start-time').value : null,
    partner_withdraw_block_end: partnerEnabled ? document.getElementById('partner-end-time').value : null,
    basic_withdraw_block_enabled: basicEnabled ? 1 : 0,
    basic_withdraw_block_start: basicEnabled ? document.getElementById('basic-start-time').value : null,
    basic_withdraw_block_end: basicEnabled ? document.getElementById('basic-end-time').value : null,
    hourly_withdraw_block_enabled: hourlyEnabled ? 1 : 0  // 새로 추가
  };
  
  console.log('저장할 데이터:', settingsData);
  
  // 저장 요청
  fetch('ajax/save_withdraw_settings.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify(settingsData)
  })
  .then(response => response.text())
  .then(text => {
    console.log('저장 응답:', text);
    try {
      const data = JSON.parse(text);
      if (data.success) {
        alert('설정이 성공적으로 저장되었습니다.');
        updateStatusIndicators();
      } else {
        alert(data.message || '설정 저장 중 오류가 발생했습니다.');
      }
    } catch (e) {
      console.error('응답 파싱 오류:', e);
      showDebug('저장 응답 파싱 실패: ' + text);
    }
  })
  .catch(error => {
    console.error('설정 저장 실패:', error);
    alert('설정 저장 중 오류가 발생했습니다: ' + error.message);
  });
}
</script>

</body>
</html>